---
generated_at: 2026-01-13 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：28-タスク一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **バケット設定の具体的な値**：Setting依存のため動的

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/tasks_controller.rb` - TasksController定義
- E-02: `app/models/polymorphic/task.rb` - Taskモデル定義
- E-03: `app/views/tasks/index.html.haml` - 一覧画面ビュー
- E-04: `config/routes.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/tasks` でアクセス可能 | E-04 (144行目) | ○ |
| C-02 | TasksController#indexで処理される | E-01 (14-23行目) | ○ |
| C-03 | @tasksにバケット別タスクハッシュがセットされる | E-01 (16行目) | ○ |
| C-04 | @viewに現在のビュー種別がセットされる | E-01 (15行目) | ○ |
| C-05 | ALLOWED_VIEWSでpending/assigned/completedを許可 | E-02 (35行目) | ○ |
| C-06 | find_all_groupedでバケット別取得 | E-02 (177-186行目) | ○ |
| C-07 | myスコープで自分のタスクを取得 | E-02 (46-53行目) | ○ |
| C-08 | assigned_byスコープで割り当てたタスクを取得 | E-02 (59-62行目) | ○ |
| C-09 | due_asapスコープ | E-02 (89行目) | ○ |
| C-10 | overdueスコープ | E-02 (90行目) | ○ |
| C-11 | due_todayスコープ | E-02 (91行目) | ○ |
| C-12 | due_tomorrowスコープ | E-02 (92行目) | ○ |
| C-13 | due_this_weekスコープ | E-02 (93行目) | ○ |
| C-14 | due_next_weekスコープ | E-02 (94行目) | ○ |
| C-15 | due_laterスコープ | E-02 (95行目) | ○ |
| C-16 | completeアクションでタスク完了 | E-01 (119-128行目), E-04 (150行目) | ○ |
| C-17 | uncompleteアクションで未完了に戻す | E-01 (132-141行目), E-04 (151行目) | ○ |
| C-18 | CSV/XLSエクスポート対応 | E-01 (18-21行目) | ○ |
| C-19 | 機能No.34 タスク一覧表示が主機能 | E-05 (58行目) | ○ |
| C-20 | 機能No.41 タスクフィルタリングが補助機能 | E-05 (59行目) | ○ |
| C-21 | 機能No.38 タスク削除が補助機能 | E-05 (104行目) | ○ |
| C-22 | totalsメソッドでバケット別件数取得 | E-02 (202-212行目) | ○ |
| C-23 | bucket_empty?でバケット空判定 | E-02 (189-199行目) | ○ |
| C-24 | バケット設定の具体的な値 | **根拠なし（Setting依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-24**: バケットの具体的な値は`Setting.task_bucket`/`Setting.task_completed`から動的に取得されるため、実際の値はシステム設定に依存する
  - 候補：`config/settings/task_bucket.yml` / `config/settings/task_completed.yml`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - タスク取得ロジックはスコープで明確に定義
- **0: 低リスク** - 完了/未完了切替ロジックは明確
- **1: 中リスク** - バケット設定がシステム設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] 3つのビュー（pending/assigned/completed）が正しく切り替わることを確認
- [ ] バケットが空になった場合の非表示処理が正しく動作することを確認
- [ ] 完了/未完了切替がcompleted_atとcompleted_byを正しく更新することを確認
- [ ] CSV/XLSエクスポートが全件出力されることを確認
- [ ] セッションにフィルター状態が正しく保存されることを確認
