---
generated_at: 2026-01-13 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-タスク新規作成フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/tasks_controller.rb` - TasksController定義
- E-02: `app/models/polymorphic/task.rb` - Taskモデル定義
- E-03: `app/views/tasks/_new.html.haml` - 新規作成フォームビュー
- E-04: `app/views/tasks/_top_section.html.haml` - 入力項目セクション
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/tasks/new` でフォーム表示 | E-05 (144行目) | ○ |
| C-02 | POST `/tasks` で作成実行 | E-05 (144行目) | ○ |
| C-03 | TasksController#newで処理 | E-01 (34-50行目) | ○ |
| C-04 | TasksController#createで作成処理 | E-01 (68-77行目) | ○ |
| C-05 | @bucketにバケット選択肢がセットされる | E-01 (37行目) | ○ |
| C-06 | @categoryにカテゴリ選択肢がセットされる | E-01 (38行目) | ○ |
| C-07 | 関連エンティティをrelatedパラメータで受け取る | E-01 (40-46行目) | ○ |
| C-08 | nameの必須バリデーション | E-02 (117行目) | ○ |
| C-09 | calendarの条件付き必須バリデーション | E-02 (118行目) | ○ |
| C-10 | specific_time検証 | E-02 (119行目, 279-283行目) | ○ |
| C-11 | set_due_dateでbucketからdue_at計算 | E-02 (121行目, 217-234行目) | ○ |
| C-12 | フォームはremote: trueでAjax送信 | E-03 (1行目) | ○ |
| C-13 | user_id, asset_id, asset_typeをhidden_field | E-03 (4-6行目) | ○ |
| C-14 | bucketドロップダウンでcrm.flip_calendar呼び出し | E-04 (13行目) | ○ |
| C-15 | 機能No.36 タスク作成が主機能 | E-06 (60行目) | ○ |
| C-16 | due_todayの計算（本日0:00） | E-02 (222行目) | ○ |
| C-17 | due_tomorrowの計算（明日0:00） | E-02 (224行目) | ○ |
| C-18 | due_this_weekの計算（今週末） | E-02 (226行目) | ○ |
| C-19 | due_next_weekの計算（来週末） | E-02 (228行目) | ○ |
| C-20 | specific_timeの場合カレンダーから日時解析 | E-02 (232行目, 286-288行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - バリデーションルールはモデルで明確に定義
- **0: 低リスク** - 期日計算ロジックはset_due_dateで確認済み
- **0: 低リスク** - ポリモーフィック関連も明確

## 6) レビュアーチェックリスト（最小）
- [ ] 各bucketの期日計算が正しいことを確認
- [ ] specific_time選択時のカレンダー表示切替が正しく動作することを確認
- [ ] 関連エンティティ（asset_id/asset_type）が正しく設定されることを確認
- [ ] Setting.task_calendar_with_timeによる時刻入力可否が正しく動作することを確認
