---
generated_at: 2026-01-13 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-タスク編集フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/tasks_controller.rb` - TasksController定義
- E-02: `app/models/polymorphic/task.rb` - Taskモデル定義
- E-03: `app/views/tasks/_edit.html.haml` - 編集フォームビュー
- E-04: `app/views/tasks/_top_section.html.haml` - 入力項目セクション
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/tasks/:id/edit` でフォーム表示 | E-05 (144行目) | ○ |
| C-02 | PATCH `/tasks/:id` で更新実行 | E-05 (144行目) | ○ |
| C-03 | TasksController#editで処理 | E-01 (54-64行目) | ○ |
| C-04 | TasksController#updateで更新処理 | E-01 (81-101行目) | ○ |
| C-05 | @taskはtracked_byスコープで取得 | E-01 (56行目, 83行目) | ○ |
| C-06 | @assetに既存関連エンティティがセットされる | E-01 (59行目) | ○ |
| C-07 | @previousで前のタスクを取得 | E-01 (61行目) | ○ |
| C-08 | @task_before_updateで更新前状態を保持 | E-01 (84行目) | ○ |
| C-09 | 更新前バケットのoverdue判定 | E-01 (86-90行目) | ○ |
| C-10 | before_update :set_due_dateで期日再計算 | E-02 (122行目) | ○ |
| C-11 | completed?の場合はset_due_dateをスキップ | E-02 (122行目 unless: :completed?) | ○ |
| C-12 | computed_bucketでバケット計算 | E-01 (94行目), E-02 (157-173行目) | ○ |
| C-13 | フォームはremote: trueでAjax送信 | E-03 (2行目) | ○ |
| C-14 | asset_id, asset_typeをhidden_fieldで保持 | E-03 (5-6行目) | ○ |
| C-15 | クイックリスケジュールリンクの生成 | E-03 (16-18行目) | ○ |
| C-16 | crm.reschedule_task関数呼び出し | E-03 (17行目) | ○ |
| C-17 | specific_time時に既存due_atを表示 | E-04 (15-18行目) | ○ |
| C-18 | @empty_bucket判定 | E-01 (96行目) | ○ |
| C-19 | bucket_empty?メソッドでバケット空判定 | E-02 (189-199行目) | ○ |
| C-20 | PaperTrailによる変更履歴追跡 | E-02 (111-112行目) | ○ |
| C-21 | nameの必須バリデーション | E-02 (117行目) | ○ |
| C-22 | calendarの条件付き必須バリデーション | E-02 (118行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 更新前後のバケット比較ロジックは明確
- **0: 低リスク** - クイックリスケジュール機能はJS関数で実装
- **0: 低リスク** - specific_time時の既存値表示も明確

## 6) レビュアーチェックリスト（最小）
- [ ] 更新前バケットと更新後バケットの比較が正しく動作することを確認
- [ ] クイックリスケジュールリンクが正しく期日を変更することを確認
- [ ] specific_time選択時に既存のdue_atがカレンダーフィールドに正しく表示されることを確認
- [ ] 完了済みタスク編集時にset_due_dateがスキップされることを確認
- [ ] @empty_bucket判定により空になったバケットが非表示になることを確認
- [ ] tracked_byスコープにより権限のないタスクへのアクセスが拒否されることを確認
