---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：31-ユーザー一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **将来の実装予定**：根拠不足（コード上に実装予定のコメントやTODOが確認できない）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/users/index.html.haml`（1-3行目）
- E-02: `app/controllers/users_controller.rb`（8-161行目）
- E-03: `config/routes.rb`（22-29行目）
- E-04: `app/models/users/user.rb`（48-215行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（32行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（64行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は「未実装」と表示される | E-01（3行目: `%p #{t :not_implemented}`） | ○ |
| C-02 | URL は /users である | E-03（23行目: `resources :users, only: %i[index show]`） | ○ |
| C-03 | DeviseスコープでUsersControllerにルーティングされる | E-03（22行目: `devise_scope :user do`） | ○ |
| C-04 | タイトルは「User」と表示される | E-01（2行目: `.title #{t :user}`） | ○ |
| C-05 | load_and_authorize_resourceで権限制御 | E-02（13行目: `load_and_authorize_resource`） | ○ |
| C-06 | indexアクションはコントローラに未定義 | E-02（indexメソッドが存在しない） | ○ |
| C-07 | Userモデルはデータベースの users テーブルと対応 | E-04（Schema情報 10-46行目） | ○ |
| C-08 | 関連機能はユーザープロファイル表示（機能No.47） | E-06（64行目） | ○ |
| C-09 | 認証済みユーザーのみアクセス可能 | E-02（11行目: `check_authorization`） | ○ |
| C-10 | 管理者向けユーザー管理は Admin::UsersController で提供 | E-03（168-177行目: `resources :users`） | ○ |
| C-11 | 商談概要画面への遷移が可能 | E-03（25行目: `get :opportunities_overview`） | ○ |
| C-12 | 将来の実装予定機能（検索・フィルタリング等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- 将来の実装予定に関する記述はコード上に確認できない
  - 候補：開発者コメント / TODOファイル / IssueTracker / プロジェクトドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 画面が未実装であることはコードから明確に確認できる
- 1: 中リスク - 将来の実装予定に関する主張は推測に基づく

## 6) レビュアーチェックリスト（最小）

- [ ] index.html.haml で「not_implemented」が表示されることを確認
- [ ] routes.rb の devise_scope 内で users リソースが定義されていることを確認
- [ ] UsersController に index アクションが存在しないことを確認
- [ ] 将来の実装予定に関する記述が必要かどうか検討
