---
generated_at: 2026-01-13 10:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-ユーザー詳細画面（プロフィール）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/users/show.html.haml`（1-15行目）
- E-02: `app/views/users/_user.html.haml`（1-34行目）
- E-03: `app/views/users/_profile.html.haml`（1-74行目）
- E-04: `app/views/users/_avatar.html.haml`（1-20行目）
- E-05: `app/views/users/edit.js.haml`（1-9行目）
- E-06: `app/controllers/users_controller.rb`（1-161行目）
- E-07: `app/models/users/user.rb`（1-215行目）
- E-08: `config/routes.rb`（155-163行目、33行目）
- E-09: `db/schema.rb`（433-475行目、125-134行目、360-367行目）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（65-69行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションはparams[:id]がnilの場合current_userを使用 | E-06（21行目: `@user = current_user if params[:id].nil?`） | ○ |
| C-02 | 自分または管理者の場合のみ編集リンクを表示 | E-01（2行目: `if @user == current_user \|\| current_user.admin?`） | ○ |
| C-03 | edit_profile, upload_avatar, change_password の3つの編集機能がある | E-01（3-5行目: 各link_to_inline） | ○ |
| C-04 | load_and_authorize_resource で権限制御 | E-06（13行目） | ○ |
| C-05 | プロフィール編集フォームには氏名、連絡先、通知設定がある | E-03（9-67行目） | ○ |
| C-06 | アバターはファイルアップロードまたはGravatarを選択可能 | E-04（10-17行目） | ○ |
| C-07 | per_user_locale設定が有効な場合のみ言語選択を表示 | E-02（1行目、32行目） | ○ |
| C-08 | upload_avatarはiframeを使用した非同期処理 | E-06（65-67行目: `responds_to_parent`） | ○ |
| C-09 | パスワード変更は現在のパスワード検証が必要 | E-06（82行目: `valid_password?`） | ○ |
| C-10 | メール項目にstrip処理が行われる | E-06（131-132行目: `email.try(:strip!)`） | ○ |
| C-11 | 更新成功時にmsg_user_updatedメッセージを表示 | E-06（36行目: `flash[:notice] = t(:msg_user_updated)`） | ○ |
| C-12 | パスワード変更成功時にmsg_password_changedメッセージを表示 | E-06（89行目） | ○ |
| C-13 | パスワードが空白の場合msg_password_not_changedを表示 | E-06（84行目） | ○ |
| C-14 | 現在パスワードが不正の場合エラーを追加 | E-06（92行目: `errors.add(:current_password, t(:msg_invalid_password))`） | ○ |
| C-15 | アバター画像が無効な場合msg_bad_image_fileを表示 | E-06（62行目） | ○ |
| C-16 | ロケール変更はredrawアクションで処理 | E-06（100-103行目） | ○ |
| C-17 | Userモデルはhas_one :avatarのアソシエーションを持つ | E-07（53行目） | ○ |
| C-18 | Userモデルはhas_many :preferencesのアソシエーションを持つ | E-07（63行目） | ○ |
| C-19 | URL /profile で自分のプロフィールにアクセス可能 | E-08（33行目: `get 'profile' => 'users#show'`） | ○ |
| C-20 | subscribe_to_comment_replies, receive_assigned_notifications の設定がある | E-03（62-67行目）、E-06（147-148行目） | ○ |
| C-21 | usersテーブルにsubscribe_to_comment_replies, receive_assigned_notifications列がある | E-09（467-468行目） | ○ |
| C-22 | hook(:show_user_bottom, self)で拡張ポイントが提供されている | E-01（13行目） | ○ |
| C-23 | 関連機能No.47-51（プロファイル表示、編集、アバター、パスワード、ロケール） | E-10（65-69行目） | ○ |
| C-24 | アバターフォームはPNG/JPEG/GIF対応 | E-04（11行目: `accept: 'image/png,image/jpeg,image/gif'`） | ○ |
| C-25 | プロフィール表示に電話番号のtel:リンクがある | E-02（22-29行目: `link_to_phone`） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がコードベースから検証可能

## 6) レビュアーチェックリスト（最小）

- [ ] show.html.haml で権限に応じた編集リンク表示を確認
- [ ] users_controller.rb の各アクション処理フローを確認
- [ ] _profile.html.haml のフォーム項目が設計書と一致することを確認
- [ ] _avatar.html.haml のアップロード処理（responds_to_parent）を確認
- [ ] パスワード変更時のバリデーションロジックを確認
