---
generated_at: 2026-01-13 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-商談概要画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/users/opportunities_overview.html.haml`（1-16行目）
- E-02: `app/views/users/_user_report.html.haml`（1-6行目）
- E-03: `app/controllers/users_controller.rb`（107-110行目）
- E-04: `app/models/users/user.rb`（81-85行目）
- E-05: `config/routes.rb`（25行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（70行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /users/opportunities_overview である | E-05（25行目: `get :opportunities_overview`） | ○ |
| C-02 | have_assigned_opportunitiesスコープで商談を持つユーザーを取得 | E-03（108行目）、E-04（81-85行目） | ○ |
| C-03 | 未割当商談はOpportunity.my.unassigned.pipelineで取得 | E-03（109行目） | ○ |
| C-04 | 商談が存在しない場合「no_opportunities_found」メッセージを表示 | E-01（16行目: `t(:no_opportunities_found)`） | ○ |
| C-05 | have_assigned_opportunitiesはINNER JOINを使用 | E-04（82行目: `joins("INNER JOIN opportunities...")`） | ○ |
| C-06 | lost/won以外のステージの商談が表示される | E-04（83行目: `stage <> 'lost' AND stage <> 'won'`） | ○ |
| C-07 | ユーザーはfirst_nameでソート | E-03（108行目: `order(:first_name)`） | ○ |
| C-08 | 未割当商談はstageでソート | E-03（109行目: `order(:stage)`） | ○ |
| C-09 | styles_for :opportunityで商談スタイルを読み込み | E-01（1行目） | ○ |
| C-10 | _user_reportパーシャルで描画 | E-01（7行目: `render partial: "_user_report"`） | ○ |
| C-11 | #unassignedセクションで未割当商談を表示 | E-01（9行目: `#unassigned`） | ○ |
| C-12 | 関連機能は商談サマリー（機能No.33） | E-06（70行目） | ○ |
| C-13 | user_reportのassigned_opportunitiesを金額降順で表示 | E-02（6行目: `order("opportunities.amount DESC")`） | ○ |
| C-14 | includes(:account, :user, :tags)で関連データを先読み | E-03（109行目） | ○ |
| C-15 | DISTINCTでユーザーの重複を排除 | E-04（84行目: `select('DISTINCT(users.id), users.*')`） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がコードベースから検証可能

## 6) レビュアーチェックリスト（最小）

- [ ] opportunities_overview.html.haml の表示ロジックを確認
- [ ] have_assigned_opportunities スコープのJOIN条件を確認
- [ ] unassigned.pipeline スコープの定義を確認
- [ ] _user_report.html.haml の商談ソート順（金額降順）を確認
