---
generated_at: 2026-01-13 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-ユーザー管理一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/users/index.html.haml`（1-14行目）
- E-02: `app/views/admin/users/_user.html.haml`（1-69行目）
- E-03: `app/controllers/admin/users_controller.rb`（1-152行目）
- E-04: `app/models/users/user.rb`（111-178行目）
- E-05: `config/routes.rb`（168-177行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（71、105行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/users である | E-05（168行目: `resources :users`） | ○ |
| C-02 | suspend アクションで suspended_at を Time.now に更新 | E-03（87-90行目） | ○ |
| C-03 | reactivate アクションで suspended_at を nil に更新 | E-03（96-100行目） | ○ |
| C-04 | 自分自身のアカウントは停止できない | E-03（88行目: `if @user != current_user`） | ○ |
| C-05 | destroyable? で削除可否をチェック | E-03（75行目: `@user.destroyable?(current_user) && @user.destroy`） | ○ |
| C-06 | get_users で ransack 検索を使用 | E-03（138行目: `klass.ransack(params[:q])`） | ○ |
| C-07 | ページネーションに paginate を使用 | E-03（145行目: `scope.paginate(page: current_page)`） | ○ |
| C-08 | ステータスバッジは4種類（signed_up/suspended/admin/active） | E-02（3-10行目） | ○ |
| C-09 | awaits_approval? は suspended && sign_in_count == 0 && needs_approval で判定 | E-04（116-118行目） | ○ |
| C-10 | suspended? は suspended_at != nil で判定 | E-04（111-113行目） | ○ |
| C-11 | create_user リンクで新規作成フォームを表示 | E-01（4行目: `link_to_inline(:create_user, new_admin_user_path)`） | ○ |
| C-12 | ユーザー一覧は _user パーシャルで描画 | E-01（11行目: `render partial: "admin/users/user", collection: @users`） | ○ |
| C-13 | アバターは 30x30 サイズで表示 | E-02（12行目: `avatar_for(user, width: '30', height: '30')`） | ○ |
| C-14 | グループ情報を表示 | E-02（64-68行目: `groups.map(&:name).join(', ')`） | ○ |
| C-15 | 編集リンクは edit_admin_user_path を使用 | E-02（16行目: `link_to_edit(user, url: edit_admin_user_path(user))`） | ○ |
| C-16 | 停止中ユーザーには再有効化リンクを表示 | E-02（18-19行目: `if user.suspended?`） | ○ |
| C-17 | 削除リンクは確認ダイアログ付き | E-02（26-27行目: `link_to_confirm(user)`） | ○ |
| C-18 | 自分自身の削除リンクはグレーアウト | E-02（29行目: `%span.grayed #{t :delete}?`） | ○ |
| C-19 | ページネーション機能がある | E-01（12行目: `render "shared/paginate"`） | ○ |
| C-20 | エクスポート機能がある | E-01（13行目: `render "shared/export"`） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がコードベースから検証可能

## 6) レビュアーチェックリスト（最小）

- [ ] admin/users_controller.rb の suspend/reactivate アクションを確認
- [ ] _user.html.haml のステータスバッジ表示ロジックを確認
- [ ] destroyable? メソッドの実装を確認
- [ ] 自分自身の操作が適切に制限されていることを確認
