---
generated_at: 2026-01-13 10:50:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-ユーザー管理詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/users/show.html.haml`（1-6行目）
- E-02: `app/controllers/admin/users_controller.rb`（23-26行目、11行目）
- E-03: `app/models/users/user.rb`（106-108行目）
- E-04: `config/routes.rb`（168行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（72-74行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/users/:id である | E-04（168行目: `resources :users`） | ○ |
| C-02 | フルネームをタイトルとして表示 | E-01（1行目: `.title= h(@user.full_name)`） | ○ |
| C-03 | h() でXSSエスケープ処理 | E-01（1行目: `h(@user.full_name)`） | ○ |
| C-04 | 編集リンク（Edit）がある | E-01（4行目: `link_to t(:edit), edit_admin_user_path(@user)`） | ○ |
| C-05 | 戻りリンク（Back）がある | E-01（5行目: `link_to t(:back), admin_users_path`） | ○ |
| C-06 | load_resource で @user をロード | E-02（11行目: `load_resource except: [:create]`） | ○ |
| C-07 | show アクションで respond_with を使用 | E-02（25行目: `respond_with(@user)`） | ○ |
| C-08 | full_name は first_name と last_name を結合して返す | E-03（107行目） | ○ |
| C-09 | 姓名が空の場合は email を返す | E-03（107行目: `first_name.blank? && last_name.blank? ? email : ...`） | ○ |
| C-10 | 関連機能はユーザー管理一覧、アカウント停止、再有効化 | E-05（72-74行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がコードベースから検証可能
- 本画面は非常にシンプルな構成のため、リスクは低い

## 6) レビュアーチェックリスト（最小）

- [ ] show.html.haml の構造を確認
- [ ] h() によるXSSエスケープが適切に行われていることを確認
- [ ] full_name メソッドの実装を確認
