---
generated_at: 2026-01-13 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-ユーザー管理新規作成フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/users/_new.html.haml`（1-11行目）
- E-02: `app/views/admin/users/_profile.html.haml`（1-55行目）
- E-03: `app/controllers/admin/users_controller.rb`（31-33、46-52、104-129行目）
- E-04: `app/models/users/user.rb`（87-98、182-184行目）
- E-05: `config/routes.rb`（168行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（75行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/users/new である | E-05（168行目: `resources :users`） | ○ |
| C-02 | フォームは Ajax (remote: true) で送信 | E-01（2行目: `remote: true`） | ○ |
| C-03 | one_submit_only で二重送信防止 | E-01（2行目: `one_submit_only`） | ○ |
| C-04 | autocomplete: 'off' でブラウザ自動入力無効 | E-01（2行目: `autocomplete: 'off'`） | ○ |
| C-05 | _profile パーシャルを使用してフォーム構成 | E-01（7行目: `render "admin/users/profile", f: f`） | ○ |
| C-06 | username, email, password の入力フィールドがある | E-02（6-19行目） | ○ |
| C-07 | 管理者チェックボックス（admin）がある | E-02（22-26行目: `f.check_box(:admin, ...)`） | ○ |
| C-08 | 個人情報（first_name, last_name, title, company）入力がある | E-02（28-47行目） | ○ |
| C-09 | グループ選択は select2 で複数選択 | E-02（53-54行目: `f.select :group_ids, ... multiple: true, class: 'select2'`） | ○ |
| C-10 | User.new(user_params) で新規オブジェクト作成 | E-03（47行目） | ○ |
| C-11 | suspend_if_needs_approval を呼び出し | E-03（48行目） | ○ |
| C-12 | suspend_if_needs_approval は needs_approval 設定時に suspended_at を設定 | E-04（182-184行目） | ○ |
| C-13 | user_params で email の strip! 処理 | E-03（108行目: `params[:user][:email].try(:strip!)`） | ○ |
| C-14 | user_params で group_ids: [] を許可 | E-03（127行目） | ○ |
| C-15 | username バリデーション（一意性、形式、必須） | E-04（92-95行目） | ○ |
| C-16 | email バリデーション（一意性、形式、必須） | E-04（87-91行目） | ○ |
| C-17 | password バリデーション（存在確認、確認一致） | E-04（96-98行目） | ○ |
| C-18 | 関連機能はユーザー作成（機能No.60） | E-06（75行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がコードベースから検証可能

## 6) レビュアーチェックリスト（最小）

- [ ] _new.html.haml のフォーム構造を確認
- [ ] _profile.html.haml の入力フィールドを確認
- [ ] user_params の許可パラメータを確認
- [ ] suspend_if_needs_approval の動作を確認
- [ ] バリデーションの実装を確認
