---
generated_at: 2026-01-13 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-グループ管理一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/groups/index.html.haml`（1-19行目）
- E-02: `app/views/admin/groups/_group.html.haml`（1-17行目）
- E-03: `app/controllers/admin/groups_controller.rb`（1-71行目）
- E-04: `app/models/users/group.rb`（1-15行目）
- E-05: `config/routes.rb`（166行目）
- E-06: `db/schema.rb`（273-285行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（77、106行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/groups である | E-05（166行目: `resources :groups`） | ○ |
| C-02 | @groups.unscoped.paginate で一覧取得 | E-03（16行目） | ○ |
| C-03 | create_group リンクで新規作成フォーム表示 | E-01（4行目: `link_to_inline(:create_group, new_admin_group_path)`） | ○ |
| C-04 | グループが空の場合 shared/empty を表示 | E-01（15-16行目） | ○ |
| C-05 | styles_for :group でスタイル読み込み | E-01（1行目） | ○ |
| C-06 | ページネーションは shared/paginate で表示 | E-01（18行目） | ○ |
| C-07 | _group パーシャルで行表示 | E-01（14行目: `render partial: "group", collection: @groups`） | ○ |
| C-08 | link_to_edit で編集リンク | E-02（4行目） | ○ |
| C-09 | Permission.where(group_id:).count で削除確認 | E-02（5-6行目） | ○ |
| C-10 | confirm_group_delete メッセージ | E-02（6行目: `t(:confirm_group_delete, count)`） | ○ |
| C-11 | グループ名リンクは Ajax 編集対応 | E-02（10-11行目: `remote: true, onclick: ...`） | ○ |
| C-12 | メンバーリストを表示 | E-02（13-16行目） | ○ |
| C-13 | Group は has_and_belongs_to_many :users | E-04（9行目） | ○ |
| C-14 | Group は has_many :permissions | E-04（10行目） | ○ |
| C-15 | destroy で @group.destroy 実行 | E-03（56-59行目） | ○ |
| C-16 | 関連機能はグループ管理一覧、グループ削除 | E-07（77、106行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がコードベースから検証可能

## 6) レビュアーチェックリスト（最小）

- [ ] index.html.haml の構造を確認
- [ ] _group.html.haml の削除確認ロジックを確認
- [ ] Permission.count による確認メッセージ生成を確認
- [ ] Groupモデルのアソシエーションを確認
