---
generated_at: 2026-01-13 11:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-グループ管理詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/groups/show.html.haml`（1-12行目）
- E-02: `app/controllers/admin/groups_controller.rb`（12、20-23行目）
- E-03: `app/models/users/group.rb`（9行目）
- E-04: `config/routes.rb`（166行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（78行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/groups/:id である | E-04（166行目: `resources :groups`） | ○ |
| C-02 | グループ名をタイトルとして表示 | E-01（1行目: `.title= h(@group.name)`） | ○ |
| C-03 | h() でXSSエスケープ処理 | E-01（1行目、6行目: `h(@group.name)`, `h(user.name)`） | ○ |
| C-04 | メンバー一覧を @group.users.each でループ表示 | E-01（4行目: `@group.users.each do \|user\|`） | ○ |
| C-05 | 編集リンク（Edit）がある | E-01（9行目: `link_to t(:edit), edit_admin_group_path(@group)`） | ○ |
| C-06 | 戻りリンク（Back）がある | E-01（11行目: `link_to t(:back), admin_groups_path`） | ○ |
| C-07 | load_resource で @group をロード | E-02（12行目: `load_resource`） | ○ |
| C-08 | show アクションで respond_with を使用 | E-02（22行目: `respond_with(@group)`） | ○ |
| C-09 | Group は has_and_belongs_to_many :users | E-03（9行目） | ○ |
| C-10 | メンバーは .members セクションで表示 | E-01（3行目: `.members`） | ○ |
| C-11 | ユーザー名は .user クラスで表示 | E-01（5行目: `.user`） | ○ |
| C-12 | 関連機能はグループ管理一覧（機能No.65） | E-05（78行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がコードベースから検証可能
- 本画面は非常にシンプルな構成のため、リスクは低い

## 6) レビュアーチェックリスト（最小）

- [ ] show.html.haml の構造を確認
- [ ] h() によるXSSエスケープが適切に行われていることを確認
- [ ] @group.users のアソシエーションが正しく動作することを確認
