---
generated_at: 2026-01-13 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-グループ管理新規作成フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/groups/_new.html.haml`（1-13行目）
- E-02: `app/views/admin/groups/_form.html.haml`（1-11行目）
- E-03: `app/controllers/admin/groups_controller.rb`（26-28、38-44、64-66行目）
- E-04: `app/models/users/group.rb`（9、12行目）
- E-05: `config/routes.rb`（166行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（79行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /admin/groups/new である | E-05（166行目: `resources :groups`） | ○ |
| C-02 | フォームは Ajax (remote: true) で送信 | E-01（2行目: `remote: true`） | ○ |
| C-03 | one_submit_only で二重送信防止 | E-01（2行目: `one_submit_only`） | ○ |
| C-04 | autocomplete: 'off' でブラウザ自動入力無効 | E-01（2行目: `autocomplete: 'off'`） | ○ |
| C-05 | _form パーシャルを使用してフォーム構成 | E-01（7行目: `render "admin/groups/form", f: f`） | ○ |
| C-06 | グループ名入力フィールドがある | E-02（5-6行目: `f.text_field :name`） | ○ |
| C-07 | ユーザー選択は select2 で複数選択 | E-02（10-11行目: `f.select :user_ids, ... multiple: true, class: 'select2'`） | ○ |
| C-08 | User.all.map で全ユーザーを選択肢として表示 | E-02（11行目） | ○ |
| C-09 | @group.attributes = group_params で属性設定 | E-03（40行目） | ○ |
| C-10 | @group.save で保存 | E-03（41行目） | ○ |
| C-11 | group_params で :name と user_ids: [] を許可 | E-03（65行目: `params.require(:group).permit(:name, user_ids: [])`） | ○ |
| C-12 | Group は has_and_belongs_to_many :users | E-04（9行目） | ○ |
| C-13 | validates :name, presence: true, uniqueness: true | E-04（12行目） | ○ |
| C-14 | 送信ボタンは create_group ラベル | E-01（10行目: `f.submit t(:create_group)`） | ○ |
| C-15 | 関連機能はグループ作成（機能No.66） | E-06（79行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がコードベースから検証可能

## 6) レビュアーチェックリスト（最小）

- [ ] _new.html.haml のフォーム構造を確認
- [ ] _form.html.haml の入力フィールドを確認
- [ ] group_params の許可パラメータを確認
- [ ] Groupモデルのバリデーションを確認
- [ ] ユーザー選択のselect2動作を確認
