---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：41-グループ管理編集フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Select2適用の詳細動作**：JavaScript実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/admin/groups/_edit.html.haml`
- E-02: `app/views/admin/groups/_form.html.haml`
- E-03: `app/controllers/admin/groups_controller.rb`
- E-04: `app/models/users/group.rb`
- E-05: `config/routes.rb`
- E-06: `db/schema.rb`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者のみがアクセス可能 | E-03（Admin::ApplicationControllerを継承） | ○ |
| C-02 | URLは `/admin/groups/:id/edit` | E-05（166行目 `resources :groups`） | ○ |
| C-03 | グループ名は必須・一意性制約あり | E-04（12行目 `validates :name, presence: true, uniqueness: true`） | ○ |
| C-04 | ユーザーとの多対多関連 | E-04（9行目 `has_and_belongs_to_many :users`）、E-06（279-285行目） | ○ |
| C-05 | form_forでリソースフルフォーム生成 | E-01（2行目 `form_for([:admin, @group], ...)`） | ○ |
| C-06 | group_paramsでStrong Parameters適用 | E-03（64-66行目） | ○ |
| C-07 | load_resourceで自動ロード | E-03（11行目 `load_resource`） | ○ |
| C-08 | updateアクションでグループ更新 | E-03（48-52行目） | ○ |
| C-09 | エラーメッセージはフォーム上部に表示 | E-01（5行目 `f.error_messages`） | ○ |
| C-10 | one_submit_onlyで二重送信防止 | E-01（2行目 `one_submit_only.merge`） | ○ |
| C-11 | キャンセルリンクでフォームを閉じる | E-01（12行目 `link_to_cancel`） | ○ |
| C-12 | groupsテーブルにname列がある | E-06（274行目） | ○ |
| C-13 | groups_usersテーブルが中間テーブル | E-06（279-285行目） | ○ |
| C-14 | 機能No.67がグループ編集 | E-07（80行目） | ○ |
| C-15 | remoteオプションでAjaxリクエスト | E-01（2行目 `remote: true`） | ○ |
| C-16 | 保存ボタンのラベルは「Save Group」相当 | E-01（10行目 `t(:save_group)`） | ○ |
| C-17 | ユーザー選択はSelect2で複数選択可能 | E-02（11行目 `class: 'select2'`） | ○ |
| C-18 | Select2の詳細動作（検索・フィルタリング機能） | **根拠なし**（JavaScript実装未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- Select2のJavaScript初期化コードの詳細実装
  - 候補：`app/assets/javascripts/` 配下のJS / `vendor/assets/` / Gemによる提供

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - Select2の動作詳細はフロントエンド実装の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] グループ名の一意性制約が実際に動作することを確認
- [ ] ユーザー複数選択UIの動作確認（Select2）
- [ ] 管理者以外のアクセス時のリダイレクト動作確認
- [ ] バリデーションエラー時のメッセージ表示確認
