---
generated_at: 2026-01-13 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：42-タグ管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **AIプロンプト機能の詳細動作**：実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/tags/index.html.haml`
- E-02: `app/views/admin/tags/_tag.html.haml`
- E-03: `app/controllers/admin/tags_controller.rb`
- E-04: `app/models/polymorphic/tag.rb`
- E-05: `config/routes.rb`
- E-06: `db/schema.rb`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者のみがアクセス可能 | E-03（Admin::ApplicationControllerを継承） | ○ |
| C-02 | URLは `/admin/tags` | E-05（200-204行目） | ○ |
| C-03 | ActsAsTaggableOn::Tagを継承 | E-04（8行目） | ○ |
| C-04 | Tag.allで全タグを取得 | E-03（17行目） | ○ |
| C-05 | 新規作成リンクでインラインフォーム表示 | E-01（4行目 `link_to_inline`） | ○ |
| C-06 | タグパーシャルで一覧表示 | E-01（13行目 `render partial`） | ○ |
| C-07 | model_tagging_countsで使用状況取得 | E-04（18-20行目）、E-02（17-19行目） | ○ |
| C-08 | フィールドグループ関連で削除制限 | E-04（9-14行目 `before_destroy`）、E-02（7-13行目） | ○ |
| C-09 | タグ付けがある場合は確認リンク表示 | E-02（10-11行目 `link_to_confirm`） | ○ |
| C-10 | タグ付けもフィールドグループもない場合は直接削除 | E-02（12-13行目 `link_to_delete`） | ○ |
| C-11 | tagsテーブルにname列がある | E-06（407行目） | ○ |
| C-12 | taggings_count列がある | E-06（408行目） | ○ |
| C-13 | taggingsテーブルでtag_id関連 | E-06（395行目） | ○ |
| C-14 | 機能No.69-72がタグ管理関連 | E-07（81-84行目） | ○ |
| C-15 | confirmアクションがある | E-05（202-203行目）、E-03（62-64行目） | ○ |
| C-16 | tag_paramsでStrong Parameters適用 | E-03（68-70行目） | ○ |
| C-17 | load_resourceで自動ロード | E-03（11行目） | ○ |
| C-18 | 編集時にprevious情報を保持 | E-03（31行目） | ○ |
| C-19 | AIプロンプトリンクの条件表示 | E-01（17-19行目 `Setting[:about_my_business]`） | ○ |
| C-20 | 空の場合はshared/emptyを表示 | E-01（15行目） | ○ |
| C-21 | フィールドグループ関連時はDeleteがグレー表示 | E-02（8行目 `style: "color: #777"`） | ○ |
| C-22 | AIプロンプト機能の詳細実装 | **根拠なし**（ai_prompt_linkヘルパーの実装未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- AIプロンプト機能（`ai_prompt_link`ヘルパー）の詳細実装
  - 候補：`app/helpers/` 配下のヘルパーファイル / 外部API連携

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - AIプロンプト機能は追加調査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] フィールドグループ関連があるタグの削除制限が動作することを確認
- [ ] タグ付けがあるタグの削除確認ダイアログが表示されることを確認
- [ ] model_tagging_countsの表示が正しいことを確認
- [ ] AIプロンプト機能の動作確認（設定がある場合）
- [ ] 管理者以外のアクセス時のリダイレクト動作確認
