---
generated_at: 2026-01-13 10:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：43-カスタムフィールド管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **カスタムフィールド値の保存方法詳細**：実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/fields/index.html.haml`
- E-02: `app/views/admin/field_groups/_field_group.html.haml`
- E-03: `app/controllers/admin/fields_controller.rb`
- E-04: `app/models/fields/field.rb`
- E-05: `config/routes.rb`
- E-06: `db/schema.rb`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者のみがアクセス可能 | E-03（Admin::ApplicationControllerを継承） | ○ |
| C-02 | URLは `/admin/fields` | E-05（190-198行目） | ○ |
| C-03 | エンティティ別タブ構成 | E-01（11-16行目 `list_of_entities.each`） | ○ |
| C-04 | Contactタブがデフォルト表示 | E-01（15行目 `class: ("selected" if entity == 'Contact')`） | ○ |
| C-05 | klass.field_groupsでグループ取得 | E-01（32行目） | ○ |
| C-06 | data-sortableでドラッグ&ドロップ有効化 | E-01（31行目）、E-02（21行目） | ○ |
| C-07 | sort_admin_field_groups_pathで並び替え | E-01（31行目） | ○ |
| C-08 | sort_admin_fields_pathでフィールド並び替え | E-02（21行目） | ○ |
| C-09 | sortable-connect-withでグループ間移動 | E-02（21行目 `data-sortable-connect-with`） | ○ |
| C-10 | without_pairsスコープでペアフィールド除外 | E-02（22行目）、E-04（41行目） | ○ |
| C-11 | BASE_FIELD_TYPESでフィールドタイプ定義 | E-04（45-60行目） | ○ |
| C-12 | labelバリデーション必須 | E-04（62行目） | ○ |
| C-13 | asバリデーション必須 | E-04（67行目） | ○ |
| C-14 | minlength/maxlength検証 | E-04（64-66行目） | ○ |
| C-15 | acts_as_listで並び替え | E-04（32行目） | ○ |
| C-16 | sortアクションの実装 | E-03（84-93行目） | ○ |
| C-17 | subformアクションの実装 | E-03（97-111行目） | ○ |
| C-18 | lookup_classでフィールドクラス決定 | E-04（123-125行目）、E-03（45行目） | ○ |
| C-19 | fieldsテーブルにtype列がある（STI） | E-06（247行目） | ○ |
| C-20 | fieldsテーブルにfield_group_id列がある | E-06（248行目） | ○ |
| C-21 | fieldsテーブルにposition列がある | E-06（249行目） | ○ |
| C-22 | field_groupsテーブルにtag_id列がある | E-06（242行目） | ○ |
| C-23 | field_groupsテーブルにklass_name列がある | E-06（243行目） | ○ |
| C-24 | 機能No.73-77がカスタムフィールド関連 | E-07（85-89行目） | ○ |
| C-25 | カスタムフィールド値の保存方法（serialize/JSON） | **根拠なし**（実装詳細未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- カスタムフィールド値の実際の保存方法（動的カラム追加 or serialize/JSON）
  - 候補：`app/models/entities/` 配下のモデル / マイグレーション / concern

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成とCRUD操作は十分に確認可能
- 1: 中リスク - カスタムフィールド値の保存メカニズムは追加調査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] エンティティ別タブ切り替えが正しく動作することを確認
- [ ] フィールドグループ・フィールドのドラッグ&ドロップ並び替えが動作することを確認
- [ ] フィールドタイプ選択時のサブフォーム動的読み込みを確認
- [ ] グループ間でのフィールド移動が正しく動作することを確認
- [ ] バリデーションエラーメッセージの表示を確認
- [ ] 管理者以外のアクセス時のリダイレクト動作確認
