---
generated_at: 2026-01-13 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-カスタムフィールド詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/fields/show.html.haml`
- E-02: `app/controllers/admin/fields_controller.rb`
- E-03: `app/models/fields/field.rb`
- E-04: `config/routes.rb`
- E-05: `db/schema.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者のみがアクセス可能 | E-02（Admin::ApplicationControllerを継承） | ○ |
| C-02 | URLは `/admin/fields/:id` | E-04（190行目 `resources :fields`） | ○ |
| C-03 | showアクションでフィールド表示 | E-02（20-23行目） | ○ |
| C-04 | load_resourceで自動ロード | E-02（10行目） | ○ |
| C-05 | 編集リンクでインラインフォーム展開 | E-01（5行目 `link_to_inline`） | ○ |
| C-06 | field_labelをタイトル表示 | E-01（6行目 `@field.field_label`） | ○ |
| C-07 | Label項目を表示 | E-01（14-15行目） | ○ |
| C-08 | Name項目を表示 | E-01（18-20行目） | ○ |
| C-09 | Table項目をpluralizeで表示 | E-01（23-25行目 `.pluralize`） | ○ |
| C-10 | Type項目を表示 | E-01（28-30行目） | ○ |
| C-11 | Created at項目を表示 | E-01（34-35行目） | ○ |
| C-12 | Updated at項目を表示 | E-01（38-39行目） | ○ |
| C-13 | hookでプラグイン拡張ポイント | E-01（41行目 `hook(:show_field_bottom, self)`） | ○ |
| C-14 | fieldsテーブルにlabel列がある | E-05（251行目） | ○ |
| C-15 | 機能No.73がカスタムフィールド管理 | E-06（90行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 詳細画面に全ての属性が正しく表示されることを確認
- [ ] 編集リンククリック時にインラインフォームが展開されることを確認
- [ ] 管理者以外のアクセス時のリダイレクト動作確認
