---
generated_at: 2026-01-13 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-調査ツール管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/research_tools/index.html.haml`
- E-02: `app/views/admin/research_tools/_form.html.haml`
- E-03: `app/controllers/admin/research_tools_controller.rb`
- E-04: `app/models/research_tool.rb`
- E-05: `config/routes.rb`
- E-06: `db/schema.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者のみがアクセス可能 | E-03（Admin::ApplicationControllerを継承） | ○ |
| C-02 | URLは `/admin/research_tools` | E-05（188行目 `resources :research_tools`） | ○ |
| C-03 | showアクションが除外されている | E-05（188行目 `except: [:show]`） | ○ |
| C-04 | ResearchTool.allで全ツール取得 | E-03（9行目） | ○ |
| C-05 | load_resourceで自動ロード | E-03（6行目） | ○ |
| C-06 | 新規作成リンクでインラインフォーム展開 | E-01（2行目 `link_to_inline`） | ○ |
| C-07 | リサーチツール一覧をパーシャルで表示 | E-01（11行目 `render partial`） | ○ |
| C-08 | 空の場合はshared/emptyを表示 | E-01（13行目） | ○ |
| C-09 | createアクションで作成後リダイレクト | E-03（23行目 `location`） | ○ |
| C-10 | updateアクションで更新後リダイレクト | E-03（28行目 `location`） | ○ |
| C-11 | research_tool_paramsでStrong Parameters適用 | E-03（38-40行目） | ○ |
| C-12 | name, url_template, enabledを許可 | E-03（39行目） | ○ |
| C-13 | フォームでnameフィールドにrequired | E-02（7行目） | ○ |
| C-14 | フォームでurl_templateフィールドにrequired | E-02（11行目） | ○ |
| C-15 | research_toolsテーブルにname列がある | E-06（370行目） | ○ |
| C-16 | research_toolsテーブルにurl_template列がある | E-06（371行目） | ○ |
| C-17 | research_toolsテーブルにenabled列がある | E-06（372行目） | ○ |
| C-18 | enabledのデフォルトはfalse | E-06（372行目 `default: false`） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 新規作成フォームが正しく表示されることを確認
- [ ] 作成後に一覧画面へリダイレクトされることを確認
- [ ] 削除が正しく動作することを確認
- [ ] 管理者以外のアクセス時のリダイレクト動作確認
