---
generated_at: 2026-01-13 11:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/admin/settings/index.html.haml`
- E-02: `app/views/admin/settings/_application.html.haml`
- E-03: `app/views/admin/settings/_user_signup.html.haml`
- E-04: `app/views/admin/settings/_email.html.haml`
- E-05: `app/views/admin/settings/_validations.html.haml`
- E-06: `app/views/admin/settings/_customization.html.haml`
- E-07: `app/controllers/admin/settings_controller.rb`
- E-08: `app/models/setting.rb`
- E-09: `config/routes.rb`
- E-10: `db/schema.rb`
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者のみがアクセス可能 | E-07（Admin::ApplicationControllerを継承） | ○ |
| C-02 | URLは `/admin/settings` | E-09（209-213行目） | ○ |
| C-03 | indexアクションが空 | E-07（14-15行目） | ○ |
| C-04 | updateアクションで設定を保存 | E-07（19-48行目） | ○ |
| C-05 | form_for "settings"でフォーム生成 | E-01（3行目） | ○ |
| C-06 | 各パーシャルをレンダリング | E-01（4-9行目） | ○ |
| C-07 | Setting.hostで現在値取得 | E-02（9行目） | ○ |
| C-08 | user_signup選択肢にallowed/not_allowed/needs_approval | E-03（7行目） | ○ |
| C-09 | メール設定にタブUI | E-04（5-11行目 `nav-tabs`） | ○ |
| C-10 | fields_forでネスト設定対応 | E-04（15行目 `f.fields_for :smtp`） | ○ |
| C-11 | require_first_names設定 | E-05（7-9行目） | ○ |
| C-12 | require_last_names設定 | E-05（12-14行目） | ○ |
| C-13 | require_unique_account_names設定 | E-05（17-19行目） | ○ |
| C-14 | account_categoryテキストエリア | E-06（21行目） | ○ |
| C-15 | campaign_statusテキストエリア | E-06（24行目） | ○ |
| C-16 | ブール値変換処理 | E-07（26-28行目） | ○ |
| C-17 | 配列変換処理（改行区切り） | E-07（35-37行目 `split(/\r?\n/)`） | ○ |
| C-18 | シンボル変換処理 | E-07（40行目 `to_sym`） | ○ |
| C-19 | Setting[key] = valueで保存 | E-07（43-45行目） | ○ |
| C-20 | リダイレクト先は同一画面 | E-07（47行目 `admin_settings_path`） | ○ |
| C-21 | フラッシュメッセージ表示 | E-07（47行目 `notice:`） | ○ |
| C-22 | settings_paramsでStrong Parameters適用 | E-07（52-86行目） | ○ |
| C-23 | settingsテーブルにname列がある | E-10（387行目） | ○ |
| C-24 | 機能No.78-79がシステム設定関連 | E-11（91-92行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各設定セクションが正しく表示されることを確認
- [ ] ブール値設定のチェックボックスが正しく動作することを確認
- [ ] 配列型設定（カテゴリ、ステータス等）の改行区切り入力が正しく保存されることを確認
- [ ] メール設定のタブ切り替えが正しく動作することを確認
- [ ] 更新後にフラッシュメッセージが表示されることを確認
- [ ] 管理者以外のアクセス時のリダイレクト動作確認
