---
generated_at: 2026-01-13 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-メインレイアウト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/layouts/application.html.haml`
- E-02: `app/views/layouts/_header.html.haml`
- E-03: `app/views/layouts/_tabbed.html.haml`
- E-04: `app/views/layouts/_sidebar.html.haml`
- E-05: `app/views/layouts/_footer.html.haml`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTML5ドキュメント | E-01（1行目 `!!!5`） | ○ |
| C-02 | lang属性にI18n.locale使用 | E-01（2行目） | ○ |
| C-03 | UTF-8エンコーディング | E-01（4行目） | ○ |
| C-04 | レスポンシブviewport設定 | E-01（5行目） | ○ |
| C-05 | タイトル"Fat Free CRM" | E-01（6行目） | ○ |
| C-06 | application, printスタイルシート | E-01（8-9行目） | ○ |
| C-07 | Leaflet CDN読み込み | E-01（14-15行目） | ○ |
| C-08 | application.js読み込み | E-01（17行目） | ○ |
| C-09 | csrf_meta_tag | E-01（23行目） | ○ |
| C-10 | ロケール別Datepicker読み込み | E-01（19-21行目） | ○ |
| C-11 | _headerパーシャルレンダリング | E-01（39行目） | ○ |
| C-12 | tabless_layout?による切り替え | E-01（40-43行目） | ○ |
| C-13 | crm.base_url変数設定 | E-01（47行目） | ○ |
| C-14 | current_user.nameでウェルカム表示 | E-02（6行目） | ○ |
| C-15 | Quick Findリンク | E-02（9行目 `#jumper`） | ○ |
| C-16 | Profileリンク | E-02（10行目） | ○ |
| C-17 | Adminリンク（管理者のみ） | E-02（11-12行目 `current_user.admin?`） | ○ |
| C-18 | Logoutリンク | E-02（13行目 `destroy_user_session_path`） | ○ |
| C-19 | Bootstrap navbar | E-03（1行目 `.navbar`） | ○ |
| C-20 | サイドバーレンダリング | E-03（16行目） | ○ |
| C-21 | メインコンテンツyield | E-03（18行目） | ○ |
| C-22 | FatFreeCRM::VERSION表示 | E-05（2行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ヘッダーにユーザー名が正しく表示されることを確認
- [ ] 管理者ユーザーにのみAdminリンクが表示されることを確認
- [ ] ナビゲーションタブが正しく表示されることを確認
- [ ] サイドバーが正しくレンダリングされることを確認
- [ ] フッターにバージョン情報が表示されることを確認
- [ ] ログアウトが正しく動作することを確認
