---
generated_at: 2026-01-13 16:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：51-500エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **システム管理者への通知機能**：ログ記録の実装詳細が未確認
  2. **exception変数の渡し方**：HAMLテンプレートへの変数渡しの呼び出し元が未特定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `public/500.html` - 静的エラーページHTML
- E-02: `app/views/layouts/500.html.haml` - HAMLテンプレート
- E-03: `app/controllers/application_controller.rb` - 例外ハンドリング定義（29-30行目、64-71行目）
- E-04: `config/environments/production.rb` - 本番環境設定（22行目）
- E-05: `config/environments/development.rb` - 開発環境設定（21行目）
- E-06: `app/assets/stylesheets/rails.scss` - スタイル定義（50-58行目）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（51行目）
- E-08: `config/routes.rb` - ルーティング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 500エラー画面はサーバーエラー発生時に表示される | E-01, E-02 | ○ |
| C-02 | public/500.htmlは静的HTMLで外部リソースに依存しない | E-01 | ○ |
| C-03 | 静的HTML版のタイトルは"We're sorry, but something went wrong (500)" | E-01 | ○ |
| C-04 | 静的HTML版のメッセージは"We're sorry, but something went wrong." | E-01 | ○ |
| C-05 | HAMLテンプレート版のタイトルは"Fat Free CRM Exception" | E-02 | ○ |
| C-06 | HAMLテンプレートはexception変数でエラー詳細を表示 | E-02 | ○ |
| C-07 | HAMLテンプレートにFat Free CRMへのホームリンクがある | E-02 | ○ |
| C-08 | 本番環境ではconsider_all_requests_local = false | E-04 | ○ |
| C-09 | 開発環境ではconsider_all_requests_local = true | E-05 | ○ |
| C-10 | ApplicationControllerにrescue_fromで例外ハンドリング定義がある | E-03 | ○ |
| C-11 | ActiveRecord::RecordNotFoundはrespond_to_not_foundで処理される | E-03 | ○ |
| C-12 | CanCan::AccessDeniedはrespond_to_access_deniedで処理される | E-03 | ○ |
| C-13 | ArgumentError(invalid base64)は特別処理される | E-03 | ○ |
| C-14 | .flash_exceptionのスタイルはrails.scssで定義されている | E-06 | ○ |
| C-15 | .flash_exceptionの背景色は#ddff99 | E-06 | ○ |
| C-16 | .flash_exceptionのボーダーは5px limegreen solid | E-06 | ○ |
| C-17 | システム管理者への通知機能がある | **根拠なし** | △ |
| C-18 | HAMLテンプレートはカスタム例外処理から呼び出される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-17（システム管理者への通知）について**
  - 設計書では「エラー発生をログに記録し、運用チームへの通知基盤を構築」と記載
  - しかし、明示的なエラー通知機能（例：Airbrake、Sentry等）の設定は確認できなかった
  - 候補：config/initializers/*.rb / Gemfile / 外部監視サービス設定

- **C-18（HAMLテンプレートの呼び出し元）について**
  - 500.html.hamlテンプレートの存在は確認したが、このテンプレートを明示的に呼び出すコードは発見できなかった
  - Railsのデフォルト動作では本番環境でpublic/500.htmlが使用される
  - 候補：rescue_fromのカスタム実装 / プラグインによる拡張

## 5) リスクフラグ（レビュー観点）
- **リスクレベル 0（低リスク）**：
  - 静的エラーページの内容と構造
  - スタイル定義

- **リスクレベル 1（中リスク）**：
  - HAMLテンプレートの使用タイミング
  - exception変数の内容がセキュリティ上安全か確認が必要

- **リスクレベル 2（高リスク）**：
  - なし

## 6) レビュアーチェックリスト（最小）
- [ ] public/500.htmlの内容がドキュメント記載と一致するか確認
- [ ] 500.html.hamlテンプレートが実際に使用されるケースを特定（またはレガシーとして削除対象か確認）
- [ ] 本番環境でのエラー表示動作を実機確認
- [ ] exception変数に機密情報が含まれないことを確認
- [ ] エラー発生時のログ出力・通知機能の有無を確認
