---
generated_at: 2026-01-13 10:55:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：6-ホーム画面（ダッシュボード）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **visible_on_dashboardスコープの実装詳細**：各モデルでの定義確認が必要
  2. **Excelエクスポート機能の実装**：具体的な出力内容の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/home/index.html.haml`
- E-02: `app/controllers/home_controller.rb`
- E-03: `app/models/entities/account.rb`
- E-04: `config/routes.rb`
- E-05: `config/locales/fat_free_crm.en-US.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/`である | E-04 (11行目) | ○ |
| C-02 | URLが`/activities`でもアクセス可能 | E-04 (31行目) | ○ |
| C-03 | My Tasksセクションが存在する | E-01 (5-11行目), E-02 (15行目) | ○ |
| C-04 | My Opportunitiesセクションが存在する | E-01 (13-19行目), E-02 (16行目) | ○ |
| C-05 | My Accountsセクションが存在する | E-01 (21-29行目), E-02 (17行目) | ○ |
| C-06 | Recent Activityセクションが存在する | E-01 (35-43行目), E-02 (14行目) | ○ |
| C-07 | タスクは最大10件表示 | E-01 (8行目: `.limit(10)`) | ○ |
| C-08 | 商談は最大10件表示 | E-01 (17行目: `.limit(10)`) | ○ |
| C-09 | 取引先は最大10件表示 | E-01 (26行目: `.limit(10)`) | ○ |
| C-10 | Optionsリンクが存在する | E-01 (32行目) | ○ |
| C-11 | `/home/options`でフィルターオプション取得 | E-04 (35行目), E-02 (25-32行目) | ○ |
| C-12 | `/home/redraw`でフィルター適用後再描画 | E-04 (39行目), E-02 (36-46行目) | ○ |
| C-13 | `/home/timeline`でタイムライン状態変更 | E-04 (37行目), E-02 (64-82行目) | ○ |
| C-14 | `/home/toggle`でトグル状態変更 | E-04 (36行目), E-02 (51-61行目) | ○ |
| C-15 | フィルター設定はプリファレンスに保存 | E-02 (38-41行目) | ○ |
| C-16 | アクティビティは最大500件取得 | E-02 (106行目: `max: 500`) | ○ |
| C-17 | get_activitiesメソッドでアクティビティ取得 | E-02 (101-109行目) | ○ |
| C-18 | アセット種別フィルターが存在する | E-02 (112-119行目) | ○ |
| C-19 | イベント種別フィルターが存在する | E-02 (122-129行目) | ○ |
| C-20 | ユーザーフィルターが存在する | E-02 (135-148行目) | ○ |
| C-21 | 期間フィルターが存在する | E-02 (161-167行目) | ○ |
| C-22 | タイムライン状態（Expanded/Collapsed）の更新 | E-02 (67-78行目) | ○ |
| C-23 | メッセージ`my_tasks`が定義されている | E-05 (598行目) | ○ |
| C-24 | メッセージ`my_opportunities`が定義されている | E-05 (600行目) | ○ |
| C-25 | メッセージ`my_accounts`が定義されている | E-05 (602行目) | ○ |
| C-26 | メッセージ`recent_activity`が定義されている | E-05 (579行目) | ○ |
| C-27 | メッセージ`no_task_records`が定義されている | E-05 (599行目) | ○ |
| C-28 | メッセージ`no_opportunity_records`が定義されている | E-05 (601行目) | ○ |
| C-29 | `visible_on_dashboard`スコープが各モデルに定義 | E-03 (57-60行目) - Account確認済み、他モデル未確認 | △ |
| C-30 | Excelエクスポート機能あり | E-02 (19行目: `format.xls`) | △ |

## 4) 不足情報（Unknown / Missing）
- Task、Opportunityモデルの`visible_on_dashboard`スコープの定義
  - 候補：`app/models/entities/task.rb` / `app/models/entities/opportunity.rb`
- Excelエクスポートの具体的な出力項目
  - 候補：`app/views/home/index.xls.erb` または関連テンプレート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング情報（コードから明確に確認可能）
- 0: 低リスク - 表示項目（テンプレートから確認可能）
- 0: 低リスク - フィルター機能（コントローラーから確認可能）
- 1: 中リスク - 各モデルのスコープ定義（個別確認が必要）
- 1: 中リスク - エクスポート機能（出力内容の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] `/`でダッシュボードが表示されることを確認
- [ ] My Tasksセクションに自分のタスクが表示されることを確認
- [ ] My Opportunitiesセクションに自分の商談が表示されることを確認
- [ ] My Accountsセクションに自分の取引先が表示されることを確認
- [ ] Recent Activityセクションにアクティビティが表示されることを確認
- [ ] 各セクションで10件を超える場合に「hidden」メッセージが表示されることを確認
- [ ] Optionsリンクからフィルター設定が変更できることを確認
- [ ] フィルター設定が保存されることを確認
