---
generated_at: 2026-01-13 11:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：7-取引先一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **パイプライン表示の実装詳細**：関連商談の金額集計ロジックの確認が必要
  2. **オートコンプリート機能**：具体的な実装箇所の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/accounts/index.html.haml`
- E-02: `app/controllers/entities/accounts_controller.rb`
- E-03: `app/controllers/entities_controller.rb`
- E-04: `app/models/entities/account.rb`
- E-05: `config/routes.rb`
- E-06: `config/locales/fat_free_crm.en-US.yml`
- E-07: `db/schema.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/accounts`である | E-05 (44行目) | ○ |
| C-02 | indexアクションが存在する | E-02 (13-19行目) | ○ |
| C-03 | filterアクションが存在する | E-02 (116-122行目), E-05 (47行目) | ○ |
| C-04 | advanced_searchアクションが存在する | E-05 (46行目) | ○ |
| C-05 | auto_completeアクションが存在する | E-05 (50行目) | ○ |
| C-06 | redrawアクションが存在する | E-02 (103-112行目), E-05 (51行目) | ○ |
| C-07 | 取引先一覧が表示される | E-01 (11-15行目) | ○ |
| C-08 | 検索フォームが存在する | E-01 (7行目) | ○ |
| C-09 | 新規作成フォーム領域が存在する | E-01 (5行目) | ○ |
| C-10 | ページネーションが存在する | E-01 (17行目) | ○ |
| C-11 | エクスポートリンクが存在する | E-01 (18行目) | ○ |
| C-12 | CSV形式でエクスポート可能 | E-02 (18行目) | ○ |
| C-13 | Excel形式でエクスポート可能 | E-02 (17行目) | ○ |
| C-14 | stateスコープでフィルタリング | E-04 (49-51行目) | ○ |
| C-15 | text_searchスコープで検索 | E-04 (55行目) | ○ |
| C-16 | カテゴリ別件数をサイドバーに表示 | E-02 (153-162行目) | ○ |
| C-17 | デフォルトソートは作成日時降順 | E-04 (71行目) | ○ |
| C-18 | デフォルト表示件数は20件 | E-04 (88-90行目) | ○ |
| C-19 | accountsテーブルにnameカラムが存在 | E-07 (35行目) | ○ |
| C-20 | accountsテーブルにcategoryカラムが存在 | E-07 (47行目) | ○ |
| C-21 | accountsテーブルにphoneカラムが存在 | E-07 (39行目) | ○ |
| C-22 | accountsテーブルにwebsiteカラムが存在 | E-07 (37行目) | ○ |
| C-23 | accountsテーブルにratingカラムが存在 | E-07 (46行目) | ○ |
| C-24 | accountsテーブルにdeleted_atカラムが存在 | E-07 (41行目) | ○ |
| C-25 | 論理削除を採用 | E-04 (削除処理), E-07 (deleted_at) | ○ |
| C-26 | メッセージ`tab_accounts`が定義されている | E-06 (25行目) | ○ |
| C-27 | メッセージ`create_account`が定義されている | E-06 (335行目) | ○ |
| C-28 | メッセージ`to_xls`が定義されている | E-06 (769行目) | ○ |
| C-29 | メッセージ`to_csv`が定義されている | E-06 (770行目) | ○ |
| C-30 | get_list_of_recordsメソッドで一覧取得 | E-03 (138-178行目), E-02 (128行目) | ○ |
| C-31 | パイプライン（関連商談金額）が表示される | E-04 (37行目: pipeline_opportunities) | △ |
| C-32 | オートコンプリート機能が存在する | E-05 (50行目) - ルーティングのみ確認 | △ |

## 4) 不足情報（Unknown / Missing）
- パイプライン表示の具体的な計算ロジック
  - 候補：`app/views/accounts/_account.html.haml` / ヘルパーメソッド
- オートコンプリートの具体的な実装
  - 候補：`app/controllers/application_controller.rb` / JavaScript

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング情報（コードから明確に確認可能）
- 0: 低リスク - データベース構造（スキーマから確認可能）
- 0: 低リスク - 基本的な一覧表示機能（コントローラーから確認可能）
- 1: 中リスク - パイプライン表示（表示ロジックの確認が必要）
- 1: 中リスク - オートコンプリート（実装詳細の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] `/accounts`で取引先一覧が表示されることを確認
- [ ] カテゴリフィルターが正しく動作することを確認
- [ ] テキスト検索が正しく動作することを確認
- [ ] ページネーションが正しく動作することを確認
- [ ] 新規作成ボタンからフォームが表示されることを確認
- [ ] 取引先名クリックで詳細画面に遷移することを確認
- [ ] CSV/Excelエクスポートが正しく動作することを確認
- [ ] 削除機能が正しく動作することを確認
