---
generated_at: 2026-01-13 11:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：8-取引先詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **購読通知の配信ロジック**：メール配信の具体的な実装確認が必要
  2. **カスタムフィールドの表示**：フィールドグループ単位での表示ロジック確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/accounts/show.html.haml`
- E-02: `app/controllers/entities/accounts_controller.rb`
- E-03: `app/controllers/entities_controller.rb`
- E-04: `app/models/entities/account.rb`
- E-05: `config/routes.rb`
- E-06: `config/locales/fat_free_crm.en-US.yml`
- E-07: `db/schema.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/accounts/:id`である | E-05 (44行目) | ○ |
| C-02 | showアクションが存在する | E-02 (25-30行目) | ○ |
| C-03 | attachアクションが存在する | E-03 (23-29行目), E-05 (55行目) | ○ |
| C-04 | discardアクションが存在する | E-03 (33-39行目), E-05 (56行目) | ○ |
| C-05 | subscribeアクションが存在する | E-03 (43-50行目), E-05 (57行目) | ○ |
| C-06 | unsubscribeアクションが存在する | E-03 (54-62行目), E-05 (58行目) | ○ |
| C-07 | タイムラインが表示される | E-01 (15行目), E-03 (216-217行目) | ○ |
| C-08 | コメントフォームが存在する | E-01 (14行目) | ○ |
| C-09 | タスク一覧が表示される | E-01 (19行目) | ○ |
| C-10 | 連絡先一覧が表示される | E-01 (21行目) | ○ |
| C-11 | 商談一覧が表示される | E-01 (23行目) | ○ |
| C-12 | バージョン履歴が表示される | E-01 (25行目) | ○ |
| C-13 | contactsとの多対多関連が存在する | E-04 (33-34行目) | ○ |
| C-14 | opportunitiesとの多対多関連が存在する | E-04 (35-37行目) | ○ |
| C-15 | tasksとの関連が存在する | E-04 (38行目) | ○ |
| C-16 | commentsテーブルが存在する | E-07 (161-171行目) | ○ |
| C-17 | account_contactsテーブルが存在する | E-07 (14-21行目) | ○ |
| C-18 | account_opportunitiesテーブルが存在する | E-07 (23-30行目) | ○ |
| C-19 | subscribed_usersカラムが存在する | E-04 (44行目), E-07 (48行目) | ○ |
| C-20 | PaperTrailによる変更履歴追跡 | E-04 (68行目) | ○ |
| C-21 | acts_as_commentableが設定されている | E-04 (65行目) | ○ |
| C-22 | timelineメソッドでコメントとメールをマージ | E-03 (216-217行目) | ○ |
| C-23 | メッセージ`account_summary`が定義されている | E-06 (328行目) | ○ |
| C-24 | メッセージ`add_note`が定義されている | E-06 (608行目) | ○ |
| C-25 | メッセージ`subscribe_via_email`が定義されている | E-06 (695行目) | ○ |
| C-26 | メッセージ`disable_email_subscriptions`が定義されている | E-06 (696行目) | ○ |
| C-27 | 購読通知の配信ロジック | 実装箇所未確認 | △ |
| C-28 | カスタムフィールドのフィールドグループ単位表示 | E-01 (hook記述あり) - 詳細ロジック未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- 購読通知メールの配信ロジック
  - 候補：`app/mailers/` / コールバック / ジョブ
- カスタムフィールドのフィールドグループ単位表示ロジック
  - 候補：`app/views/fields/` / ヘルパーメソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング情報（コードから明確に確認可能）
- 0: 低リスク - 関連データの表示（テンプレートから確認可能）
- 0: 低リスク - 基本的なCRUD操作（コントローラーから確認可能）
- 1: 中リスク - 購読通知配信（メール配信ロジックの確認が必要）
- 1: 中リスク - カスタムフィールド表示（実装詳細の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] `/accounts/:id`で取引先詳細が表示されることを確認
- [ ] 取引先の基本情報が正しく表示されることを確認
- [ ] 関連する連絡先一覧が表示されることを確認
- [ ] 関連する商談一覧が表示されることを確認
- [ ] タイムライン（コメント・メール）が表示されることを確認
- [ ] コメント追加が正しく動作することを確認
- [ ] 購読/購読解除が正しく動作することを確認
- [ ] 連絡先/商談のAttach/Discardが正しく動作することを確認
- [ ] バージョン履歴が表示されることを確認
