---
generated_at: 2026-01-13 11:10:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：9-取引先新規作成フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **カスタムフィールドの表示ロジック**：フィールドグループ単位での表示の詳細確認が必要
  2. **compound_address設定**：住所入力形式の切り替えロジックの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/accounts/_new.html.haml`
- E-02: `app/views/accounts/_top_section.html.haml`
- E-03: `app/views/accounts/_contact_info.html.haml`
- E-04: `app/controllers/entities/accounts_controller.rb`
- E-05: `app/controllers/entities_controller.rb`
- E-06: `app/models/entities/account.rb`
- E-07: `config/routes.rb`
- E-08: `config/locales/fat_free_crm.en-US.yml`
- E-09: `db/schema.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/accounts/new`である | E-07 (44行目) | ○ |
| C-02 | newアクションが存在する | E-04 (33-43行目) | ○ |
| C-03 | createアクションが存在する | E-04 (54-66行目) | ○ |
| C-04 | フォームがremote: trueでAJAX送信 | E-01 (1行目) | ○ |
| C-05 | 取引先名が必須 | E-06 (76行目: validates_presence_of :name) | ○ |
| C-06 | カテゴリバリデーションが存在する | E-06 (77-79行目) | ○ |
| C-07 | 評価が0-5の範囲 | E-06 (80行目) | ○ |
| C-08 | simple_form_forでフォーム生成 | E-01 (1行目) | ○ |
| C-09 | top_sectionパーシャルが呼ばれる | E-01 (7行目) | ○ |
| C-10 | contact_infoパーシャルが呼ばれる | E-01 (10行目) | ○ |
| C-11 | permissionsパーシャルが呼ばれる | E-01 (12行目) | ○ |
| C-12 | add_commentパーシャルが呼ばれる | E-01 (9行目) | ○ |
| C-13 | addressesのnested_attributesが定義 | E-06 (46行目) | ○ |
| C-14 | デフォルトでcurrent_userが設定される | E-04 (35行目) | ○ |
| C-15 | デフォルトでPublicアクセスが設定される | E-04 (35行目: Setting.default_access) | ○ |
| C-16 | コメント追加が可能 | E-04 (57行目: add_comment_by_user) | ○ |
| C-17 | accountsテーブルにnameカラムが存在 | E-09 (35行目) | ○ |
| C-18 | accountsテーブルにcategoryカラムが存在 | E-09 (47行目) | ○ |
| C-19 | accountsテーブルにratingカラムが存在 | E-09 (46行目) | ○ |
| C-20 | accountsテーブルにphoneカラムが存在 | E-09 (39行目) | ○ |
| C-21 | accountsテーブルにwebsiteカラムが存在 | E-09 (37行目) | ○ |
| C-22 | addressesテーブルがポリモーフィック | E-09 (76-77行目: addressable_type, addressable_id) | ○ |
| C-23 | permissionsテーブルが存在 | E-09 (305-314行目) | ○ |
| C-24 | taggingsテーブルが存在 | E-09 (328-337行目) | ○ |
| C-25 | one_submit_onlyで二重送信防止 | E-01 (17行目) | ○ |
| C-26 | メッセージ`create_account`が定義されている | E-08 (335行目) | ○ |
| C-27 | メッセージ`missing_account_name`が定義されている | E-08 (354行目) | ○ |
| C-28 | メッセージ`share_account`が定義されている | E-08 (352行目) | ○ |
| C-29 | カスタムフィールドのフィールドグループ単位表示 | E-01 (8, 11行目) - 詳細ロジック未確認 | △ |
| C-30 | compound_address設定による入力形式変更 | Setting参照 - 具体的実装未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- カスタムフィールドのフィールドグループ単位表示ロジック
  - 候補：`app/views/fields/` / ヘルパーメソッド
- compound_address設定による住所入力形式の切り替え
  - 候補：`app/helpers/` / アドレスパーシャル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング情報（コードから明確に確認可能）
- 0: 低リスク - バリデーション定義（モデルから確認可能）
- 0: 低リスク - フォーム構造（テンプレートから確認可能）
- 0: 低リスク - データベース構造（スキーマから確認可能）
- 1: 中リスク - カスタムフィールド表示（実装詳細の確認が必要）
- 1: 中リスク - 住所入力形式の切り替え（設定依存の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 取引先一覧画面から新規作成フォームが開くことを確認
- [ ] 取引先名を入力せずに作成ボタンを押すとエラーが表示されることを確認
- [ ] 各フィールドに入力して取引先が作成できることを確認
- [ ] カテゴリが正しく選択・保存されることを確認
- [ ] 評価が正しく設定・保存されることを確認
- [ ] タグが正しく設定・保存されることを確認
- [ ] 住所（請求先・配送先）が正しく保存されることを確認
- [ ] アクセス権限（Public/Private/Shared）が正しく動作することを確認
- [ ] コメントが正しく追加されることを確認
- [ ] キャンセルリンクでフォームが閉じることを確認
