---
generated_at: 2026-01-13 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **IT-042 Dropboxメール連携**：メール処理の実際の動作フローの詳細確認が必要
  2. **IT-030 Email通知連携**：メール送信の実際のトリガー条件の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `config/routes.rb` - ルーティング定義
- E-02: `app/controllers/application_controller.rb` - 共通コントローラー処理
- E-03: `app/controllers/entities_controller.rb` - エンティティ共通コントローラー
- E-04: `app/controllers/entities/accounts_controller.rb` - Accountsコントローラー
- E-05: `app/controllers/entities/leads_controller.rb` - Leadsコントローラー
- E-06: `app/controllers/entities/contacts_controller.rb` - Contactsコントローラー
- E-07: `app/controllers/entities/opportunities_controller.rb` - Opportunitiesコントローラー
- E-08: `app/controllers/entities/campaigns_controller.rb` - Campaignsコントローラー
- E-09: `app/controllers/tasks_controller.rb` - Tasksコントローラー
- E-10: `app/controllers/comments_controller.rb` - Commentsコントローラー
- E-11: `app/controllers/users_controller.rb` - Usersコントローラー
- E-12: `app/controllers/admin/users_controller.rb` - 管理者用Usersコントローラー
- E-13: `app/models/entities/account.rb` - Accountモデル
- E-14: `app/models/entities/lead.rb` - Leadモデル
- E-15: `app/models/entities/contact.rb` - Contactモデル
- E-16: `app/models/entities/opportunity.rb` - Opportunityモデル
- E-17: `app/models/users/user.rb` - Userモデル
- E-18: `spec/controllers/entities/accounts_controller_spec.rb` - Accountsコントローラーテスト
- E-19: `spec/features/leads_spec.rb` - Leads結合テスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001 AccountにContactを関連付け | E-03, E-04, E-13 | ○ |
| C-02 | IT-002 AccountにOpportunityを関連付け | E-03, E-04, E-13 | ○ |
| C-03 | IT-003 AccountにTaskを関連付け | E-03, E-04, E-13 | ○ |
| C-04 | IT-004 AccountからContactを関連解除 | E-03, E-13 | ○ |
| C-05 | IT-005 ContactにOpportunityを関連付け | E-03, E-06, E-15 | ○ |
| C-06 | IT-006 Leadのプロモーション処理 | E-05, E-14 | ○ |
| C-07 | IT-007 LeadにCampaignを関連付け | E-05, E-14 | ○ |
| C-08 | IT-008 Campaign経由でLeadを作成 | E-05, E-14 | ○ |
| C-09 | IT-009 Campaign経由でOpportunityを作成 | E-07, E-16 | ○ |
| C-10 | IT-010 OpportunityにAccountを関連付けて作成 | E-07, E-16 | ○ |
| C-11 | IT-011 OpportunityにContactを関連付け | E-03, E-07, E-16 | ○ |
| C-12 | IT-012 ContactにAccountを関連付けて作成 | E-06, E-15 | ○ |
| C-13 | IT-013 Entityへの購読追加・解除 | E-03 | ○ |
| C-14 | IT-014 Entityにコメントを追加 | E-10, E-13 | ○ |
| C-15 | IT-015 Entityにタスクを作成・関連付け | E-09, E-13 | ○ |
| C-16 | IT-016 タスクの完了状態を切り替え | E-09 | ○ |
| C-17 | IT-017 Deviseによるユーザー認証 | E-01, E-17 | ○ |
| C-18 | IT-018 Deviseによるユーザー登録 | E-01, E-17 | ○ |
| C-19 | IT-019 Deviseによるパスワードリセット | E-01, E-17 | ○ |
| C-20 | IT-020 管理者によるユーザー管理 | E-01, E-12 | ○ |
| C-21 | IT-021 管理者によるグループ管理 | E-01 | ○ |
| C-22 | IT-022 カスタムフィールドグループとフィールドの連携 | E-01, E-03 | ○ |
| C-23 | IT-023 Accountとその関連データの一括取得 | E-04, E-13 | ○ |
| C-24 | IT-024 LeadからContact/Account/Opportunityへの変換 | E-05, E-14, E-19 | ○ |
| C-25 | IT-025 エンティティの自動補完検索 | E-02, E-01 | ○ |
| C-26 | IT-026 Entityの変更履歴追跡 | E-03, E-13 | ○ |
| C-27 | IT-027 ダッシュボードでのEntity表示 | E-01 | ○ |
| C-28 | IT-028 フィルタ適用とサイドバー更新 | E-04, E-18 | ○ |
| C-29 | IT-029 ページネーションとセッション同期 | E-03, E-18 | ○ |
| C-30 | IT-030 コメント返信時のメール通知 | **根拠不足** | △ |
| C-31 | IT-031 ユーザー別機会一覧表示 | E-11 | ○ |
| C-32 | IT-032 表示設定変更と一覧再描画 | E-04, E-18 | ○ |
| C-33 | IT-033 EntityにAddressを関連付け | E-13, E-15 | ○ |
| C-34 | IT-034 EntityにTagを関連付け | E-13, E-14 | ○ |
| C-35 | IT-035 Entity権限とユーザーアクセス | E-13, E-17 | ○ |
| C-36 | IT-036 Entity一覧のエクスポート | E-04, E-13 | ○ |
| C-37 | IT-037 ユーザーアバター画像のアップロード | E-11 | ○ |
| C-38 | IT-038 カスタムリストの作成・管理 | E-01 | ○ |
| C-39 | IT-039 高度な検索条件でのEntity検索 | E-03, E-13 | ○ |
| C-40 | IT-040 APIフォーマットでのEntity操作 | E-02, E-04, E-18 | ○ |
| C-41 | IT-041 Entityに関連するメールの管理 | E-01 | ○ |
| C-42 | IT-042 Dropboxメール処理 | **根拠不足** | △ |
| C-43 | IT-043 システム設定の取得・更新 | E-01 | ○ |
| C-44 | IT-044 リサーチツールの管理 | E-01 | ○ |
| C-45 | IT-045 Entityの状態変更時のObserver処理 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- **IT-030 Email通知連携**：SubscriptionMailerの実装詳細と、コメント作成時のメール送信トリガーの詳細な処理フローが未確認
  - 候補：`app/mailers/subscription_mailer.rb` / `spec/mailers/subscription_mailer_spec.rb` / メール送信設定
- **IT-042 Dropboxメール連携**：DropboxMailerおよびMailProcessorの実際の動作環境と設定の詳細が未確認
  - 候補：`app/mailers/dropbox_mailer.rb` / `lib/mail_processor/` / メール受信設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：IT-029, IT-032, IT-036, IT-037, IT-038, IT-041, IT-044 - ページネーション、表示設定、エクスポート等の補助的機能
- **1（中リスク）**：IT-013, IT-016, IT-021, IT-022, IT-025, IT-026, IT-027, IT-028, IT-030, IT-031, IT-033, IT-034, IT-039, IT-040, IT-042, IT-043, IT-045 - 購読、タスク完了、グループ管理等の一般的な業務機能
- **2（高リスク）**：IT-001〜IT-012, IT-014, IT-015, IT-017〜IT-020, IT-023, IT-024, IT-035 - コア業務フロー（Lead変換、権限管理、認証等）

## 6) レビュアーチェックリスト（最小）
- [ ] IT-006（Lead変換）：Account, Contact, Opportunityの同時作成が正しく処理されるか確認
- [ ] IT-017〜IT-019（認証フロー）：Deviseの設定と実際の認証フローが一致しているか確認
- [ ] IT-020（管理者機能）：Admin権限チェックが正しく機能しているか確認
- [ ] IT-035（Permission連携）：Shared権限時のアクセス制御が正しく機能しているか確認
- [ ] IT-030（Email通知）：実際のメール送信条件とタイミングを確認
- [ ] IT-042（Dropbox連携）：メール処理環境が正しく設定されているか確認
- [ ] エンティティ間の関連付け/解除（IT-001〜IT-005, IT-010〜IT-012）：中間テーブルの整合性を確認
- [ ] CSV/XLS出力（IT-036）：大量データ時のパフォーマンスを確認
