# 通知設計書 4-パスワードリセット案内

## 概要

本ドキュメントは、Fat Free CRMにおけるパスワードリセット案内機能の設計を記載する。ユーザーがパスワードリセットをリクエストした際、リセット用URLを含むメールを送信する機能について定義する。本機能はDevise gemの標準機能（recoverable）を利用している。

### 本通知の処理概要

本通知は、ユーザーがパスワードを忘れた場合に、セキュアな方法でパスワードをリセットするための案内メールを送信する機能である。

**業務上の目的・背景**：CRMシステムを利用するユーザーがパスワードを忘れた場合、自己解決でパスワードをリセットできる仕組みが必要である。本機能により、ユーザーは管理者に依頼することなく、自身でパスワードをリセットでき、システムへの迅速なアクセス回復が可能となる。これは業務継続性の観点から重要であり、また管理者の負荷軽減にも貢献する。

**通知の送信タイミング**：ユーザーがパスワードリセットフォームでメールアドレスを入力し、リセットをリクエストした直後に同期的に送信される。

**通知の受信者**：パスワードリセットをリクエストしたメールアドレスに紐づくユーザーが受信者となる。該当ユーザーが存在しない場合でも、セキュリティ上の理由から同様のレスポンスを返す（パラノイドモード）。

**通知内容の概要**：メール件名は「Reset password instructions」で、本文にはユーザーへの挨拶、パスワード変更手順の説明、パスワードリセット用のワンタイムリンク、およびリクエストしていない場合の注意書きが含まれる。

**期待されるアクション**：受信者はメール本文のリンクをクリックし、パスワードリセットページにアクセスして新しいパスワードを設定する。リンクは6時間で有効期限が切れるため、速やかな対応が推奨される。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（deliver_now）※Devise標準動作 |
| 優先度 | 高（ユーザー認証に関わるため） |
| リトライ | なし（同期送信のため） |

### 送信先決定ロジック

1. パスワードリセットフォームで入力されたメールアドレスを取得
2. usersテーブルでemailまたはusernameが一致するユーザーを検索（大文字小文字を区別しない）
3. 該当ユーザーが見つかった場合、そのユーザーのemailアドレスに送信
4. paranoidモードが有効な場合、ユーザーが存在しなくてもエラーを表示しない

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | noreply@fatfreecrm.com（Devise.mailer_sender） |
| 送信元名称 | なし |
| 件名 | Reset password instructions |
| 形式 | HTML（text/html） |

### 本文テンプレート

```html
<p>Hello {user_email}!</p>
<p>Someone has requested a link to change your password. You can do this through the link below.</p>
<p><a href="{reset_password_url}">Change my password</a></p>
<p>If you didn't request this, please ignore this email.</p>
<p>Your password won't change until you access the link above and create a new one.</p>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @resource | ユーザーオブジェクト | Deviseコントローラーから渡される | Yes |
| @resource.email | ユーザーのメールアドレス | users.email | Yes |
| @token | パスワードリセットトークン | 生成されたワンタイムトークン | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | パスワードリセットフォーム送信 | 該当ユーザーが存在 | /users/password/new からのPOSTリクエスト |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザー未存在 | 入力されたメールアドレスに紐づくユーザーがいない場合（paranoidモード無効時のみ） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[パスワードリセットフォーム表示] --> B[メールアドレス入力]
    B --> C[送信ボタンクリック]
    C --> D[Devise::PasswordsController#create]
    D --> E[User.find_for_database_authentication]
    E --> F{ユーザー存在?}
    F -->|No| G[paranoidモード判定]
    G -->|有効| H[成功メッセージ表示（送信しない）]
    G -->|無効| I[エラーメッセージ表示]
    F -->|Yes| J[reset_password_token生成]
    J --> K[reset_password_sent_at更新]
    K --> L[DeviseMailer.reset_password_instructions]
    L --> M[メール送信]
    M --> N[成功メッセージ表示]
    H --> O[終了]
    I --> O
    N --> O
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー検索 | email、username |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | - |
| email | メール送信先、ユーザー検索 | lower(email) = :value OR lower(username) = :value |
| username | ユーザー検索 | lower(email) = :value OR lower(username) = :value |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | UPDATE | パスワードリセットトークン情報 |

#### usersテーブル更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | reset_password_token | ハッシュ化されたトークン | Devise生成 |
| UPDATE | reset_password_sent_at | 現在時刻 | トークン有効期限計算用 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ユーザー未存在 | 入力メールアドレスがDBに存在しない | paranoidモード無効時のみエラー表示 |
| 送信失敗 | SMTPサーバー接続エラー | 標準例外処理 |
| 入力エラー | メールアドレスが空 | バリデーションエラー表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（同期送信） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 設定なし（Devise標準） |
| 1日あたり上限 | 設定なし |

### 配信時間帯

送信時間帯の制限はなし。リクエスト時に即座に送信される。

## セキュリティ考慮事項

- リセットトークンは6時間で有効期限が切れる（config.reset_password_within = 6.hours）
- トークンはハッシュ化されてDBに保存される（平文では保存されない）
- メール本文のリンクにはワンタイムトークンが含まれ、1回使用すると無効化される
- paranoidモードを有効にすることで、メールアドレスの存在確認攻撃を防止可能
- reconfirmableが有効のため、メールアドレス変更時も再確認が必要

## 備考

- DeviseMailerクラスはDevise::Mailerを継承し、テンプレートパスを「devise/mailer」に設定している
- ユーザー認証はusernameまたはemailの両方で可能（find_for_database_authentication）
- 暗号化方式はauthlogic_sha512（Authlogic gemとの後方互換性のため）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーモデルとDevise設定を理解することが最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | deviseモジュール宣言、recoverableの確認 |
| 1-2 | devise.rb | `config/initializers/devise.rb` | mailer_sender、reset_password_within設定 |

**読解のコツ**: Userモデルの49-50行目で`devise :database_authenticatable, :registerable, :confirmable, :encryptable, :recoverable, :rememberable, :trackable`が宣言されている。`:recoverable`がパスワードリセット機能を提供する。

#### Step 2: メーラーを理解する

DeviseMailerの構造とテンプレートパスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | devise_mailer.rb | `app/mailers/devise_mailer.rb` | Devise::Mailerの継承、template_pathsの設定 |

**主要処理フロー**:
1. **8行目**: `class DeviseMailer < Devise::Mailer` - Devise標準メーラーを継承
2. **9-11行目**: `template_paths` - テンプレート参照先を「devise/mailer」に設定

#### Step 3: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | reset_password_instructions.html.haml | `app/views/devise/mailer/reset_password_instructions.html.haml` | メール本文テンプレート |

**主要処理フロー**:
- **2行目**: `t('.greeting', recipient: @resource.email)` - 挨拶文
- **3行目**: `t('.instruction')` - パスワード変更手順の説明
- **4行目**: `link_to t('.action'), edit_password_url(@resource, reset_password_token: @token)` - リセットリンク
- **5-6行目**: `t('.instruction_2')`, `t('.instruction_3')` - 追加説明

#### Step 4: 認証ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | user.rb | `app/models/users/user.rb` | find_for_database_authentication メソッド |

**主要処理フロー**:
- **206-211行目**: `find_for_database_authentication` - usernameまたはemailでユーザーを検索

### プログラム呼び出し階層図

```
ブラウザ: /users/password/new
    │
    └─ Devise::PasswordsController#new
            │
            └─ render new（パスワードリセットフォーム表示）
                   │
                   └─ POST /users/password
                          │
                          └─ Devise::PasswordsController#create
                                 │
                                 ├─ User.find_for_database_authentication
                                 │      └─ lower(username) = :value OR lower(email) = :value
                                 │
                                 └─ User#send_reset_password_instructions
                                        │
                                        ├─ reset_password_token生成
                                        │
                                        ├─ reset_password_sent_at更新
                                        │
                                        └─ DeviseMailer.reset_password_instructions
                                               └─ mail(to:, subject:)
                                                      └─ reset_password_instructions.html.haml
```

### データフロー図

```
[入力]                    [処理]                           [出力]

フォーム入力              Devise::PasswordsController#create
    │                        │
    │  email/username        ▼
    └─────────────▶ User.find_for_database_authentication
                           │
                           ▼
                     User#send_reset_password_instructions
                           │
                     ┌─────┼─────┐
                     ▼     ▼     ▼
               トークン生成  DB更新  メール送信
               (SecureRandom)  (reset_password_token,
                              reset_password_sent_at)
                                   │
                                   ▼
                           DeviseMailer.reset_password_instructions
                                   │
                                   ▼
                           SMTPサーバー ──────────────────▶ Email
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| devise_mailer.rb | `app/mailers/devise_mailer.rb` | ソース | DeviseMailerクラス定義 |
| reset_password_instructions.html.haml | `app/views/devise/mailer/reset_password_instructions.html.haml` | テンプレート | メール本文テンプレート |
| user.rb | `app/models/users/user.rb` | ソース | Userモデル、devise設定、認証ロジック |
| devise.rb | `config/initializers/devise.rb` | 設定 | Devise設定（mailer_sender、reset_password_within等） |
| devise_mailer_spec.rb | `spec/mailers/devise_mailer_spec.rb` | テスト | メーラーのテスト |
