# 通知設計書 5-パスワード変更通知

## 概要

本ドキュメントは、Fat Free CRMにおけるパスワード変更通知機能の設計を記載する。ユーザーがパスワードを変更した際、変更完了通知メールを送信する機能について定義する。本機能はDevise gemの標準機能（send_password_change_notification）を利用している。

### 本通知の処理概要

本通知は、ユーザーがパスワードを変更した際に、セキュリティ通知としてパスワード変更完了を知らせるメールを送信する機能である。

**業務上の目的・背景**：CRMシステムのセキュリティを確保するため、ユーザーのパスワードが変更された際には本人に通知することが重要である。この通知により、ユーザーは自身のアカウントでパスワード変更が行われたことを認識でき、万が一不正なパスワード変更が行われた場合には迅速に検知・対応することが可能となる。これはアカウントセキュリティの基本的な保護措置である。

**通知の送信タイミング**：ユーザーがパスワード変更を完了した直後に送信される。パスワードリセット（忘れた場合）、プロフィール画面からの変更、いずれの場合も送信対象となる（設定による）。

**通知の受信者**：パスワードを変更したユーザー本人のメールアドレスに送信される。

**通知内容の概要**：メール件名は「Password Changed」で、本文にはユーザーへの挨拶とパスワード変更完了のメッセージが含まれる。変更日時や変更元IPアドレスなどの詳細情報は含まれない（Devise標準）。

**期待されるアクション**：受信者はパスワード変更が自身によるものであることを確認する。自身が変更していない場合は、直ちにシステム管理者に連絡し、アカウントのセキュリティ対策を講じる必要がある。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（deliver_now）※Devise標準動作 |
| 優先度 | 高（セキュリティ通知のため） |
| リトライ | なし（同期送信のため） |

### 送信先決定ロジック

1. パスワードを変更したユーザーを特定
2. そのユーザーのemailアドレスに送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | noreply@fatfreecrm.com（Devise.mailer_sender） |
| 送信元名称 | なし |
| 件名 | Password Changed |
| 形式 | HTML（text/html） |

### 本文テンプレート

```html
<p>Hello {user_email}!</p>
<p>Your password has been changed.</p>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @resource | ユーザーオブジェクト | Deviseコントローラーから渡される | Yes |
| @resource.email | ユーザーのメールアドレス | users.email | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| モデルコールバック | User#password更新 | send_password_change_notification設定が有効 | パスワード変更完了時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 設定無効 | Devise.send_password_change_notificationがfalse（デフォルト） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[パスワード変更リクエスト] --> B{変更ソース}
    B -->|パスワードリセット| C[Devise::PasswordsController#update]
    B -->|プロフィール変更| D[UsersController#update]
    C --> E[User#reset_password]
    D --> F[User.update]
    E --> G{send_password_change_notification?}
    F --> G
    G -->|無効| H[終了]
    G -->|有効| I[User#send_password_change_notification]
    I --> J[DeviseMailer.password_change]
    J --> K[メール送信]
    K --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | email |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | 認証済みユーザー |
| email | メール送信先 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | UPDATE | パスワード（暗号化済み） |

#### usersテーブル更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | encrypted_password | 新しい暗号化パスワード | authlogic_sha512 |
| UPDATE | password_salt | 新しいソルト | 暗号化用 |
| UPDATE | reset_password_token | NULL | リセット完了時にクリア |
| UPDATE | reset_password_sent_at | NULL | リセット完了時にクリア |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | 標準例外処理、パスワード変更自体は完了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（同期送信） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 設定なし |
| 1日あたり上限 | 設定なし |

### 配信時間帯

送信時間帯の制限はなし。パスワード変更完了時に即座に送信される。

## セキュリティ考慮事項

- パスワード変更の事実のみを通知し、新しいパスワード自体は含まれない
- 不正アクセスによるパスワード変更を検知するための重要なセキュリティ機能
- デフォルトでは無効（send_password_change_notification = false）のため、有効化が推奨される
- メール送信先は変更前のメールアドレス（データベースのemailカラム）

## 備考

- 現在の設定（config/initializers/devise.rb）ではsend_password_change_notificationはコメントアウトされており、デフォルトのfalseが適用されている可能性がある
- 本機能を有効にするには、Devise設定で`config.send_password_change_notification = true`を設定する必要がある
- パスワード変更通知はセキュリティベストプラクティスとして推奨される機能である

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーモデルとDevise設定を理解することが最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | deviseモジュール宣言、password関連カラム |
| 1-2 | devise.rb | `config/initializers/devise.rb` | send_password_change_notification設定 |

**読解のコツ**: devise.rbの126-127行目に`config.send_password_change_notification = false`の設定（コメントアウト）がある。この設定をtrueにすると本通知が有効になる。

#### Step 2: メーラーを理解する

DeviseMailerの構造とテンプレートパスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | devise_mailer.rb | `app/mailers/devise_mailer.rb` | Devise::Mailerの継承、template_pathsの設定 |

**主要処理フロー**:
1. **8行目**: `class DeviseMailer < Devise::Mailer` - Devise標準メーラーを継承
2. **9-11行目**: `template_paths` - テンプレート参照先を「devise/mailer」に設定

#### Step 3: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | password_change.html.haml | `app/views/devise/mailer/password_change.html.haml` | メール本文テンプレート |

**主要処理フロー**:
- **2行目**: `t('.greeting', recipient: @resource.email)` - 挨拶文
- **3行目**: `t('.message')` - パスワード変更完了メッセージ

### プログラム呼び出し階層図

```
パスワード変更操作
    │
    ├─ Devise::PasswordsController#update（リセット経由）
    │      │
    │      └─ User#reset_password
    │             │
    │             └─ after_save（Devise内部）
    │
    └─ UsersController#update（プロフィール経由）
           │
           └─ User.update(password: ...)
                  │
                  └─ after_save（Devise内部）
                         │
                         └─ send_password_change_notification（設定がtrueの場合）
                                │
                                └─ DeviseMailer.password_change
                                       └─ mail(to:, subject:)
                                              └─ password_change.html.haml
```

### データフロー図

```
[入力]                    [処理]                           [出力]

パスワード変更           Devise::PasswordsController#update
リクエスト               または UsersController#update
    │                        │
    │  new_password          ▼
    └─────────────▶ User#encrypted_password更新
                           │
                           ▼
                     after_save callback
                           │
                     send_password_change_notification?
                           │
                           ▼
                     DeviseMailer.password_change（設定有効時）
                           │
                           ▼
                     SMTPサーバー ──────────────────▶ Email
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| devise_mailer.rb | `app/mailers/devise_mailer.rb` | ソース | DeviseMailerクラス定義 |
| password_change.html.haml | `app/views/devise/mailer/password_change.html.haml` | テンプレート | メール本文テンプレート |
| user.rb | `app/models/users/user.rb` | ソース | Userモデル、devise設定 |
| devise.rb | `config/initializers/devise.rb` | 設定 | Devise設定（send_password_change_notification等） |
