# 通知設計書 6-メールアドレス確認案内

## 概要

本ドキュメントは、Fat Free CRMにおけるメールアドレス確認案内機能の設計を記載する。ユーザー登録時またはメールアドレス変更時に、確認用URLを含むメールを送信する機能について定義する。本機能はDevise gemの標準機能（confirmable）を利用している。

### 本通知の処理概要

本通知は、ユーザーが新規登録時またはメールアドレス変更時に、メールアドレスの所有権を確認するための案内メールを送信する機能である。

**業務上の目的・背景**：CRMシステムのセキュリティと信頼性を確保するため、ユーザーが登録したメールアドレスが実際に本人のものであることを確認する必要がある。この確認プロセスにより、不正なメールアドレスでの登録を防ぎ、重要な通知が確実にユーザーに届くことを保証する。また、スパムアカウントの作成を抑制し、システム全体の品質を維持する役割も果たす。

**通知の送信タイミング**：以下のタイミングで送信される
- 新規ユーザー登録完了時
- 既存ユーザーがメールアドレスを変更した時（reconfirmableが有効な場合）
- ユーザーが確認メールの再送を要求した時

**通知の受信者**：登録または変更されたメールアドレスに送信される。メールアドレス変更時は、新しいメールアドレス（unconfirmed_email）に送信される。

**通知内容の概要**：メール件名は「Confirmation instructions」で、本文にはユーザーへの挨拶、確認手順の説明、および確認用のワンタイムリンクが含まれる。

**期待されるアクション**：受信者はメール本文のリンクをクリックし、メールアドレスの確認を完了する。確認が完了するまでシステムへのアクセスが制限される場合がある（allow_unconfirmed_access_for設定による）。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（deliver_now）※Devise標準動作 |
| 優先度 | 高（ユーザー認証に関わるため） |
| リトライ | なし（同期送信のため） |

### 送信先決定ロジック

1. 新規登録の場合：users.emailに送信
2. メールアドレス変更の場合：users.unconfirmed_emailに送信
3. 再送要求の場合：未確認のメールアドレスに送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | noreply@fatfreecrm.com（Devise.mailer_sender） |
| 送信元名称 | なし |
| 件名 | Confirmation instructions |
| 形式 | HTML（text/html） |

### 本文テンプレート

```html
<p>Hello {user_email}!</p>
<p>You can confirm your account email through the link below:</p>
<p><a href="{confirmation_url}">Confirm my account</a></p>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @resource | ユーザーオブジェクト | Deviseコントローラーから渡される | Yes |
| @resource.email | ユーザーのメールアドレス | users.email | Yes |
| @token | 確認用トークン | 生成されたワンタイムトークン | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| モデルコールバック | User新規作成 | confirmable有効 | 新規ユーザー登録時 |
| モデルコールバック | User.email更新 | reconfirmable有効 | メールアドレス変更時 |
| 画面操作 | 確認メール再送要求 | ユーザーが未確認状態 | /users/confirmation/new からの要求 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 確認済み | すでにconfirmed_atが設定されている場合（再送要求時） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A{トリガー種別} --> B[新規登録]
    A --> C[メールアドレス変更]
    A --> D[再送要求]
    B --> E[User.create]
    C --> F[User.update email]
    D --> G[Devise::ConfirmationsController#create]
    E --> H[after_create: send_confirmation_instructions]
    F --> I{reconfirmable?}
    I -->|Yes| J[unconfirmed_emailに保存]
    I -->|No| K[直接emailを更新]
    J --> L[send_confirmation_instructions]
    K --> M[確認不要]
    G --> N[send_confirmation_instructions]
    H --> O[DeviseMailer.confirmation_instructions]
    L --> O
    N --> O
    O --> P[メール送信]
    P --> Q[終了]
    M --> Q
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | email、unconfirmed_email |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | - |
| email | 現在のメールアドレス | - |
| unconfirmed_email | 変更後の未確認メールアドレス | reconfirmable時 |
| confirmed_at | 確認状態判定 | - |
| confirmation_token | 確認トークン | - |
| confirmation_sent_at | 確認メール送信日時 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | INSERT/UPDATE | 確認トークン情報 |

#### usersテーブル更新（新規登録時）

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | confirmation_token | ハッシュ化されたトークン | Devise生成 |
| INSERT | confirmation_sent_at | 現在時刻 | - |
| INSERT | confirmed_at | NULL | 未確認状態 |

#### usersテーブル更新（メールアドレス変更時）

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | unconfirmed_email | 新しいメールアドレス | reconfirmable時 |
| UPDATE | confirmation_token | 新しいトークン | - |
| UPDATE | confirmation_sent_at | 現在時刻 | - |

#### usersテーブル更新（確認完了時）

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | confirmed_at | 現在時刻 | 確認完了 |
| UPDATE | confirmation_token | NULL | トークン無効化 |
| UPDATE | email | unconfirmed_emailの値 | reconfirmable時 |
| UPDATE | unconfirmed_email | NULL | reconfirmable時 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | 標準例外処理 |
| トークン期限切れ | confirm_within設定を超過 | 再送要求を案内 |
| 無効なトークン | 使用済みまたは改ざん | エラーメッセージ表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（同期送信） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 設定なし（Devise標準） |
| 1日あたり上限 | 設定なし |

### 配信時間帯

送信時間帯の制限はなし。登録・変更・再送要求時に即座に送信される。

## セキュリティ考慮事項

- 確認トークンはハッシュ化されてDBに保存される
- トークンは1回使用すると無効化される
- reconfirmableが有効（true）のため、メールアドレス変更時も再確認が必要
- 確認完了前はemailable?がfalseを返し、システムからの通知が送信されない
- confirm_within設定でトークンの有効期限を設定可能（現在は無制限）

## 備考

- reconfirmable = trueにより、メールアドレス変更時は新しいアドレスがunconfirmed_emailに保存され、確認完了後にemailカラムに移動する
- allow_unconfirmed_access_for設定により、確認前でも一定期間アクセスを許可することが可能（現在は0.days = 即時制限）
- User.can_signup?メソッドにより、ユーザー登録の可否がSetting.user_signup設定で制御される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーモデルとDevise設定を理解することが最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | deviseモジュール宣言、confirmableの確認 |
| 1-2 | devise.rb | `config/initializers/devise.rb` | reconfirmable、confirm_within設定 |

**読解のコツ**: Userモデルの49-50行目で`devise :database_authenticatable, :registerable, :confirmable, :encryptable, :recoverable, :rememberable, :trackable`が宣言されている。`:confirmable`がメールアドレス確認機能を提供する。

#### Step 2: メーラーを理解する

DeviseMailerの構造とテンプレートパスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | devise_mailer.rb | `app/mailers/devise_mailer.rb` | Devise::Mailerの継承、template_pathsの設定 |

**主要処理フロー**:
1. **8行目**: `class DeviseMailer < Devise::Mailer` - Devise標準メーラーを継承
2. **9-11行目**: `template_paths` - テンプレート参照先を「devise/mailer」に設定

#### Step 3: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | confirmation_instructions.html.haml | `app/views/devise/mailer/confirmation_instructions.html.haml` | メール本文テンプレート |

**主要処理フロー**:
- **2行目**: `t('.greeting', recipient: @resource.email)` - 挨拶文
- **3行目**: `t('.instruction')` - 確認手順の説明
- **4行目**: `link_to t('.action'), confirmation_url(@resource, confirmation_token: @token)` - 確認リンク

#### Step 4: ユーザーの状態判定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | user.rb | `app/models/users/user.rb` | confirmed?、emailable?、active_for_authentication?メソッド |

**主要処理フロー**:
- **120-122行目**: `active_for_authentication?` - super && confirmed? && !awaits_approval? && !suspended?
- **138-140行目**: `emailable?` - confirmed? && !awaits_approval? && !suspended? && email.present?

### プログラム呼び出し階層図

```
ユーザー登録/メールアドレス変更
    │
    ├─ Devise::RegistrationsController#create（新規登録）
    │      │
    │      └─ User.create
    │             │
    │             └─ after_create: send_on_create_confirmation_instructions
    │
    ├─ UsersController#update（メールアドレス変更）
    │      │
    │      └─ User.update(email: new_email)
    │             │
    │             └─ reconfirmable?
    │                    │
    │                    ├─ Yes: unconfirmed_emailに保存 → send_confirmation_instructions
    │                    └─ No: emailを直接更新
    │
    └─ Devise::ConfirmationsController#create（再送要求）
           │
           └─ User.send_confirmation_instructions
                  │
                  └─ DeviseMailer.confirmation_instructions
                         └─ mail(to:, subject:)
                                └─ confirmation_instructions.html.haml
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザー登録/            User.create / User.update
メールアドレス変更
    │                        │
    │  email                 ▼
    └─────────────▶ Confirmable module
                           │
                     ┌─────┴─────┐
                     ▼           ▼
               新規登録    メールアドレス変更
                     │           │
                     │    reconfirmable?
                     │           │
                     ▼           ▼
               confirmation_token生成
               confirmation_sent_at更新
                     │
                     ▼
               DeviseMailer.confirmation_instructions
                     │
                     ▼
               SMTPサーバー ──────────────────▶ Email
                     │
                     ▼
               ユーザーがリンククリック
                     │
                     ▼
               Devise::ConfirmationsController#show
                     │
                     ▼
               confirmed_at更新、email更新（reconfirmable時）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| devise_mailer.rb | `app/mailers/devise_mailer.rb` | ソース | DeviseMailerクラス定義 |
| confirmation_instructions.html.haml | `app/views/devise/mailer/confirmation_instructions.html.haml` | テンプレート | メール本文テンプレート |
| user.rb | `app/models/users/user.rb` | ソース | Userモデル、devise設定、confirmed?、emailable? |
| devise.rb | `config/initializers/devise.rb` | 設定 | Devise設定（reconfirmable、confirm_within等） |
