---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-コメント通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/polymorphic/comment.rb`（1-74行）
- E-02: `app/mailers/subscription_mailer.rb`（1-36行）
- E-03: `app/views/subscription_mailer/comment_notification.text.erb`（1-7行）
- E-04: `app/models/users/user.rb`（1-215行）
- E-05: `spec/mailers/subscription_mailer_spec.rb`（1-48行）
- E-06: `spec/models/polymorphic/comment_spec.rb`（42-74行）
- E-07: `config/locales/fat_free_crm.en-US.yml`（785-788行）
- E-08: `db/schema.rb`（467-468行）
- E-09: `app/models/entities/account.rb`（44行）
- E-10: `config/initializers/action_mailer.rb`（1-23行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コメント作成後にafter_createコールバックで通知が送信される | E-01（35行目：after_create :subscribe_user_to_entity, :notify_subscribers） | ○ |
| C-02 | 購読者はsubscribed_usersフィールドから取得される | E-01（55行目：User.where(id: commentable.subscribed_users.reject...)） | ○ |
| C-03 | コメント作成者は通知対象から除外される | E-01（55行目：subscribed_users.reject { |user_id| user_id == user.id }） | ○ |
| C-04 | emailable?がtrueのユーザーのみ送信対象 | E-01（56行目：users_to_notify.select(&:emailable?)） | ○ |
| C-05 | subscribe_to_comment_replies?がtrueのユーザーのみ送信対象 | E-01（57行目：if subscriber.subscribe_to_comment_replies?） | ○ |
| C-06 | deliver_laterによる非同期送信 | E-01（57行目：.deliver_later） | ○ |
| C-07 | @メンションでユーザーを購読者に追加 | E-01（63-70行目：subscribe_mentioned_users） | ○ |
| C-08 | コメント作成者は自動的に購読者に追加される | E-01（48-51行目：subscribe_user_to_entity） | ○ |
| C-09 | 件名形式はRE: [entity_type:entity_id] entity_name | E-02（18行目：subject = "RE: [#{@entity_type.downcase}:#{@entity.id}] #{@entity_name}"） | ○ |
| C-10 | タグが存在する場合は件名に追加される | E-02（19行目：subject += " (#{@entity.tags.join(', ')})" if @entity.tags.any?） | ○ |
| C-11 | 送信元アドレスはSetting.email_comment_replies.addressを優先 | E-02（30行目：Setting.dig(:email_comment_replies, :address).presence） | ○ |
| C-12 | フォールバックとしてSetting.smtp.fromを使用 | E-02（31行目：Setting.dig(:smtp, :from).presence） | ○ |
| C-13 | 最終フォールバックはnoreply@fatfreecrm.com | E-02（32行目："noreply@fatfreecrm.com"） | ○ |
| C-14 | テキスト形式のメール | E-03（.text.erb拡張子） | ○ |
| C-15 | 本文にコメント作成者名、エンティティ情報が含まれる | E-03（1行目：I18n.t('comment_notification.intro', user_full_name: @user.full_name...）） | ○ |
| C-16 | 本文にコメント内容が含まれる | E-03（3行目：sanitize(@comment.comment)） | ○ |
| C-17 | 本文にエンティティへのリンクが含まれる | E-03（7行目：polymorphic_url(@entity)） | ○ |
| C-18 | emailable?はconfirmed? AND NOT awaits_approval? AND NOT suspended? AND email.present? | E-04（138-140行目） | ○ |
| C-19 | subscribed_usersはシリアライズされた配列 | E-09（serialize :subscribed_users, type: Array） | ○ |
| C-20 | subscribe_to_comment_repliesカラムがusersテーブルに存在 | E-08（467行目：subscribe_to_comment_replies） | ○ |
| C-21 | ポリモーフィック関連でcommentableと関連付け | E-01（26行目：belongs_to :commentable, polymorphic: true） | ○ |
| C-22 | sanitizeでコメント内容をエスケープ | E-03（3行目：sanitize(@comment.comment)） | ○ |
| C-23 | I18n翻訳キーcomment_notification.introを使用 | E-07（786行目）、E-03（1行目） | ○ |
| C-24 | I18n翻訳キーcomment_notification.reply_instructionsを使用 | E-07（787行目）、E-03（7行目） | ○ |
| C-25 | specで件名形式が検証されている | E-05（23-25行目） | ○ |
| C-26 | specで受信者が正しいことが検証されている | E-05（19-21行目） | ○ |
| C-27 | 購読者通知のテストがcomment_specに存在 | E-06（50-74行目） | ○ |
| C-28 | before_createでsubscribe_mentioned_usersが実行される | E-01（34行目：before_create :subscribe_mentioned_users） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主要な主張についてソースコードによる裏付けが確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] メールテンプレートの翻訳キーが他言語でも定義されているか確認
- [ ] privateコメントの場合のアクセス制御について運用ルールを確認
- [ ] Active Jobのリトライ設定が本番環境で適切に構成されているか確認
