---
generated_at: 2026-01-13 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-エンティティ割当通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/observers/entity_observer.rb`（1-41行）
- E-02: `app/mailers/user_mailer.rb`（1-24行）
- E-03: `app/views/user_mailer/assigned_entity_notification.html.haml`（1-3行）
- E-04: `spec/mailers/user_mailer_spec.rb`（1-115行）
- E-05: `spec/models/observers/entity_observer_spec.rb`（参照確認）
- E-06: `db/schema.rb`（468行目：receive_assigned_notifications）
- E-07: `config/locales/fat_free_crm.en-US.yml`（275行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EntityObserverがAccount、Contact、Lead、Opportunityを監視 | E-01（9行目：observe :account, :contact, :lead, :opportunity） | ○ |
| C-02 | after_createで新規作成時に通知をトリガー | E-01（11-13行目：def after_create） | ○ |
| C-03 | after_updateで更新時に通知をトリガー | E-01（15-17行目：def after_update） | ○ |
| C-04 | current_user != assigneeの場合のみ送信（create時） | E-01（12行目：if current_user != item.assignee） | ○ |
| C-05 | assigned_toが変更された場合のみ送信（update時） | E-01（16行目：if item.saved_change_to_assigned_to?） | ○ |
| C-06 | assignee != current_userの場合のみ送信（update時） | E-01（16行目：&& item.assignee != current_user） | ○ |
| C-07 | assignee.present?が条件 | E-01（22行目：if item.assignee.present?） | ○ |
| C-08 | receive_assigned_notifications?が条件 | E-01（22行目：&& item.assignee.receive_assigned_notifications?） | ○ |
| C-09 | current_user.present?が条件 | E-01（22行目：&& current_user.present?） | ○ |
| C-10 | can_send_email?（Setting.host.present?）が条件 | E-01（22行目：&& can_send_email?）、（27行目：Setting.host.present?） | ○ |
| C-11 | deliver_laterによる非同期送信 | E-01（22行目：.deliver_later） | ○ |
| C-12 | 件名形式は「Fat Free CRM: You have been assigned {name} {type}」 | E-02（14行目）、E-04（27-28行目、52-53行目等） | ○ |
| C-13 | 送信元はSetting.smtp.fromまたはデフォルト | E-02（21-22行目：Setting.dig(:smtp, :from).presence \|\| "Fat Free CRM <noreply@fatfreecrm.com>"） | ○ |
| C-14 | 送信先はentity.assignee.email | E-02（15行目：to: entity.assignee.email） | ○ |
| C-15 | @entity_urlにはurl_for(entity)を設定 | E-02（10行目：@entity_url = url_for(entity)） | ○ |
| C-16 | @entity_nameにはentity.nameを設定 | E-02（11行目：@entity_name = entity.name） | ○ |
| C-17 | @entity_typeにはentity.class.nameを設定 | E-02（12行目：@entity_type = entity.class.name） | ○ |
| C-18 | @assigner_nameにはassigner.nameを設定 | E-02（13行目：@assigner_name = assigner.name） | ○ |
| C-19 | テンプレートはHTML形式（.html.haml） | E-03（ファイル拡張子） | ○ |
| C-20 | 本文に同僚名、エンティティ名、種別、URLを含む | E-03（1-3行目）、E-04（31-32行目、35-36行目等） | ○ |
| C-21 | current_userはPaperTrail.request.whodunnitから取得 | E-01（32行目：user_id_or_user = PaperTrail.request.whodunnit） | ○ |
| C-22 | whodunnitがUserオブジェクトの場合はそのまま返す | E-01（33-34行目） | ○ |
| C-23 | whodunnitがStringの場合はUser.find_by_idで検索 | E-01（35-37行目） | ○ |
| C-24 | receive_assigned_notificationsカラムがusersテーブルに存在 | E-06（468行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主要な主張についてソースコードによる裏付けが確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ処理でPaperTrail.whodunnitが設定されないケースの運用確認
- [ ] Setting.hostが本番環境で正しく設定されているか確認
- [ ] CampaignやTaskの割当通知が不要であることの業務確認
