---
generated_at: 2026-01-13 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-Dropbox通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **C-22**: notifyメソッドの呼び出し箇所の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/fat_free_crm/mail_processor/dropbox.rb`（1-265行）
- E-02: `lib/fat_free_crm/mail_processor/base.rb`（1-226行）
- E-03: `app/mailers/dropbox_mailer.rb`（1-20行）
- E-04: `app/views/dropbox_mailer/dropbox_notification.html.haml`（1-9行）
- E-05: `config/locales/fat_free_crm.en-US.yml`（777-779行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IMAPサーバーからメールを取得して処理する | E-02（69-79行目：connect!、96-118行目：with_new_emails） | ○ |
| C-02 | 未読メール（NOT SEEN）を対象とする | E-02（97行目：@imap.uid_search(%w[NOT SEEN])） | ○ |
| C-03 | text/html形式のみのメールは無効 | E-02（145-148行目：is_valid?） | ○ |
| C-04 | 送信者がCRMユーザーでない場合は破棄 | E-02（152-156行目：sent_from_known_user?） | ○ |
| C-05 | emailまたはalt_emailで送信者を検索 | E-02（160-168行目：find_sender） | ○ |
| C-06 | suspended_atがNULLのユーザーのみ対象 | E-02（162行目：suspended_at IS NULL） | ○ |
| C-07 | 明示的キーワードでエンティティタイプを指定可能 | E-01（55-58行目：with_explicit_keyword） | ○ |
| C-08 | To/CCアドレスでエンティティを検索 | E-01（62-77行目：with_recipients） | ○ |
| C-09 | emailまたはalt_emailでエンティティを検索 | E-01（126-129行目：find_and_attach） | ○ |
| C-10 | 権限チェックを行う | E-02（171-177行目：sender_has_permissions_for?） | ○ |
| C-11 | Email.createでメール記録を作成 | E-01（157-168行目、174-185行目：attach） | ○ |
| C-12 | Leadのstatusをcontactedに更新 | E-01（171行目） | ○ |
| C-13 | attach_to_account設定でAccountにも関連付け | E-01（173-187行目） | ○ |
| C-14 | deliver_laterによる非同期送信 | E-01（261行目：.deliver_later） | ○ |
| C-15 | 件名はI18n翻訳キーdropbox_notification_subjectを使用 | E-03（15行目）、E-05（777行目） | ○ |
| C-16 | @mediator_linksにはエンティティリンクを設定 | E-03（11行目：mediator_links.join("\n")） | ○ |
| C-17 | @subjectには元メールの件名を設定 | E-03（12行目：email.subject） | ○ |
| C-18 | @bodyには元メールの本文を設定 | E-03（13行目：email.body_plain） | ○ |
| C-19 | I18n.localeをSetting.localeに設定 | E-03（10行目：I18n.locale = Setting.locale） | ○ |
| C-20 | テンプレートでdropbox_notification_intro、dropbox_notification_toを使用 | E-04（2行目、4行目）、E-05（778-779行目） | ○ |
| C-21 | 送信元はドロップボックス設定のアドレス | E-03（17行目：from: from）、E-01（260行目：@settings[:address]） | ○ |
| C-22 | notifyメソッドが処理完了時に呼び出される | E-01（258-262行目）※呼び出し箇所が明確でない | △ |

## 4) 不足情報（Unknown / Missing）
- notifyメソッドの呼び出し箇所がdropbox.rb内で明確に確認できない
  - 候補：processメソッド内での呼び出し / attachメソッド内での呼び出し / 外部からの呼び出し

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - notifyメソッドの呼び出しタイミングの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] notifyメソッドが実際にどこから呼び出されているか確認
- [ ] create_dropbox_notificationとdropbox_notificationの関係を確認
- [ ] メールドロップボックス機能のバッチ実行スケジュールを確認
- [ ] IMAP設定（email_dropbox）が本番環境で正しく設定されているか確認
