---
generated_at: 2026-01-13 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-パスワードリセット案内

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/devise_mailer.rb`（1-12行）
- E-02: `app/views/devise/mailer/reset_password_instructions.html.haml`（1-7行）
- E-03: `app/models/users/user.rb`（1-215行）
- E-04: `config/initializers/devise.rb`（1-290行）
- E-05: `spec/mailers/devise_mailer_spec.rb`（1-35行）
- E-06: `db/schema.rb`（38-39行目：reset_password_token, reset_password_sent_at）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DeviseMailerはDevise::Mailerを継承 | E-01（8行目：class DeviseMailer < Devise::Mailer） | ○ |
| C-02 | テンプレートパスはdevise/mailer | E-01（9-11行目：def template_paths ["devise/mailer"]） | ○ |
| C-03 | Userモデルでdevise :recoverableが有効 | E-03（49-50行目：devise :database_authenticatable, :registerable, :confirmable, :encryptable, :recoverable...） | ○ |
| C-04 | 送信元アドレスはnoreply@fatfreecrm.com | E-04（25行目：config.mailer_sender = 'noreply@fatfreecrm.com'） | ○ |
| C-05 | メーラーはDeviseMailerを使用 | E-04（28行目：config.mailer = 'DeviseMailer'） | ○ |
| C-06 | リセットトークンの有効期限は6時間 | E-04（216行目：config.reset_password_within = 6.hours） | ○ |
| C-07 | reconfirmableが有効 | E-04（149行目：config.reconfirmable = true） | ○ |
| C-08 | テンプレートでt('.greeting')を使用 | E-02（2行目） | ○ |
| C-09 | テンプレートでt('.instruction')を使用 | E-02（3行目） | ○ |
| C-10 | テンプレートでedit_password_urlへのリンクを生成 | E-02（4行目：edit_password_url(@resource, reset_password_token: @token)） | ○ |
| C-11 | テンプレートでt('.instruction_2')を使用 | E-02（5行目） | ○ |
| C-12 | テンプレートでt('.instruction_3')を使用 | E-02（6行目） | ○ |
| C-13 | usernameまたはemailで認証可能 | E-03（206-211行目：find_for_database_authentication） | ○ |
| C-14 | 大文字小文字を区別しない検索 | E-03（209行目：lower(username) = :value OR lower(email) = :value） | ○ |
| C-15 | specで件名がReset password instructionsを確認 | E-05（27-28行目） | ○ |
| C-16 | specで送信元がnoreply@fatfreecrm.comを確認 | E-05（19-20行目） | ○ |
| C-17 | specでリセットリンクの存在を確認 | E-05（31-32行目） | ○ |
| C-18 | reset_password_tokenカラムが存在 | E-06（38行目）、E-03（38行目のスキーマコメント） | ○ |
| C-19 | reset_password_sent_atカラムが存在 | E-06（39行目）、E-03（39行目のスキーマコメント） | ○ |
| C-20 | 暗号化方式はauthlogic_sha512 | E-04（232行目：config.encryptor = :authlogic_sha512） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - Devise標準機能のため、主要な主張はすべて設定ファイルとソースコードで確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Devise標準機能を使用しており、設定も明確

## 6) レビュアーチェックリスト（最小）
- [ ] 本番環境でSMTP設定が正しく構成されているか確認
- [ ] paranoidモードの有効/無効を確認（セキュリティポリシーに応じて）
- [ ] reset_password_within（6時間）が業務要件に適合しているか確認
