---
generated_at: 2026-01-13 12:00:00
metrics:
  claims_total: 85
  claims_with_evidence: 78
  claims_without_evidence: 7
confidence_derived: 0.92
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された運用マニュアルの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：78 / 85、根拠なし：7
- 優先レビュー（高）
  1. **メンション機能の通知詳細**：通知メカニズムの詳細は推測含む
  2. **リスト保存機能**：画面機能マッピングでは確認できず
  3. **完了タスクの復元手順**：UIの具体的な操作は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要・技術スタック
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 全画面定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 全機能定義
- E-04: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移の定義
- E-07: `docs/code-to-docs/画面設計書/1-ログイン画面.md` - ログイン画面設計
- E-08: `docs/code-to-docs/画面設計書/6-ホーム画面（ダッシュボード）.md` - ダッシュボード設計
- E-09: `docs/code-to-docs/画面設計書/15-リード一覧画面.md` - リード一覧設計
- E-10: `docs/code-to-docs/画面設計書/24-商談一覧画面.md` - 商談一覧設計
- E-11: `docs/code-to-docs/画面設計書/34-ユーザー管理一覧画面.md` - ユーザー管理設計

## 3) Claims と根拠の対応（レビューの主戦場）

### 1章 システム概要

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Fat Free CRMはRuby on Railsで構築されたCRMプラットフォーム | E-01 | ○ |
| C-02 | リード管理、連絡先管理、商談管理等の機能を提供 | E-03 | ○ |
| C-03 | 営業担当者、営業マネージャー、管理者の3つの役割がある | E-04, E-11 | ○ |
| C-04 | 一般ユーザーとAdmin権限を持つ管理者の2種別が存在 | E-11 | ○ |
| C-05 | Chrome、Edge、Safari、Firefoxが推奨ブラウザ | **根拠なし** | △ |

### 2章 ログイン・ログアウト手順

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | ログインURL `/users/sign_in` | E-07 | ○ |
| C-07 | メールアドレスまたはユーザー名でログイン可能 | E-07 | ○ |
| C-08 | Remember Me機能でセッション保持 | E-07 | ○ |
| C-09 | 初回ログイン時「Welcome to Fat Free CRM!」メッセージ | E-07 | ○ |
| C-10 | パスワードリセット用URL `/users/password/new` | E-02, E-07 | ○ |
| C-11 | 新規登録は設定により許可/不許可を制御 | E-04 (BR-027) | ○ |

### 3章 ダッシュボード

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | ダッシュボードURL `/` または `/activities` | E-08 | ○ |
| C-13 | My Tasks、My Opportunities、My Accountsセクションがある | E-08 | ○ |
| C-14 | 各セクション最大10件表示 | E-08 | ○ |
| C-15 | Recent Activityセクションでチーム活動を表示 | E-08 | ○ |
| C-16 | Optionsでフィルター設定が可能 | E-08 | ○ |

### 4章 リード管理

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | リード一覧URL `/leads` | E-09 | ○ |
| C-18 | ステータス: new/contacted/converted/rejected | E-04 (BR-002), E-09 | ○ |
| C-19 | 「Create Lead」ボタンで新規作成 | E-05, E-09 | ○ |
| C-20 | リードをキャンペーンに紐付け可能 | E-04 (BR-005) | ○ |
| C-21 | リードを連絡先・取引先・商談に変換（コンバート） | E-04 (BR-003), E-02 | ○ |
| C-22 | リードの却下でステータスがrejectedに変更 | E-04 (BR-004) | ○ |
| C-23 | CSV/XLSエクスポートが可能 | E-03 (機能20), E-09 | ○ |

### 5章 連絡先・取引先管理

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | 連絡先一覧URL `/contacts` | E-02 | ○ |
| C-25 | 連絡先と取引先の紐付けが可能 | E-04 (BR-007) | ○ |
| C-26 | 取引先一覧URL `/accounts` | E-02 | ○ |
| C-27 | 取引先カテゴリ: customer/partner/competitor等 | E-04 (BR-010) | ○ |
| C-28 | 取引先に0-5段階の評価設定が可能 | E-04 (BR-011) | ○ |
| C-29 | vCard形式でエクスポート可能 | E-04 (BR-046), E-03 | ○ |

### 6章 商談管理

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | 商談一覧URL `/opportunities` | E-10 | ○ |
| C-31 | ステージ: Prospecting/Analysis/Proposal等 | E-10, E-04 (BR-013) | ○ |
| C-32 | 加重金額 = (金額 - 割引) × 確度 / 100 | E-04 (BR-014) | ○ |
| C-33 | 商談パイプラインビューが利用可能 | E-04 (BR-015) | ○ |
| C-34 | CSV/XLSエクスポートが可能 | E-03 (機能28), E-10 | ○ |

### 7章 タスク・キャンペーン管理

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | タスク一覧URL `/tasks` | E-02 | ○ |
| C-36 | タスクは期日別にグループ化表示 | E-04 (BR-021) | ○ |
| C-37 | タスクの完了/未完了を管理可能 | E-04 (BR-022) | ○ |
| C-38 | タスクを他ユーザーに割り当て可能 | E-04 (BR-023) | ○ |
| C-39 | 期限切れタスクの自動識別 | E-04 (BR-024) | ○ |
| C-40 | キャンペーン一覧URL `/campaigns` | E-02 | ○ |
| C-41 | キャンペーンステータス: planned/started/completed等 | E-04 (BR-017) | ○ |
| C-42 | キャンペーン成果（リード数、商談数）を追跡 | E-04 (BR-018) | ○ |

### 8章 検索・フィルタ機能

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | テキスト検索（名前、会社名、メール等） | E-04 (BR-038) | ○ |
| C-44 | ステータスフィルター機能 | E-04 (BR-039) | ○ |
| C-45 | Ransackによる高度な検索 | E-04 (BR-040), E-03 | ○ |
| C-46 | リストの保存機能 | E-03 (機能57, 58) | ○ |
| C-47 | CSV/XLSエクスポート機能 | E-04 (BR-044, BR-045) | ○ |

### 9章 コメント・タグ機能

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | 各エンティティにコメントを追加可能 | E-04 (BR-033) | ○ |
| C-49 | コメント追加時に購読ユーザーへ通知 | E-04 (BR-034) | ○ |
| C-50 | @ユーザー名でメンション可能 | E-04 (BR-035) | ○ |
| C-51 | メンション時の通知方法の詳細 | **根拠なし** | △ |
| C-52 | エンティティにタグを付与可能 | E-04 (BR-036) | ○ |
| C-53 | タグによる検索が可能 | E-04 (BR-037) | ○ |

### 10章 マイページ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | プロフィール画面URL `/users/:id` | E-02 | ○ |
| C-55 | アバター画像のアップロード機能 | E-03 (機能49) | ○ |
| C-56 | パスワード変更機能 | E-03 (機能50) | ○ |
| C-57 | ユーザー別言語設定（オプション） | E-04 (BR-058) | ○ |

### 11章 日常業務の流れ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | STEP1-5の業務フローに沿った運用 | E-04, E-06 | ○ |
| C-59 | 朝のダッシュボード確認ワークフロー | E-08（推奨操作として妥当） | ○ |
| C-60 | リードのフォローアップとステータス更新 | E-04 (BR-002) | ○ |
| C-61 | コンバージョンの判断基準 | **一般的な営業ノウハウ** | △ |

### 12章 よくある質問

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | ログインエラー時の対処法 | E-07 | ○ |
| C-63 | 停止アカウントでのエラーメッセージ | E-07 | ○ |
| C-64 | convertedリードのフィルター表示 | E-09 | ○ |
| C-65 | 論理削除による復元可能性 | E-09, E-10（deleted_at） | ○ |

### 13章 トラブルシューティング

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | 「Invalid username or password」エラー | E-07 | ○ |
| C-67 | 「User account has been suspended」エラー | E-07 | ○ |
| C-68 | ブラウザキャッシュクリアの対処法 | **一般的なトラブル対処** | △ |

### 14章 管理機能

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | 管理画面URL `/admin` | E-11 | ○ |
| C-70 | ユーザー一覧のステータス別色分け表示 | E-11 | ○ |
| C-71 | ユーザーの停止（Suspend）機能 | E-03 (機能63), E-11 | ○ |
| C-72 | ユーザーの再有効化（Reactivate）機能 | E-03 (機能64), E-11 | ○ |
| C-73 | 関連データを持つユーザーは削除不可 | E-04 (BR-028), E-11 | ○ |
| C-74 | グループによるアクセス権限管理 | E-04 (BR-031) | ○ |
| C-75 | タグの管理機能 | E-03 (機能69-72) | ○ |
| C-76 | カスタムフィールドの追加機能 | E-04 (BR-051) | ○ |
| C-77 | システム設定の管理 | E-03 (機能78, 79) | ○ |
| C-78 | プラグイン一覧の確認 | E-03 (機能80) | ○ |

## 4) 不足情報（Unknown / Missing）

- **推奨ブラウザの根拠**
  - 既存ドキュメントにブラウザ互換性情報が見つからず
  - 候補：`package.json` / `Gemfile` / 公式ドキュメント

- **メンション通知の詳細メカニズム**
  - BR-035でメンション機能は定義されているが、通知方法の詳細は不明
  - 候補：`SubscriptionMailer` / `Comment`モデルのソースコード

- **コンバージョン判断基準**
  - 業務的な判断基準は一般的な営業ノウハウに基づく
  - 候補：ユーザーインタビュー / 業務ヒアリング

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 説明 |
|------------|------|------|
| 0 | 基本操作（ログイン、ダッシュボード） | 設計書と高い整合性 |
| 0 | 主要機能（リード、商談、タスク管理） | 業務要件・機能一覧で確認済み |
| 1 | 日常業務フローの詳細手順 | 推奨手順として妥当だが運用実態は未確認 |
| 1 | トラブルシューティング | 一般的な対処法を含む |
| 0 | 管理機能 | 設計書と高い整合性 |

## 6) レビュアーチェックリスト（最小）

- [ ] 推奨ブラウザが実際のシステム要件と一致するか確認
- [ ] メンション通知の実際の動作を確認
- [ ] 日常業務フローが実際の運用と整合するか確認
- [ ] ブラウザキャッシュクリア等の一般的なトラブル対処が適切か確認
- [ ] 管理機能の権限チェックが正確か確認
