# Fat Free CRM 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（ダッシュボード）](#3-トップページダッシュボード)

**【業務フローに沿った機能】**
4. [【STEP1】リード管理（見込み客の獲得・登録）](#4-step1リード管理見込み客の獲得登録)
5. [【STEP2-3】連絡先・取引先管理（顧客情報の整備）](#5-step2-3連絡先取引先管理顧客情報の整備)
6. [【STEP3-4】商談管理（営業案件の進捗管理）](#6-step3-4商談管理営業案件の進捗管理)
7. [【STEP4-5】タスク・キャンペーン管理（活動管理と成果追跡）](#7-step4-5タスクキャンペーン管理活動管理と成果追跡)

**【サポート機能】**
8. [検索・フィルタ機能](#8-検索フィルタ機能)
9. [コメント・タグ機能](#9-コメントタグ機能)
10. [マイページ（ユーザープロフィール）](#10-マイページユーザープロフィール)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

**【管理者向け】**
14. [管理機能](#14-管理機能)

---

## 1. システム概要

### 1.1 Fat Free CRMとは

Fat Free CRMは、Ruby on Railsで構築されたオープンソースの顧客関係管理（CRM）プラットフォームです。営業チームのグループコラボレーション、キャンペーン管理、リード管理、連絡先リスト、商談トラッキングなどの機能を標準で提供し、企業の営業活動を包括的にサポートします。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **リード管理** | 見込み客の登録、ステータス管理、顧客への変換（コンバージョン） |
| **連絡先・取引先管理** | 顧客連絡先の登録・編集、企業アカウントの管理、関連付け |
| **商談管理** | 営業案件の登録、ステージ管理、金額・確度・クローズ日の追跡 |
| **キャンペーン管理** | マーケティングキャンペーンの計画・実行・効果測定 |
| **タスク管理** | ToDo管理、期日設定、担当者割り当て、進捗追跡 |
| **チーム管理** | ユーザー・グループ管理、権限設定、活動履歴の共有 |

### 1.3 業務フロー概要

本システムにおける営業業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                    CRM営業業務フロー                              │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】リード獲得・登録                                       │
│      マーケティング活動や展示会でリード（見込み客）を獲得・登録       │
│      ↓                                                          │
│  【STEP 2】リードのフォローアップ                                  │
│      リードに連絡を取り、ニーズを確認し、状態を更新                 │
│      ↓                                                          │
│  【STEP 3】リードのコンバージョン（顧客化）                         │
│      有望なリードを連絡先・取引先・商談に変換                       │
│      ↓                                                          │
│  【STEP 4】商談の進捗管理                                         │
│      商談ステージを更新し、提案・交渉を進める                       │
│      ↓                                                          │
│  【STEP 5】成約・クローズ                                         │
│      商談を成約（Won）または失注（Lost）としてクローズ              │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **営業担当者** | リードのフォローアップ、商談の進捗管理、タスクの実行、顧客とのコミュニケーション |
| **営業マネージャー** | チームの活動監視、商談パイプラインの分析、キャンペーン効果の確認 |
| **管理者** | ユーザー管理、グループ設定、システム設定、カスタムフィールドの管理 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| リード管理 | 見込み客情報の登録・ステータス管理・コンバージョン | STEP 1-3 |
| 連絡先管理 | 顧客連絡先の登録・編集・商談との紐付け | STEP 3-5 |
| 取引先管理 | 企業アカウントの管理・分類 | STEP 3-5 |
| 商談管理 | 営業案件のステージ管理・パイプライン表示 | STEP 3-5 |
| キャンペーン管理 | マーケティング活動の計画・追跡・効果測定 | STEP 1 |
| タスク管理 | ToDo管理・期日管理・担当者割り当て | 随時利用 |
| ダッシュボード | 活動履歴・タスク・商談・取引先の一覧表示 | 随時参照 |
| 検索・フィルタ | エンティティの検索・絞り込み・リスト保存 | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 一般ユーザー | 営業担当者として、リード・連絡先・商談などを管理 |
| 管理者（Admin） | システム全体の設定、ユーザー管理、カスタムフィールド管理が可能 |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 ログイン方法

1. ブラウザでFat Free CRMのログインページ（`/users/sign_in`）にアクセスします
2. ログイン画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| メールアドレス/ユーザー名 | 登録済みのメールアドレスまたはユーザー名 |
| パスワード | 設定済みのパスワード |
| Remember Me | チェックするとログイン状態を保持 |

3. 「Login」ボタンをクリックします
4. 認証に成功すると、ダッシュボード（TOP画面）が表示されます

**初回ログイン時のメッセージ：**
- 初回ログイン時: 「Welcome to Fat Free CRM!」と表示されます
- 2回目以降: 「Your last login was on [日時].」と表示されます

### 2.2 ログアウト方法

1. 画面右上のユーザー名またはプロフィールアイコンをクリックします
2. 表示されるドロップダウンメニューから「Sign Out」を選択します
3. ログイン画面に戻ります

### 2.3 パスワードを忘れた場合

1. ログイン画面の「Forgot Password?」リンクをクリックします
2. パスワードリセット申請画面（`/users/password/new`）が表示されます
3. 登録済みのメールアドレスを入力し、「Reset Password」ボタンをクリックします
4. メールに記載されたリンクをクリックし、新しいパスワードを設定します
5. パスワードリセット完了後、ログイン画面に戻ります

### 2.4 新規ユーザー登録（許可されている場合）

※システム設定により、自己登録が許可されている場合のみ利用可能です。

1. ログイン画面の「Sign Up Now!」リンクをクリックします
2. ユーザー登録画面（`/users/sign_up`）で必要事項を入力します
3. 「Sign Up」ボタンをクリックします
4. 確認メールが送信されます（設定による）
5. メール内のリンクをクリックしてアカウントを有効化します

---

## 3. トップページ（ダッシュボード）

### 3.1 ダッシュボード概要

ログイン後に表示されるメイン画面です。自分に関連するタスク、商談、取引先、および最近のアクティビティを一覧で確認できます。

**URL**: `/` または `/activities`

### 3.2 ダッシュボードの構成

ダッシュボードは以下のセクションで構成されています：

| セクション | 説明 |
|-----------|------|
| My Tasks | 自分に割り当てられたタスク一覧（最大10件） |
| My Opportunities | 自分が担当する商談一覧（最大10件） |
| My Accounts | 自分が担当する取引先一覧（最大10件） |
| Recent Activity | チーム全体の最近の活動履歴 |

### 3.3 各セクションの操作

**My Tasks セクション：**
- タスク名をクリックすると詳細が表示されます
- 完了したタスクはチェックマークで完了状態にできます
- 「+」ボタンで新規タスクを作成できます

**My Opportunities セクション：**
- 商談名をクリックすると商談詳細画面に遷移します
- ステージや金額が一目で確認できます

**My Accounts セクション：**
- 取引先名をクリックすると取引先詳細画面に遷移します

**Recent Activity セクション：**
- 「Options」リンクをクリックしてフィルター設定を変更できます
- フィルター条件：アセット種別、イベント種別、ユーザー、期間

### 3.4 ナビゲーションメニュー

画面上部のナビゲーションバーから各機能にアクセスできます：

| メニュー | 説明 |
|---------|------|
| Dashboard | ダッシュボードに戻る |
| Accounts | 取引先一覧画面 |
| Campaigns | キャンペーン一覧画面 |
| Leads | リード一覧画面 |
| Contacts | 連絡先一覧画面 |
| Opportunities | 商談一覧画面 |
| Tasks | タスク一覧画面 |
| Admin | 管理画面（管理者のみ） |

---

## 4. 【STEP1】リード管理（見込み客の獲得・登録）

> **業務フローでの位置**: マーケティング活動や展示会で獲得した見込み客（リード）を登録し、フォローアップ対象として管理するステップです。

### 4.1 リード一覧を確認する

1. ナビゲーションメニューから「Leads」をクリックします
2. リード一覧画面（`/leads`）が表示されます
3. サイドバーでステータス（new/contacted/converted/rejected）ごとにフィルタリングできます

**リード一覧の表示項目：**
- リード名（氏名）
- 会社名
- 役職
- ステータス
- ソース（獲得元）
- レーティング（優先度）
- 作成日

### 4.2 新規リードを登録する

1. リード一覧画面で「Create Lead」ボタンをクリックします
2. 新規作成フォームがモーダル表示されます
3. 以下の情報を入力します：

| 項目 | 必須 | 説明 |
|------|------|------|
| First Name | ○（設定による） | 名 |
| Last Name | ○（設定による） | 姓 |
| Company | - | 会社名 |
| Title | - | 役職 |
| Source | - | 獲得元（campaign/referral/web等） |
| Status | ○ | ステータス（デフォルト: new） |
| Email | - | メールアドレス |
| Phone | - | 電話番号 |
| Campaign | - | 紐付けるキャンペーン |
| Access | ○ | アクセス権限（Private/Public/Shared） |

4. 「Save Lead」ボタンをクリックして登録します

### 4.3 リードのステータスを更新する

リードのステータスは以下の4段階で管理されます：

| ステータス | 説明 |
|-----------|------|
| new | 新規登録されたリード |
| contacted | 連絡済み（電話・メール等） |
| converted | 連絡先・商談に変換済み |
| rejected | 却下（見込みなし） |

**ステータス更新手順：**
1. リード詳細画面を開きます
2. 「Edit」ボタンをクリックします
3. ステータスを変更して保存します

### 4.4 リードを顧客に変換（コンバート）する

有望なリードは、連絡先・取引先・商談に変換できます：

1. リード詳細画面で「Convert」ボタンをクリックします
2. リード変換画面が表示されます
3. 以下のオプションを選択します：
   - **取引先**: 新規作成/既存から選択/作成しない
   - **商談**: 新規作成するか選択
4. 「Convert Lead」ボタンをクリックします
5. 変換成功後、作成された連絡先詳細画面に遷移します

### 4.5 リードを却下する

見込みのないリードは却下できます：

1. リード詳細画面で「Reject」ボタンをクリックします
2. リードのステータスが「rejected」に変更されます

---

## 5. 【STEP2-3】連絡先・取引先管理（顧客情報の整備）

> **業務フローでの位置**: リードから変換された連絡先・取引先を管理し、顧客情報を整備するステップです。

### 5.1 連絡先を管理する

#### 5.1.1 連絡先一覧を確認する

1. ナビゲーションメニューから「Contacts」をクリックします
2. 連絡先一覧画面（`/contacts`）が表示されます

#### 5.1.2 新規連絡先を登録する

1. 「Create Contact」ボタンをクリックします
2. 以下の情報を入力します：
   - 氏名（First Name / Last Name）
   - 所属取引先
   - 役職・部門
   - 連絡先情報（メール、電話、携帯）
   - 住所情報
   - ソーシャルメディアリンク
3. 「Save Contact」ボタンで保存します

#### 5.1.3 連絡先と取引先を紐付ける

1. 連絡先詳細画面を開きます
2. 「Edit」ボタンをクリックします
3. 「Account」フィールドで既存の取引先を選択、または新規作成します
4. 保存します

### 5.2 取引先を管理する

#### 5.2.1 取引先一覧を確認する

1. ナビゲーションメニューから「Accounts」をクリックします
2. 取引先一覧画面（`/accounts`）が表示されます
3. サイドバーでカテゴリ（customer/partner/competitor等）ごとにフィルタリングできます

#### 5.2.2 新規取引先を登録する

1. 「Create Account」ボタンをクリックします
2. 以下の情報を入力します：

| 項目 | 必須 | 説明 |
|------|------|------|
| Name | ○ | 取引先名（会社名） |
| Category | - | カテゴリ（customer/partner/competitor等） |
| Rating | - | 評価（0-5段階） |
| Website | - | Webサイト |
| Email | - | メールアドレス |
| Phone | - | 電話番号 |
| Access | ○ | アクセス権限 |

3. 「Save Account」ボタンで保存します

#### 5.2.3 取引先詳細を確認する

取引先詳細画面では以下の情報を確認できます：
- 基本情報
- 関連する連絡先一覧
- 関連する商談一覧
- コメント・タイムライン
- 変更履歴

### 5.3 vCardエクスポート

連絡先情報をvCard形式でダウンロードできます：
1. 連絡先詳細画面を開きます
2. 「vCard」リンクをクリックします
3. vCardファイル（.vcf）がダウンロードされます

---

## 6. 【STEP3-4】商談管理（営業案件の進捗管理）

> **業務フローでの位置**: 連絡先・取引先との商談を登録し、ステージ管理を行いながら成約に向けて進捗を管理するステップです。

### 6.1 商談一覧を確認する

1. ナビゲーションメニューから「Opportunities」をクリックします
2. 商談一覧画面（`/opportunities`）が表示されます
3. サイドバーでステージごとにフィルタリングできます

**商談ステージ一覧：**

| ステージ | 説明 |
|---------|------|
| Prospecting | 見込み段階 |
| Analysis | 分析・ニーズ把握段階 |
| Proposal | 提案段階 |
| Presentation | プレゼンテーション段階 |
| Negotiation | 交渉段階 |
| Final Review | 最終確認段階 |
| Won | 成約（受注） |
| Lost | 失注 |

### 6.2 新規商談を登録する

1. 「Create Opportunity」ボタンをクリックします
2. 以下の情報を入力します：

| 項目 | 必須 | 説明 |
|------|------|------|
| Name | ○ | 商談名 |
| Account | - | 関連取引先 |
| Stage | ○ | 現在のステージ |
| Amount | - | 金額 |
| Probability | - | 確度（%） |
| Closes On | - | クローズ予定日 |
| Source | - | 獲得元 |
| Campaign | - | 関連キャンペーン |
| Access | ○ | アクセス権限 |

3. 「Save Opportunity」ボタンで保存します

### 6.3 商談のステージを更新する

1. 商談詳細画面を開きます
2. 「Edit」ボタンをクリックします
3. 「Stage」フィールドを変更します
4. 必要に応じて確度や金額も更新します
5. 保存します

### 6.4 商談パイプラインを確認する

商談一覧画面のサイドバーで、ステージ別の件数と金額を確認できます。これにより営業パイプライン全体の状況を把握できます。

### 6.5 加重金額の確認

商談の加重金額は以下の計算式で自動算出されます：

```
加重金額 = (金額 - 割引) × 確度 / 100
```

---

## 7. 【STEP4-5】タスク・キャンペーン管理（活動管理と成果追跡）

> **業務フローでの位置**: 日々の営業活動（タスク）を管理し、マーケティングキャンペーンの効果を追跡するステップです。

### 7.1 タスクを管理する

#### 7.1.1 タスク一覧を確認する

1. ナビゲーションメニューから「Tasks」をクリックします
2. タスク一覧画面（`/tasks`）が表示されます
3. タスクは期日別にグループ化されて表示されます：
   - Overdue（期限切れ）
   - Due Today（今日期限）
   - Due Tomorrow（明日期限）
   - Due This Week（今週期限）
   - Due Next Week（来週期限）
   - Due Later（それ以降）

#### 7.1.2 新規タスクを作成する

1. 「Create Task」ボタンをクリックします
2. 以下の情報を入力します：

| 項目 | 必須 | 説明 |
|------|------|------|
| Name | ○ | タスク名 |
| Due | - | 期日（today/tomorrow/this_week等） |
| Category | - | カテゴリ（call/email/meeting等） |
| Assigned To | - | 担当者（自分または他ユーザー） |
| Related To | - | 関連エンティティ（連絡先、取引先等） |

3. 「Save Task」ボタンで保存します

#### 7.1.3 タスクを完了する

1. タスク一覧でタスク名の横のチェックマークをクリックします
2. または、タスク編集画面で「Complete」ボタンをクリックします
3. 完了日時と完了者が記録されます

#### 7.1.4 完了タスクを元に戻す

完了済みタスクを未完了に戻すことも可能です：
1. タスク編集画面で「Uncomplete」ボタンをクリックします

### 7.2 キャンペーンを管理する

#### 7.2.1 キャンペーン一覧を確認する

1. ナビゲーションメニューから「Campaigns」をクリックします
2. キャンペーン一覧画面（`/campaigns`）が表示されます
3. サイドバーでステータス（planned/started/completed等）ごとにフィルタリングできます

#### 7.2.2 新規キャンペーンを作成する

1. 「Create Campaign」ボタンをクリックします
2. 以下の情報を入力します：

| 項目 | 必須 | 説明 |
|------|------|------|
| Name | ○ | キャンペーン名 |
| Status | ○ | ステータス（planned/started/completed等） |
| Starts On | - | 開始日 |
| Ends On | - | 終了日 |
| Budget | - | 予算 |
| Target Leads | - | 目標リード数 |
| Target Revenue | - | 目標売上 |
| Access | ○ | アクセス権限 |

3. 「Save Campaign」ボタンで保存します

#### 7.2.3 キャンペーン効果を確認する

キャンペーン詳細画面では以下を確認できます：
- 獲得リード数（leads_count）
- 関連商談数（opportunities_count）
- 関連するリード一覧
- 関連する商談一覧

---

## 8. 検索・フィルタ機能

### 8.1 テキスト検索

各一覧画面の検索ボックスでテキスト検索ができます：

1. 検索ボックスにキーワードを入力します
2. Enterキーまたは検索ボタンをクリックします
3. 検索対象：名前、会社名、メールアドレス等

### 8.2 ステータスフィルター

サイドバーのステータス一覧で絞り込みができます：

1. サイドバーで表示したいステータスをクリックします
2. 選択したステータスのデータのみが表示されます
3. フィルター条件はセッションに保存されます

### 8.3 高度な検索（Ransack）

より詳細な検索条件を指定できます：

1. 検索ボックス横の「Advanced Search」リンクをクリックします
2. 検索条件を設定します
3. 「Search」ボタンで検索を実行します

### 8.4 リストの保存

検索条件を保存して再利用できます：

1. 検索を実行した状態で「Save」ボタンをクリックします
2. リスト名を入力して保存します
3. 保存したリストはサイドバーに表示されます

### 8.5 データのエクスポート

一覧データをCSVまたはExcel形式でエクスポートできます：

1. 一覧画面のフッターにある「Export」リンクをクリックします
2. CSV形式またはXLS形式を選択します
3. ファイルがダウンロードされます

---

## 9. コメント・タグ機能

### 9.1 コメントを追加する

各エンティティ（リード、連絡先、取引先、商談、キャンペーン）にコメントを追加できます：

1. 詳細画面のコメント入力欄にコメントを入力します
2. 「Add Comment」ボタンをクリックします
3. コメントがタイムラインに表示されます

**メンション機能：**
- コメント内で `@ユーザー名` と記述すると、そのユーザーに通知されます

### 9.2 タグを付与する

エンティティにタグを付けて分類できます：

1. 詳細画面または編集画面の「Tags」フィールドにタグを入力します
2. 複数のタグはカンマで区切ります
3. 保存するとタグが付与されます

### 9.3 タグで絞り込む

タグをクリックすると、同じタグが付いたエンティティを絞り込み表示できます。

---

## 10. マイページ（ユーザープロフィール）

### 10.1 プロフィールを確認・編集する

1. ナビゲーションバーのユーザー名をクリックします
2. プロフィール画面（`/users/:id`）が表示されます
3. 「Edit」ボタンで以下の情報を編集できます：
   - ユーザー名
   - メールアドレス
   - 氏名（First Name / Last Name）
   - 役職
   - 会社名
   - 電話番号
   - 携帯電話

### 10.2 アバター画像を変更する

1. プロフィール画面で「Upload Avatar」をクリックします
2. 画像ファイルを選択します
3. アップロードされた画像がプロフィールに反映されます

### 10.3 パスワードを変更する

1. プロフィール画面で「Change Password」リンクをクリックします
2. 現在のパスワードと新しいパスワードを入力します
3. 「Change Password」ボタンで変更を確定します

### 10.4 表示言語を変更する

システムがユーザー別言語設定に対応している場合：

1. プロフィール設定で「Locale」を変更します
2. 画面表示言語が変更されます

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】リード獲得・登録 → 4章参照
    ↓
【STEP 2】リードのフォローアップ → 4章参照
    ↓
【STEP 3】リードのコンバージョン（顧客化） → 4-5章参照
    ↓
【STEP 4】商談の進捗管理 → 6章参照
    ↓
【STEP 5】成約・クローズ → 6章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【営業担当者】朝の確認作業

1. **ダッシュボードを確認する**
   - ログインして「My Tasks」セクションで今日のタスクを確認
   - 「My Opportunities」で進行中の商談を確認
   - 「Recent Activity」でチームの動きを把握

2. **期限切れタスクを処理する**
   - タスク一覧画面で「Overdue」セクションを確認
   - 期限切れタスクを完了または期日を変更

### 11.2 【営業担当者】STEP1-2: リードの確認とフォローアップ

1. **新規リードを確認する**
   - リード一覧画面で「new」ステータスでフィルター
   - 新着リードの内容を確認

2. **リードにコンタクトする**
   - リードの連絡先情報を確認
   - 電話またはメールでコンタクト
   - 結果をコメントとして記録
   - ステータスを「contacted」に更新

3. **フォローアップタスクを作成する**
   - 次回アクション用のタスクを作成
   - 期日と担当者を設定

### 11.3 【営業担当者】STEP3: リードのコンバージョン

有望なリードを顧客化します：

1. **コンバージョンの判断**
   - リードのニーズが明確になった
   - 商談の可能性が高い
   - 予算とタイムラインが確認できた

2. **コンバージョンの実行**
   - リード詳細画面で「Convert」をクリック
   - 取引先の作成有無を選択
   - 商談の作成有無を選択
   - コンバージョンを実行

### 11.4 【営業担当者】STEP4: 商談の進捗更新

1. **商談ステージを更新する**
   - 商談詳細画面で「Edit」をクリック
   - ステージを次の段階に進める
   - 確度と金額を更新
   - コメントで経緯を記録

2. **関連タスクを管理する**
   - 次のアクション用タスクを作成
   - 完了したタスクをチェック

### 11.5 【営業マネージャー】STEP4-5: 進捗監視

1. **商談パイプラインを確認する**
   - 商談一覧画面でステージ別件数を確認
   - 停滞している商談を特定

2. **チームの活動を確認する**
   - ダッシュボードの「Recent Activity」を確認
   - 必要に応じて担当者にフォローアップ

3. **週次レポートを作成する**
   - 商談一覧をCSVエクスポート
   - パイプラインサマリーを確認

---

## 12. よくある質問と対処法

### 12.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
1. メールアドレス/ユーザー名が正しいか確認
2. パスワードの大文字・小文字を確認
3. Caps Lockがオフになっているか確認
4. パスワードを忘れた場合は「Forgot Password?」からリセット

**Q: アカウントが停止されていると表示されます**

A: 管理者がアカウントを停止している可能性があります。システム管理者に連絡してください。

**Q: 「承認待ち」と表示されてログインできません**

A: システム設定で新規登録に承認が必要な場合があります。管理者の承認を待つか、管理者に連絡してください。

### 12.2 リード・連絡先に関するQ&A

**Q: リードを連絡先に変換したが、元のリードが見つかりません**

A: コンバージョン後のリードは「converted」ステータスになります。リード一覧画面で「converted」フィルターを選択すると表示されます。

**Q: 連絡先を削除してしまいました**

A: データベースの論理削除のため、管理者に依頼すれば復元できる場合があります。速やかに管理者に連絡してください。

### 12.3 商談に関するQ&A

**Q: 商談の金額が自動計算されません**

A: 加重金額は「金額 × 確度」で計算されます。金額と確度の両方が入力されているか確認してください。

**Q: 商談のステージを戻すことはできますか?**

A: はい、商談編集画面でステージを任意の段階に変更できます。

### 12.4 タスクに関するQ&A

**Q: 他のユーザーにタスクを割り当てるには?**

A: タスク作成・編集画面の「Assigned To」フィールドで担当者を選択できます。

**Q: 完了したタスクを未完了に戻せますか?**

A: はい、タスク編集画面の「Uncomplete」ボタンで未完了に戻せます。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| Invalid username or password. | ログイン情報が間違っている | メールアドレス/パスワードを再確認 |
| User account has been suspended. | アカウントが停止されている | 管理者に連絡 |
| Your account has not been approved yet. | アカウントが未承認 | 管理者の承認を待つ |
| You are not authorized to access this page. | アクセス権限がない | 管理者に権限の確認を依頼 |
| Record not found. | データが存在しない | 削除されたか、アクセス権限がない |

### 13.2 よくあるトラブルと解決方法

**画面が正しく表示されない場合：**
1. ブラウザのキャッシュをクリアする
2. ブラウザを最新版にアップデートする
3. 別のブラウザで試す

**データが保存されない場合：**
1. 必須項目がすべて入力されているか確認
2. 入力値が正しい形式か確認（メールアドレス等）
3. ネットワーク接続を確認

**検索結果が表示されない場合：**
1. 検索キーワードを確認
2. フィルター条件を確認（意図せず絞り込まれている可能性）
3. アクセス権限のあるデータのみ表示されることに注意

**エクスポートが動作しない場合：**
1. ブラウザのポップアップブロッカーを確認
2. ダウンロードフォルダを確認
3. 異なるブラウザで試す

### 13.3 サポートへの連絡方法

トラブルが解決しない場合は、以下の情報を添えてシステム管理者に連絡してください：

1. エラーメッセージの内容（スクリーンショットがあれば添付）
2. 発生した操作の手順
3. 発生日時
4. 使用しているブラウザとバージョン

---

## 14. 管理機能

※本章は管理者（Admin）権限を持つユーザー向けの内容です。

### 14.1 管理画面へのアクセス

1. ナビゲーションメニューから「Admin」をクリックします
2. 管理画面トップ（`/admin`）が表示されます

### 14.2 ユーザー管理

#### 14.2.1 ユーザー一覧を確認する

1. 管理画面で「Users」をクリックします
2. システム内の全ユーザー一覧が表示されます
3. ステータス別に色分け表示されます：
   - Active（アクティブ）
   - Suspended（停止中）
   - Signed Up（承認待ち）
   - Admin（管理者）

#### 14.2.2 新規ユーザーを作成する

1. 「Create User」ボタンをクリックします
2. ユーザー情報を入力します
3. 管理者権限を付与する場合は「Admin」チェックボックスをオンにします
4. 「Save User」ボタンで保存します

#### 14.2.3 ユーザーを停止する

1. ユーザー一覧で対象ユーザーの「Suspend!」リンクをクリックします
2. ユーザーがログインできなくなります

#### 14.2.4 ユーザーを再有効化する

1. 停止中ユーザーの「Reactivate」リンクをクリックします
2. ユーザーが再びログイン可能になります

#### 14.2.5 ユーザーを削除する

1. 「Delete?」リンクをクリックします
2. 確認ダイアログで「OK」をクリックします
3. ※関連データを持つユーザーは削除できません

### 14.3 グループ管理

ユーザーをグループ化してアクセス権限を管理できます：

1. 管理画面で「Groups」をクリックします
2. 「Create Group」でグループを作成します
3. グループにユーザーを追加します
4. データの共有設定でグループを指定できます

### 14.4 タグ管理

システム全体のタグを管理できます：

1. 管理画面で「Tags」をクリックします
2. タグの作成、編集、削除が可能です

### 14.5 カスタムフィールド管理

エンティティにカスタムフィールドを追加できます：

1. 管理画面で「Custom Fields」をクリックします
2. 対象エンティティ（Lead、Contact等）を選択します
3. 「Create Field」でフィールドを追加します
4. フィールドタイプ（テキスト、数値、日付等）を選択します

### 14.6 システム設定

1. 管理画面で「Settings」をクリックします
2. 以下の設定が可能です：
   - ホスト名
   - デフォルトロケール
   - ユーザー登録設定（allowed/not_allowed/needs_approval）
   - デフォルトアクセス権限
   - SMTP設定

### 14.7 プラグイン管理

インストール済みプラグインを確認できます：

1. 管理画面で「Plugins」をクリックします
2. プラグイン一覧が表示されます

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-13 | 初版作成 |

---

*本マニュアルは、Fat Free CRMのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
