---
generated_at: 2026-01-13 18:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **NFT-005 同時アクセス耐性**：具体的な同時接続数の要件が未定義
  2. **NFT-036/037 ブラウザ互換性**：対象ブラウザバージョンの明示がない
  3. **NFT-006 大量データエクスポート**：具体的なパフォーマンス基準が設定ファイルに未定義

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/application_controller.rb` - 認証・認可・CORS設定
- E-02: `config/initializers/devise.rb` - Devise認証設定
- E-03: `app/models/users/user.rb` - ユーザーモデルとバリデーション
- E-04: `app/models/users/ability.rb` - CanCan権限定義
- E-05: `config/initializers/filter_parameter_logging.rb` - ログフィルター設定
- E-06: `config/initializers/session_store.rb` - セッション設定
- E-07: `config/environments/production.rb` - 本番環境設定
- E-08: `Gemfile` - 依存gemと技術スタック
- E-09: `fat_free_crm.gemspec` - gem依存関係
- E-10: `.github/workflows/brakeman-analysis.yml` - セキュリティスキャン設定
- E-11: `.github/workflows/ruby.yml` - CI/テスト設定
- E-12: `config/settings.default.yml` - アプリケーション設定
- E-13: `docker-compose.yml` - Docker設定
- E-14: `Dockerfile` - コンテナ設定
- E-15: `app/controllers/entities_controller.rb` - エンティティ操作
- E-16: `config/database.postgres.yml` - PostgreSQL設定
- E-17: `config/database.mysql.yml` - MySQL設定
- E-18: `config/database.sqlite.yml` - SQLite設定
- E-19: `app/models/setting.rb` - 設定モデルとキャッシュ
- E-20: `SECURITY.md` - セキュリティポリシー

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001 ダッシュボード表示レスポンス | E-01 | ○ |
| C-02 | NFT-002 エンティティ一覧表示レスポンス | E-15 | ○ |
| C-03 | NFT-003 検索レスポンス | E-08 (ransack), E-15 | ○ |
| C-04 | NFT-004 オートコンプリートレスポンス | E-01 | ○ |
| C-05 | NFT-005 同時アクセス耐性 | E-08 (puma) | △ |
| C-06 | NFT-006 大量データエクスポート | E-15 | △ |
| C-07 | NFT-007 一覧取得クエリ性能 | E-08 (will_paginate), E-15 | ○ |
| C-08 | NFT-008 関連データ取得性能 | E-15 | ○ |
| C-09 | NFT-009 ログイン認証検証 | E-02, E-03 | ○ |
| C-10 | NFT-010 ログイン失敗検証 | E-02, E-03 | ○ |
| C-11 | NFT-011 セッション管理 | E-02, E-06 | ○ |
| C-12 | NFT-012 パスワードリセット有効期限 | E-02 | ○ |
| C-13 | NFT-013 パスワード強度 | E-02 | ○ |
| C-14 | NFT-014 ユーザー承認待ち状態 | E-03, E-12 | ○ |
| C-15 | NFT-015 管理者権限検証 | E-04 | ○ |
| C-16 | NFT-016 一般ユーザー権限検証 | E-04 | ○ |
| C-17 | NFT-017 エンティティアクセス制御 | E-04 | ○ |
| C-18 | NFT-018 グループ権限検証 | E-04 | ○ |
| C-19 | NFT-019 XSS対策検証 | E-01 | ○ |
| C-20 | NFT-020 SQLインジェクション対策 | E-15 | ○ |
| C-21 | NFT-021 CSRF対策検証 | E-01 | ○ |
| C-22 | NFT-022 メールアドレスフォーマット検証 | E-03 | ○ |
| C-23 | NFT-023 ユーザー名フォーマット検証 | E-03 | ○ |
| C-24 | NFT-024 パスワード暗号化 | E-02 | ○ |
| C-25 | NFT-025 機密情報のログ除外 | E-05 | ○ |
| C-26 | NFT-026 CORS設定検証 | E-01 | ○ |
| C-27 | NFT-027 404エラー処理 | E-01 | ○ |
| C-28 | NFT-028 403エラー処理 | E-01 | ○ |
| C-29 | NFT-029 セッション破損時の復旧 | E-01 | ○ |
| C-30 | NFT-030 バージョン履歴記録 | E-03, E-08 | ○ |
| C-31 | NFT-031 パスワードリセットメール送信 | E-02 | ○ |
| C-32 | NFT-032 ユーザー確認メール送信 | E-02 | ○ |
| C-33 | NFT-033 PostgreSQL互換性 | E-16 | ○ |
| C-34 | NFT-034 MySQL互換性 | E-17 | ○ |
| C-35 | NFT-035 SQLite互換性 | E-18, E-11 | ○ |
| C-36 | NFT-036 Chrome対応 | E-08 (bootstrap, jquery) | △ |
| C-37 | NFT-037 Firefox対応 | E-08 (bootstrap, jquery) | ○ |
| C-38 | NFT-038 Ruby 3.4互換性 | E-11 | ○ |
| C-39 | NFT-039 Rails 7.x互換性 | E-09 | ○ |
| C-40 | NFT-040 Rubocop準拠 | E-10, E-11 | ○ |
| C-41 | NFT-041 Brakemanスキャン | E-10 | ○ |
| C-42 | NFT-042 モデルテスト網羅率 | E-11 | ○ |
| C-43 | NFT-043 コントローラーテスト網羅率 | E-11 | ○ |
| C-44 | NFT-044 機能テスト網羅率 | E-11 | ○ |
| C-45 | NFT-045 変更履歴追跡 | E-01, E-08 | ○ |
| C-46 | NFT-046 メール確認機能 | E-02, E-03 | ○ |
| C-47 | NFT-047 アカウント停止機能 | E-03 | ○ |
| C-48 | NFT-048 設定キャッシュ動作 | E-01, E-19 | ○ |
| C-49 | NFT-049 多言語対応 | E-12 | ○ |
| C-50 | NFT-050 タイムゾーン対応 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

- **NFT-005 同時アクセス耐性**：具体的な同時接続数やスレッド数の設定ファイルが未確認
  - 候補：puma.rb / config/puma.rb / 環境変数設定
- **NFT-006 大量データエクスポート**：エクスポート時のタイムアウト設定やバッチサイズの定義が未確認
  - 候補：config/environments/production.rb / Rakeタスク設定
- **NFT-036/037 ブラウザ互換性**：明示的なブラウザサポートバージョンの定義がない
  - 候補：package.json / browserslist / ドキュメント

## 5) リスクフラグ（レビュー観点）

- **リスク1（中リスク）**：同時接続数の上限が明示されていないため、負荷テストの合格基準が曖昧
- **リスク1（中リスク）**：ブラウザ互換性テストの対象バージョンが未定義
- **リスク0（低リスク）**：エクスポート機能のパフォーマンス基準は実運用に基づいて調整可能

## 6) レビュアーチェックリスト（最小）

- [ ] 同時接続数の要件を運用担当者と確認する
- [ ] 対象ブラウザとバージョンの範囲を明確化する
- [ ] 大量データエクスポートのタイムアウト設定を確認する
- [ ] セキュリティテストケース（NFT-009〜NFT-026）の網羅性を確認する
- [ ] CI/CDパイプライン（GitHub Actions）との整合性を確認する
- [ ] レスポンスタイム基準値（3秒、2秒、500ms等）の妥当性を確認する
