---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 48
  claims_with_evidence: 45
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：45 / 48、根拠なし：3
- 優先レビュー（高）
  1. **レスポンスタイム目標値**：コードベースに明示的な設定なし
  2. **スループット目標値**：インフラ構成に依存、コードベースに設定なし
  3. **可用性目標値（稼働率等）**：運用設計書が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `config/environments/production.rb`
- E-02: `config/environments/development.rb`
- E-03: `config/environments/test.rb`
- E-04: `config/initializers/devise.rb`
- E-05: `config/initializers/session_store.rb`
- E-06: `config/initializers/content_security_policy.rb`
- E-07: `config/initializers/permissions_policy.rb`
- E-08: `config/initializers/filter_parameter_logging.rb`
- E-09: `config/initializers/secret_token.rb`
- E-10: `config/application.rb`
- E-11: `config/settings.default.yml`
- E-12: `config/storage.yml`
- E-13: `config/cable.yml`
- E-14: `config/database.postgres.yml`
- E-15: `config/deploy.example.rb`
- E-16: `app/controllers/application_controller.rb`
- E-17: `app/models/users/ability.rb`
- E-18: `app/models/users/user.rb`
- E-19: `fat_free_crm.gemspec`
- E-20: `lib/fat_free_crm/version.rb`
- E-21: `Gemfile`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バージョン0.25.0 | E-20 | ○ |
| C-02 | Ruby on Rails 7.x系 | E-19 | ○ |
| C-03 | 画面表示3秒以内 | **根拠なし** | △ |
| C-04 | API応答1秒以内 | **根拠なし** | △ |
| C-05 | オートコンプリート検索limit(10) | E-16 | ○ |
| C-06 | 同時接続数は設定依存 | **根拠なし** | △ |
| C-07 | 開発環境キャッシュ:memory_store | E-02 | ○ |
| C-08 | テスト環境キャッシュ:null_store | E-03 | ○ |
| C-09 | 本番環境キャッシュ設定コメントアウト | E-01 | ○ |
| C-10 | 本番環境perform_caching有効 | E-01 | ○ |
| C-11 | アセット圧縮・ダイジェスト化 | E-01 | ○ |
| C-12 | テスト環境Cache-Control max-age=3600 | E-03 | ○ |
| C-13 | 開発環境Cache-Control max-age=172800 | E-02 | ○ |
| C-14 | 本番環境Action CableはRedis | E-13 | ○ |
| C-15 | PostgreSQL/MySQL/SQLite対応 | E-14, E-21 | ○ |
| C-16 | Active Storageローカル/クラウド対応 | E-12 | ○ |
| C-17 | Devise 4.6+認証 | E-04, E-19 | ○ |
| C-18 | Authlogic SHA512暗号化 | E-04 | ○ |
| C-19 | パスワード長8-128文字 | E-04 | ○ |
| C-20 | パスワードリセット有効期限6時間 | E-04 | ○ |
| C-21 | Remember Me無効化設定 | E-04 | ○ |
| C-22 | メール変更再確認設定 | E-04 | ○ |
| C-23 | CanCanCan認可 | E-17, E-19 | ○ |
| C-24 | ユーザー自身プロファイル管理可能 | E-17 | ○ |
| C-25 | タスク認可ルール | E-17 | ○ |
| C-26 | エンティティ認可ルール | E-17 | ○ |
| C-27 | 管理者全権限 | E-17 | ○ |
| C-28 | CSRF保護with: :exception | E-16 | ○ |
| C-29 | セッションストアCookie Store | E-05 | ○ |
| C-30 | セッションキー名 | E-05 | ○ |
| C-31 | ログフィルタリング設定（application.rb） | E-10 | ○ |
| C-32 | ログフィルタリング設定（initializer） | E-08 | ○ |
| C-33 | CORSヘッダー設定 | E-16 | ○ |
| C-34 | CSPコメントアウト状態 | E-06 | ○ |
| C-35 | Permissions Policyコメントアウト状態 | E-07 | ○ |
| C-36 | ユーザーサインアップ制御設定 | E-11 | ○ |
| C-37 | Hook機構による拡張 | E-16 | ○ |
| C-38 | ActiveSupport Load Hooks | E-16, E-17, E-18 | ○ |
| C-39 | デフォルトロケールen-US | E-11 | ○ |
| C-40 | i18nフォールバック有効（本番） | E-01 | ○ |
| C-41 | PaperTrail 15.1.0使用 | E-18, E-19 | ○ |
| C-42 | User.last_sign_in_at追跡除外 | E-18 | ○ |
| C-43 | Observerパターン使用 | E-10 | ○ |
| C-44 | Ruby 3.1以上要件 | E-19 | ○ |
| C-45 | Rails 7.1.0-7.3.0要件 | E-19 | ○ |
| C-46 | 本番ログレベル:info | E-01 | ○ |
| C-47 | Capistrano使用 | E-15, E-21 | ○ |
| C-48 | 設定優先度（settings→DB） | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- **レスポンスタイム/スループット目標値**：コードベースにSLA/性能目標の明示的な設定ファイルが存在しない
  - 候補：運用設計書 / インフラ設計書 / SLA文書
- **可用性目標値**：稼働率、RTO、RPOに関する設定がコードベースに存在しない
  - 候補：DR（災害復旧）計画書 / SLA文書 / 運用手順書

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - SSL強制設定（`force_ssl`）がコメントアウト状態
- 1: 中リスク - セッションタイムアウト（`timeout_in`）がコメントアウト状態
- 1: 中リスク - アカウントロック機能（`lock_strategy`）がコメントアウト状態
- 1: 中リスク - Content Security Policyが未設定
- 1: 中リスク - Permissions Policyが未設定
- 1: 中リスク - レートリミット機能が未実装
- 0: 低リスク - CORSがワイルドカード（`*`）設定（本番環境では制限推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] レスポンスタイム/スループット目標値を運用要件に基づいて確認・補完する
- [ ] 可用性要件（稼働率、RTO、RPO）をインフラ設計に基づいて確認・補完する
- [ ] SSL強制設定の本番環境での有効化を確認する
- [ ] セッションタイムアウト設定の適切性を確認する
- [ ] アカウントロック機能の有効化要否を確認する
- [ ] CSP/Permissions Policy設定の要否を確認する
- [ ] CORS設定の本番環境での適切性を確認する
- [ ] レートリミット機能の追加要否を確認する
