# API設計書

## 概要

本ドキュメントはApache Flink Monitoring REST APIの設計書です。Flink REST APIは、Flinkクラスタの監視・管理を行うためのHTTPベースのインターフェースを提供します。このAPIを通じて、ジョブの投入・キャンセル、チェックポイント管理、メトリクス取得、クラスタ状態監視などが可能です。

## 共通仕様

### ベースURL

```
http://<jobmanager-host>:<port>/
```

デフォルトポートは `8081` です。

### 認証方式

デフォルトでは認証なし。セキュリティ設定に応じてSSL/TLS、Kerberos認証等を構成可能。

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| Content-Type | ○ | application/json |
| Accept | - | application/json |

### 共通エラーレスポンス

| ステータスコード | 説明 |
| --- | --- |
| 400 | Bad Request - リクエストパラメータ不正 |
| 404 | Not Found - リソース未検出 |
| 500 | Internal Server Error - サーバーエラー |

## API一覧

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| クラスタ | /overview | GET | クラスタ概要を取得 |
| クラスタ | /config | GET | WebUI設定を取得 |
| クラスタ | /cluster | DELETE | クラスタをシャットダウン |
| ジョブマネージャ | /jobmanager/config | GET | クラスタ設定を取得 |
| ジョブマネージャ | /jobmanager/logs | GET | ログファイル一覧を取得 |
| ジョブマネージャ | /jobmanager/log | GET | ログファイルを取得 |
| ジョブマネージャ | /jobmanager/stdout | GET | 標準出力を取得 |
| ジョブマネージャ | /jobmanager/thread-dump | GET | スレッドダンプを取得 |
| ジョブマネージャ | /jobmanager/profiler | GET/POST | プロファイラー操作 |
| ジョブ | /jobs | POST | ジョブを投入 |
| ジョブ | /jobs/overview | GET | ジョブ一覧を取得 |
| ジョブ | /jobs/:jobid | GET | ジョブ詳細を取得 |
| ジョブ | /jobs/:jobid | PATCH | ジョブを終了 |
| ジョブ | /jobs/:jobid/config | GET | ジョブ設定を取得 |
| ジョブ | /jobs/:jobid/exceptions | GET | ジョブ例外を取得 |
| ジョブ | /jobs/:jobid/execution-result | GET | ジョブ実行結果を取得 |
| ジョブ | /jobs/:jobid/plan | GET | ジョブ実行プランを取得 |
| ジョブ | /jobs/:jobid/accumulators | GET | アキュムレータを取得 |
| ジョブ | /jobs/:jobid/metrics | GET | ジョブメトリクスを取得 |
| ジョブ | /jobs/:jobid/stop | POST | セーブポイント付きでジョブを停止 |
| チェックポイント | /jobs/:jobid/checkpoints | GET | チェックポイント統計を取得 |
| チェックポイント | /jobs/:jobid/checkpoints | POST | チェックポイントをトリガー |
| チェックポイント | /jobs/:jobid/checkpoints/config | GET | チェックポイント設定を取得 |
| チェックポイント | /jobs/:jobid/checkpoints/details/:checkpointid | GET | チェックポイント詳細を取得 |
| セーブポイント | /jobs/:jobid/savepoints | POST | セーブポイントをトリガー |
| セーブポイント | /savepoint-disposal | POST | セーブポイントを破棄 |
| タスクマネージャ | /taskmanagers | GET | タスクマネージャ一覧を取得 |
| タスクマネージャ | /taskmanagers/:taskmanagerid | GET | タスクマネージャ詳細を取得 |
| データセット | /datasets | GET | クラスタデータセット一覧を取得 |
| アプリケーション | /applications/overview | GET | アプリケーション一覧を取得 |
| アプリケーション | /applications/:applicationid | GET | アプリケーション詳細を取得 |
| アプリケーション | /applications/:applicationid/cancel | PATCH | アプリケーションをキャンセル |
| リソース要件 | /jobs/:jobid/resource-requirements | GET | リソース要件を取得 |
| リソース要件 | /jobs/:jobid/resource-requirements | PUT | リソース要件を更新 |

## 各APIエンドポイント定義

### クラスタ管理

#### 1. クラスタ概要取得

Flinkクラスタの概要情報を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /overview` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

なし

**クエリパラメータ**

なし

**リクエストボディ**

なし

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "taskmanagers": 2,
  "taskmanagers-blocked": 0,
  "slots-total": 4,
  "slots-available": 2,
  "slots-free-and-blocked": 0,
  "jobs-running": 1,
  "jobs-finished": 0,
  "jobs-cancelled": 0,
  "jobs-failed": 0,
  "flink-version": "2.0-SNAPSHOT",
  "flink-commit": "abc123"
}
```

| フィールド名 | 型 | 説明 |
| --- | --- | --- |
| taskmanagers | integer | 接続されているタスクマネージャ数 |
| taskmanagers-blocked | integer | ブロックされているタスクマネージャ数 |
| slots-total | integer | 総スロット数 |
| slots-available | integer | 利用可能スロット数 |
| slots-free-and-blocked | integer | 空きでブロックされているスロット数 |
| jobs-running | integer | 実行中のジョブ数 |
| jobs-finished | integer | 完了したジョブ数 |
| jobs-cancelled | integer | キャンセルされたジョブ数 |
| jobs-failed | integer | 失敗したジョブ数 |
| flink-version | string | Flinkバージョン |
| flink-commit | string | Gitコミットハッシュ |

---

#### 2. WebUI設定取得

WebUIの設定を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /config` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "refresh-interval": 3000,
  "timezone-name": "UTC",
  "timezone-offset": 0,
  "flink-version": "2.0-SNAPSHOT",
  "flink-revision": "abc123",
  "features": {
    "web-submit": true
  }
}
```

---

#### 3. クラスタシャットダウン

Flinkクラスタをシャットダウンします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `DELETE /cluster` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{}
```

---

### ジョブマネージャ

#### 4. クラスタ設定取得

クラスタの設定情報を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /jobmanager/config` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
[
  {
    "key": "jobmanager.rpc.address",
    "value": "localhost"
  },
  {
    "key": "jobmanager.rpc.port",
    "value": "6123"
  }
]
```

---

#### 5. ログファイル一覧取得

JobManagerのログファイル一覧を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /jobmanager/logs` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "logs": [
    {
      "name": "flink-jobmanager-0.log",
      "size": 12345
    }
  ]
}
```

---

#### 6. スレッドダンプ取得

JobManagerのスレッドダンプを返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /jobmanager/thread-dump` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "threadInfos": [
    {
      "threadName": "main",
      "stringifiedThreadInfo": "..."
    }
  ]
}
```

---

### ジョブ管理

#### 7. ジョブ投入

新しいジョブをクラスタに投入します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /jobs` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ**

Content-Type: `multipart/form-data`

```json
{
  "executionPlanFileName": "job.json",
  "jobJarFileNames": ["job.jar"],
  "jobArtifactFileNames": [
    {
      "entryName": "artifact1",
      "fileName": "artifact1.dat"
    }
  ]
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| executionPlanFileName | string | - | シリアライズされたJobGraphファイル名 |
| jobJarFileNames | array[string] | - | JARファイル名リスト |
| jobArtifactFileNames | array[object] | - | 分散キャッシュファイル |

**レスポンス（成功時）**

ステータスコード: `202 Accepted`

```json
{
  "jobUrl": "/jobs/abc123def456"
}
```

---

#### 8. ジョブ一覧取得

すべてのジョブの概要を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /jobs/overview` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "jobs": [
    {
      "jid": "7eb3c1a9b1e3c1d4e5f67890",
      "name": "MyStreamingJob",
      "state": "RUNNING",
      "start-time": 1640000000000,
      "end-time": -1,
      "duration": 3600000,
      "last-modification": 1640003600000,
      "tasks": {
        "total": 4,
        "created": 0,
        "scheduled": 0,
        "deploying": 0,
        "running": 4,
        "finished": 0,
        "canceling": 0,
        "canceled": 0,
        "failed": 0,
        "reconciling": 0,
        "initializing": 0
      }
    }
  ]
}
```

---

#### 9. ジョブ詳細取得

特定のジョブの詳細情報を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /jobs/:jobid` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobid | string | ○ | ジョブID（32文字の16進数） |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "jid": "7eb3c1a9b1e3c1d4e5f67890",
  "name": "MyStreamingJob",
  "isStoppable": true,
  "state": "RUNNING",
  "job-type": "STREAMING",
  "start-time": 1640000000000,
  "end-time": -1,
  "duration": 3600000,
  "maxParallelism": 128,
  "now": 1640003600000,
  "timestamps": {
    "INITIALIZING": 1640000000000,
    "CREATED": 1640000000100,
    "RUNNING": 1640000000200
  },
  "vertices": [
    {
      "id": "cbc357ccb763df2852fee8c4fc7d55f2",
      "slotSharingGroupId": "...",
      "name": "Source: KafkaSource",
      "maxParallelism": 128,
      "parallelism": 4,
      "status": "RUNNING",
      "start-time": 1640000000300,
      "end-time": -1,
      "duration": 3599700,
      "tasks": {
        "CREATED": 0,
        "SCHEDULED": 0,
        "DEPLOYING": 0,
        "RUNNING": 4,
        "FINISHED": 0,
        "CANCELING": 0,
        "CANCELED": 0,
        "FAILED": 0,
        "RECONCILING": 0,
        "INITIALIZING": 0
      },
      "metrics": {
        "read-bytes": 1024000,
        "read-bytes-complete": true,
        "write-bytes": 512000,
        "write-bytes-complete": true,
        "read-records": 10000,
        "read-records-complete": true,
        "write-records": 5000,
        "write-records-complete": true
      }
    }
  ],
  "status-counts": {
    "CREATED": 0,
    "SCHEDULED": 0,
    "DEPLOYING": 0,
    "RUNNING": 4,
    "FINISHED": 0,
    "CANCELING": 0,
    "CANCELED": 0,
    "FAILED": 0,
    "RECONCILING": 0,
    "INITIALIZING": 0
  },
  "plan": {
    "jid": "7eb3c1a9b1e3c1d4e5f67890",
    "name": "MyStreamingJob",
    "type": "STREAMING",
    "nodes": []
  }
}
```

---

#### 10. ジョブ終了

実行中のジョブを終了（キャンセル）します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PATCH /jobs/:jobid` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobid | string | ○ | ジョブID（32文字の16進数） |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| mode | string | - | cancel | 終了モード（cancel または stop） |

**レスポンス（成功時）**

ステータスコード: `202 Accepted`

```json
{}
```

---

#### 11. セーブポイント付きジョブ停止

セーブポイントを作成してジョブを停止します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /jobs/:jobid/stop` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobid | string | ○ | ジョブID |

**リクエストボディ**

```json
{
  "targetDirectory": "/savepoints",
  "drain": false
}
```

**レスポンス（成功時）**

ステータスコード: `202 Accepted`

```json
{
  "request-id": "trigger-id-123"
}
```

---

### チェックポイント

#### 12. チェックポイント統計取得

ジョブのチェックポイント統計を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /jobs/:jobid/checkpoints` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobid | string | ○ | ジョブID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "counts": {
    "restored": 0,
    "total": 10,
    "in_progress": 0,
    "completed": 10,
    "failed": 0
  },
  "summary": {
    "checkpointed_size": {
      "min": 1024,
      "max": 2048,
      "avg": 1536
    },
    "state_size": {
      "min": 512,
      "max": 1024,
      "avg": 768
    },
    "end_to_end_duration": {
      "min": 100,
      "max": 500,
      "avg": 250
    }
  },
  "latest": {
    "completed": {
      "id": 10,
      "status": "COMPLETED",
      "trigger_timestamp": 1640003600000,
      "latest_ack_timestamp": 1640003600500,
      "checkpointed_size": 2048,
      "state_size": 1024,
      "end_to_end_duration": 500
    },
    "savepoint": null,
    "failed": null,
    "restored": null
  },
  "history": []
}
```

---

#### 13. チェックポイントトリガー

新しいチェックポイントをトリガーします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /jobs/:jobid/checkpoints` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobid | string | ○ | ジョブID |

**リクエストボディ**

```json
{
  "checkpointType": "FULL"
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| checkpointType | string | - | チェックポイントタイプ（FULL, CONFIGURED） |

**レスポンス（成功時）**

ステータスコード: `202 Accepted`

```json
{
  "request-id": "trigger-id-456"
}
```

---

#### 14. チェックポイント設定取得

ジョブのチェックポイント設定を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /jobs/:jobid/checkpoints/config` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobid | string | ○ | ジョブID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "mode": "exactly_once",
  "interval": 60000,
  "timeout": 600000,
  "min_pause": 0,
  "max_concurrent": 1,
  "externalization": {
    "enabled": true,
    "delete_on_cancellation": false
  },
  "state_backend": "rocksdb",
  "unaligned_checkpoints": false
}
```

---

### セーブポイント

#### 15. セーブポイントトリガー

セーブポイントをトリガーし、オプションでジョブをキャンセルします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /jobs/:jobid/savepoints` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobid | string | ○ | ジョブID |

**リクエストボディ**

```json
{
  "target-directory": "/savepoints",
  "cancel-job": false,
  "formatType": "CANONICAL"
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| target-directory | string | - | 保存先ディレクトリ |
| cancel-job | boolean | - | セーブポイント後にジョブをキャンセル |
| formatType | string | - | フォーマットタイプ（CANONICAL, NATIVE） |

**レスポンス（成功時）**

ステータスコード: `202 Accepted`

```json
{
  "request-id": "trigger-id-789"
}
```

---

#### 16. セーブポイント破棄

セーブポイントを破棄します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /savepoint-disposal` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ**

```json
{
  "savepoint-path": "/savepoints/savepoint-abc123"
}
```

**レスポンス（成功時）**

ステータスコード: `202 Accepted`

```json
{
  "request-id": "trigger-id-disposal"
}
```

---

### タスクマネージャ

#### 17. タスクマネージャ一覧取得

すべてのタスクマネージャの概要を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /taskmanagers` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "taskmanagers": [
    {
      "id": "container_123_456",
      "path": "akka.tcp://flink@host:port/user/taskmanager_0",
      "dataPort": 12345,
      "jmxPort": -1,
      "timeSinceLastHeartbeat": 1000,
      "slotsNumber": 4,
      "freeSlots": 2,
      "blockedSlots": 0,
      "totalResource": {
        "cpuCores": 4.0,
        "taskHeapMemory": 1024,
        "taskOffHeapMemory": 0,
        "managedMemory": 512,
        "networkMemory": 128
      },
      "freeResource": {
        "cpuCores": 2.0,
        "taskHeapMemory": 512,
        "taskOffHeapMemory": 0,
        "managedMemory": 256,
        "networkMemory": 64
      },
      "hardware": {
        "cpuCores": 8,
        "physicalMemory": 17179869184,
        "freeMemory": 8589934592,
        "managedMemory": 536870912
      },
      "memoryConfiguration": {}
    }
  ]
}
```

---

#### 18. タスクマネージャ詳細取得

特定のタスクマネージャの詳細情報を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /taskmanagers/:taskmanagerid` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| taskmanagerid | string | ○ | タスクマネージャID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "id": "container_123_456",
  "path": "akka.tcp://flink@host:port/user/taskmanager_0",
  "dataPort": 12345,
  "jmxPort": -1,
  "timeSinceLastHeartbeat": 1000,
  "slotsNumber": 4,
  "freeSlots": 2,
  "blockedSlots": 0,
  "totalResource": {},
  "freeResource": {},
  "hardware": {},
  "memoryConfiguration": {},
  "metrics": {
    "heapUsed": 268435456,
    "heapCommitted": 536870912,
    "heapMax": 1073741824,
    "nonHeapUsed": 67108864,
    "nonHeapCommitted": 134217728,
    "nonHeapMax": -1,
    "directCount": 10,
    "directUsed": 1048576,
    "directMax": 1073741824,
    "mappedCount": 0,
    "mappedUsed": 0,
    "mappedMax": 0,
    "memorySegmentsAvailable": 100,
    "memorySegmentsTotal": 128,
    "garbageCollectors": []
  }
}
```

---

### データセット

#### 19. クラスタデータセット一覧取得

クラスタ内のデータセット一覧を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /datasets` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "dataSets": []
}
```

---

### アプリケーション

#### 20. アプリケーション一覧取得

すべてのアプリケーションの概要を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /applications/overview` |
| 認証 | 不要 |
| 権限 | なし |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "applications": []
}
```

---

#### 21. アプリケーション詳細取得

特定のアプリケーションの詳細情報を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /applications/:applicationid` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| applicationid | string | ○ | アプリケーションID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "applicationId": "app-123",
  "jobs": []
}
```

---

#### 22. アプリケーションキャンセル

アプリケーションをキャンセルします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PATCH /applications/:applicationid/cancel` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| applicationid | string | ○ | アプリケーションID |

**レスポンス（成功時）**

ステータスコード: `202 Accepted`

```json
{}
```

---

### リソース要件

#### 23. リソース要件取得

ジョブのリソース要件を返します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /jobs/:jobid/resource-requirements` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobid | string | ○ | ジョブID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "resourceRequirements": []
}
```

---

#### 24. リソース要件更新

ジョブのリソース要件を更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PUT /jobs/:jobid/resource-requirements` |
| 認証 | 不要 |
| 権限 | なし |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobid | string | ○ | ジョブID |

**リクエストボディ**

```json
{
  "resourceRequirements": [
    {
      "jobVertexId": "vertex-id",
      "parallelism": {
        "lowerBound": 1,
        "upperBound": 10
      }
    }
  ]
}
```

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{}
```

## 備考

- すべてのエンドポイントはNettyベースのREST サーバー（`RestServerEndpoint`）によって提供されます
- 非同期操作（チェックポイント、セーブポイントトリガーなど）は`request-id`を返し、ステータス確認用エンドポイントで進捗を追跡できます
- ジョブID、タスクマネージャIDなどのパスパラメータは32文字の16進数形式です
- メトリクスエンドポイントでは`get`クエリパラメータで取得するメトリクス名を指定できます
- Flink REST APIの公式ドキュメントは [Apache Flink Documentation](https://nightlies.apache.org/flink/flink-docs-master/docs/ops/rest_api/) を参照してください
