# アーキテクチャ設計書

## 概要

本ドキュメントは、Apache Flinkのアプリケーションアーキテクチャについて記述する。Apache Flinkは、オープンソースの分散ストリーム処理フレームワークであり、バッチ処理とストリーム処理の両方を統一的に扱う「ストリーミングファースト」のランタイムを提供する。

## システム全体構成

### アーキテクチャ概要図

詳細な構成図は [アーキテクチャ構成図.md](./アーキテクチャ構成図.md) を参照。

### システム境界と外部連携

| 外部システム | 連携方式 | 用途 |
| --- | --- | --- |
| Apache ZooKeeper | TCP/IP (ZK Client Protocol) | 高可用性サービス（リーダー選出、サービスディスカバリ） |
| YARN | YARN API | クラスタリソース管理・デプロイメント |
| Kubernetes | Kubernetes API | コンテナオーケストレーション・デプロイメント |
| HDFS | Hadoop FileSystem API | 状態バックエンド、チェックポイントストレージ |
| Amazon S3 | S3 API | 状態バックエンド、チェックポイントストレージ |
| Apache Kafka | Kafka Consumer/Producer API | ソース・シンクコネクタ |
| RocksDB | JNI | 状態バックエンド（ローカルストレージ） |
| Prometheus/Datadog/InfluxDB | Push/Pull Metrics API | メトリクス連携 |

## レイヤー構成

### アーキテクチャスタイル

Apache Flinkは**マスターワーカー型の分散アーキテクチャ**と**レイヤードアーキテクチャ**を組み合わせたスタイルを採用している。

- **マスターワーカー型**: JobManager（マスター）とTaskManager（ワーカー）の構成
- **レイヤード**: API層、Runtime層、クラスタ管理層の階層構造
- **プラグインアーキテクチャ**: コネクタ、ステートバックエンド、メトリクスレポーターの差し替え可能性

### レイヤー定義

| レイヤー | 責務 | 主なコンポーネント |
| --- | --- | --- |
| API Layer | ユーザー向けプログラミングモデルの提供 | DataStream API, Table API, SQL API |
| Runtime Layer | 分散実行エンジン、状態管理、チェックポイント | JobMaster, TaskExecutor, CheckpointCoordinator |
| Cluster Management | クラスタリソース管理、デプロイメント | ResourceManager, Dispatcher, YARN/K8s Integration |
| Storage Layer | 状態永続化、チェックポイントストレージ | StateBackend, CheckpointStorage, FileSystem |

### レイヤー間の依存関係ルール

- **API Layer** -> **Runtime Layer**: APIはRuntimeの実行グラフ（JobGraph）に変換される
- **Runtime Layer** -> **Cluster Management**: ランタイムはリソース要求をクラスタ管理層に委譲
- **Runtime Layer** -> **Storage Layer**: 状態永続化とチェックポイントはストレージ層を使用
- **禁止**: Storage LayerからAPI Layerへの直接参照は禁止

## モジュール構成

### ドメイン分割

| ドメイン | 責務 | 関連モジュール |
| --- | --- | --- |
| Core | 基本API、型システム、設定管理 | flink-core, flink-core-api, flink-annotations |
| Runtime | 分散実行エンジン | flink-runtime, flink-rpc |
| Streaming | ストリーム処理API・ランタイム | flink-streaming-java, flink-datastream, flink-datastream-api |
| Table/SQL | 宣言的クエリ処理 | flink-table-*, flink-sql-* |
| Connectors | 外部システム連携 | flink-connectors, flink-formats |
| State | 状態管理・永続化 | flink-state-backends, flink-dstl |
| Cluster | クラスタ連携 | flink-yarn, flink-kubernetes, flink-clients |
| Metrics | メトリクス収集・エクスポート | flink-metrics-* |
| FileSystem | ファイルシステム抽象化 | flink-filesystems, flink-hadoop-fs |

### パッケージ構造

```
flink-master/
├── flink-annotations/           # アノテーション定義
├── flink-architecture-tests/    # アーキテクチャテスト
├── flink-core-api/              # コアAPI（公開インターフェース）
├── flink-core/                  # コア機能（型、設定、ユーティリティ）
├── flink-runtime/               # 分散実行エンジン
│   └── org.apache.flink.runtime/
│       ├── dispatcher/          # ジョブディスパッチャ
│       ├── jobmaster/           # JobMaster（ジョブ単位の管理）
│       ├── taskexecutor/        # TaskExecutor（タスク実行）
│       ├── resourcemanager/     # リソースマネージャ
│       ├── checkpoint/          # チェックポイント管理
│       ├── state/               # 状態管理
│       ├── scheduler/           # スケジューラ
│       ├── highavailability/    # 高可用性サービス
│       └── ...
├── flink-rpc/                   # RPC通信フレームワーク
│   ├── flink-rpc-core/          # RPCコアインターフェース
│   ├── flink-rpc-akka/          # Akkaベース実装
│   └── flink-rpc-akka-loader/   # Akkaローダー
├── flink-streaming-java/        # DataStream API実装
├── flink-datastream/            # DataStreamランタイム
├── flink-datastream-api/        # DataStream公開API
├── flink-table/                 # Table/SQL処理
│   ├── flink-table-api-java/    # Table API (Java)
│   ├── flink-table-planner/     # クエリプランナー
│   ├── flink-sql-parser/        # SQLパーサー
│   └── flink-sql-gateway/       # SQLゲートウェイ
├── flink-connectors/            # コネクタ
├── flink-formats/               # フォーマット（JSON, Avro, Parquet等）
├── flink-state-backends/        # 状態バックエンド
│   ├── flink-statebackend-rocksdb/   # RocksDB実装
│   ├── flink-statebackend-forst/     # ForSt実装
│   └── flink-statebackend-changelog/ # Changelog実装
├── flink-filesystems/           # ファイルシステム
├── flink-metrics/               # メトリクス
├── flink-yarn/                  # YARN連携
├── flink-kubernetes/            # Kubernetes連携
└── flink-clients/               # クライアントライブラリ
```

### コンポーネント依存関係

主要コンポーネント間の依存関係は以下の通り:

1. **Dispatcher** -> **JobManagerRunner** -> **JobMaster**: ジョブのライフサイクル管理
2. **JobMaster** <-> **TaskExecutor**: タスクのデプロイ・実行・監視
3. **ResourceManager** <-> **TaskExecutor**: スロット管理・リソース割り当て
4. **JobMaster** -> **ResourceManager**: リソース要求
5. **CheckpointCoordinator** -> **TaskExecutor**: チェックポイントの調整

## ミドルウェア構成

### データベース

| 種類 | ミドルウェア | バージョン | 用途 |
| --- | --- | --- | --- |
| 組み込みKV | RocksDB | 6.x+ | 状態バックエンド（ローカル状態ストレージ） |
| 組み込みKV | ForSt | - | 状態バックエンド（実験的） |
| 分散協調 | ZooKeeper | 3.7.2 | 高可用性サービス（リーダー選出） |

### キャッシュ

| ミドルウェア | バージョン | 用途 | TTL |
| --- | --- | --- | --- |
| ヒープメモリ | - | タスクローカル状態キャッシュ | ジョブライフサイクル |
| FileCache | - | BLOBキャッシュ | 設定可能 |

### メッセージキュー

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Akka (Pekko) | 1.x | 内部RPC通信 |
| Netty | 4.x | データシャッフル |

### 検索エンジン

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| (該当なし) | - | Flink自体は検索エンジンを内蔵していない |

### その他ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Netty | 4.x | ネットワーク通信（タスク間データ転送） |
| Apache Calcite | - | SQLクエリ最適化・計画生成 |
| Log4j2 | 2.24.3 | ロギング |
| Hadoop FileSystem | 2.10.2+ | 分散ファイルシステムアクセス |

## データフロー

### リクエスト処理の流れ

ジョブ投入からタスク実行までの同期的な流れ:

1. **クライアント**: JobGraphを生成し、Dispatcherに投入
2. **Dispatcher**: ジョブを受け付け、JobManagerRunnerを起動
3. **JobMaster**: JobGraphをExecutionGraphに変換し、スケジューリング
4. **JobMaster -> ResourceManager**: 必要なスロットを要求
5. **ResourceManager -> TaskExecutor**: スロットを割り当て
6. **TaskExecutor**: タスクをデプロイし、実行開始
7. **Task**: ソースからデータを読み取り、処理を開始

### 非同期処理の流れ

チェックポイント処理の非同期フロー:

1. **CheckpointCoordinator**: チェックポイントをトリガー
2. **CheckpointCoordinator -> TaskExecutor**: バリアを送信
3. **Task**: バリアを受信し、状態をスナップショット
4. **Task -> CheckpointCoordinator**: スナップショット完了を報告
5. **CheckpointCoordinator**: 全タスクの完了を確認し、メタデータを永続化
6. **CheckpointCoordinator**: チェックポイント完了を通知

### データ永続化の流れ

状態のチェックポイント永続化:

1. **StateBackend**: 状態データをシリアライズ
2. **CheckpointStateOutputStream**: シリアライズデータをストリームに書き込み
3. **CheckpointStorage**: 永続ストレージ（HDFS/S3等）に保存
4. **CheckpointMetadata**: メタデータを保存（状態ハンドル、チェックポイントID等）

## 横断的関心事

### 認証・認可

| 方式 | 実装箇所 | 対象 |
| --- | --- | --- |
| Kerberos | flink-runtime/security | YARN、HDFS、ZooKeeper連携時の認証 |
| SSL/TLS | flink-runtime/net | RPC通信、Web UI、データ転送の暗号化 |
| Delegation Token | flink-runtime/security | 長時間実行ジョブの認証トークン更新 |

### ロギング・監査

| 種類 | 実装方式 | 保存先 |
| --- | --- | --- |
| アプリケーションログ | Log4j2 | ファイル（TaskManager/JobManagerローカル） |
| 監査ログ | ジョブイベントログ | Flink Web UI、HistoryServer |
| アクセスログ | REST API Handler | ログファイル |

### エラーハンドリング

| エラー種別 | ハンドリング方式 | レスポンス |
| --- | --- | --- |
| タスク失敗 | 自動リスタート（Restart Strategy） | ジョブ継続/失敗 |
| チェックポイント失敗 | リトライまたは中止 | 設定に基づく |
| TaskManager障害 | ブロックリスト登録、タスク再スケジュール | 自動リカバリ |
| JobManager障害 | HAサービスによるフェイルオーバー | リーダー選出後再開 |

### トランザクション管理

| 範囲 | 管理方式 | 分離レベル |
| --- | --- | --- |
| Exactly-once保証 | 2フェーズコミット（TwoPhaseCommitSinkFunction） | シンク出力時 |
| チェックポイント | 分散スナップショット（Chandy-Lamport方式） | イベント時刻ベース |
| 状態アクセス | 単一キーごとのシリアライズドアクセス | キースコープ |

## 設計原則・コーディング規約

### 適用している設計原則

| 原則 | 適用箇所 | 実装例 |
| --- | --- | --- |
| 依存性逆転の原則（DIP） | StateBackend, CheckpointStorage | インターフェースによる抽象化、実装の差し替え |
| 単一責任の原則（SRP） | JobMaster, TaskExecutor, ResourceManager | 各コンポーネントが明確な責務を持つ |
| インターフェース分離（ISP） | RpcGateway, RpcEndpoint | 必要なメソッドのみを公開するインターフェース |
| プラグインパターン | Connectors, Metrics, FileSystem | SPI（Service Provider Interface）による拡張 |
| Actor Model | RPC通信 | Akka/Pekkoベースの非同期メッセージング |

### コーディング規約

- **言語**: Java 11以上（ターゲット: Java 17）、Scala 2.12
- **コードスタイル**: Checkstyle、Spotlessによる自動フォーマット
- **命名規則**: CamelCase（クラス）、camelCase（メソッド、変数）
- **ドキュメント**: JavadocによるパブリックAPI文書化
- **テスト**: JUnit 5、Mockito、TestContainersによる単体・統合テスト
- **アーキテクチャテスト**: ArchUnitによるレイヤー依存性検証

## 備考

- 本設計書はApache Flink 2.3-SNAPSHOTバージョンを対象としている
- 外部コネクタの多くは個別リポジトリ（flink-connector-*）に移行されている
- Python APIはpyflinkモジュールで提供され、Java APIと相互運用可能
- Flinkは継続的に進化しており、アーキテクチャの詳細は変更される可能性がある
