---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **本番環境でのリソーススペック推奨値**：具体的な本番環境要件の根拠が不足
  2. **バックアップ保持期間の具体値**：設定可能であるが具体的な推奨値の根拠なし
  3. **ZooKeeperクォーラム構成の詳細**：コメントアウトされた設定のみで実運用例なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-dist/src/main/resources/config.yaml` - Flink設定ファイル
- E-02: `flink-end-to-end-tests/test-scripts/docker-hadoop-secure-cluster/docker-compose.yml` - Hadoopセキュアクラスタ構成
- E-03: `flink-end-to-end-tests/test-scripts/container-scripts/docker-compose.test.yml` - Flink Job Cluster Docker構成
- E-04: `flink-end-to-end-tests/test-scripts/container-scripts/docker-compose.nat.yml` - NAT構成
- E-05: `flink-end-to-end-tests/test-scripts/docker-hadoop-secure-cluster/kdc/Dockerfile` - KDC Dockerfile
- E-06: `flink-end-to-end-tests/test-scripts/docker-hadoop-secure-cluster/hadoop/Dockerfile` - Hadoop Dockerfile
- E-07: `flink-end-to-end-tests/test-scripts/container-scripts/job-cluster-service.yaml` - Kubernetes Service定義
- E-08: `flink-end-to-end-tests/test-scripts/container-scripts/kubernetes-pod-template.yaml` - Kubernetes Pod Template
- E-09: `flink-kubernetes/src/test/resources/testing-pod-template.yaml` - 詳細Pod Template
- E-10: `flink-kubernetes/pom.xml` - Kubernetes Client依存関係
- E-11: `flink-yarn/pom.xml` - YARN依存関係
- E-12: `flink-filesystems/pom.xml` - ファイルシステムモジュール一覧
- E-13: `flink-metrics/flink-metrics-otel/src/test/resources/otel-config.yaml` - OpenTelemetry設定
- E-14: `pom.xml` - プロジェクト全体構成
- E-15: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Apache Flinkはバージョン2.3-SNAPSHOT | E-10, E-11, E-14 | ○ |
| C-02 | JobManagerのデフォルトメモリは1600MB | E-01 | ○ |
| C-03 | TaskManagerのデフォルトメモリは1728MB | E-01 | ○ |
| C-04 | JobManager RPCポートは6123 | E-01, E-07 | ○ |
| C-05 | JobManager Blobポートは6124 | E-07 | ○ |
| C-06 | REST API/Web UIポートは8081 | E-01, E-03, E-07 | ○ |
| C-07 | TaskManagerスロット数のデフォルトは1 | E-01 | ○ |
| C-08 | デフォルト並列度は1 | E-01, E-03 | ○ |
| C-09 | フェイルオーバー戦略はregion | E-01 | ○ |
| C-10 | Kubernetes Clientバージョンは7.3.1 | E-10 | ○ |
| C-11 | Nettyバージョンは4.1.108.Final | E-10 | ○ |
| C-12 | Docker Composeでスケーリング可能 | E-03 | ○ |
| C-13 | Hadoopクラスタ構成（master/worker1/worker2） | E-02 | ○ |
| C-14 | KDCサーバーはDebian bullseyeベース | E-05 | ○ |
| C-15 | HadoopコンテナはEclipse Temurin JDK 8ベース | E-06 | ○ |
| C-16 | KerberosデフォルトRealmはEXAMPLE.COM | E-02, E-06 | ○ |
| C-17 | HDFSポート9000, 50010, 50020, 50075 | E-06 | ○ |
| C-18 | YARNポート8030-8033, 8040, 8042, 8088 | E-06 | ○ |
| C-19 | Kerberos KDCポート88, 749 | E-05 | ○ |
| C-20 | NAT環境でextra_hostsによるホスト名解決 | E-04 | ○ |
| C-21 | Kubernetes ServiceタイプはClusterIP | E-07 | ○ |
| C-22 | Pod ephemeral-storageは256Mi | E-08, E-09 | ○ |
| C-23 | InitContainerでJAR取得可能 | E-09 | ○ |
| C-24 | サイドカーコンテナでログ収集可能 | E-09 | ○ |
| C-25 | ZooKeeperによるHA構成サポート | E-01 | ○ |
| C-26 | 状態バックエンドはhashmap/rocksdb | E-01 | ○ |
| C-27 | S3ファイルシステムサポート（hadoop/presto） | E-12 | ○ |
| C-28 | Azure Blob Storageサポート | E-12 | ○ |
| C-29 | Google Cloud Storageサポート | E-12 | ○ |
| C-30 | Alibaba OSSサポート | E-12 | ○ |
| C-31 | OpenTelemetryサポート（gRPC:4317, HTTP:4318） | E-13 | ○ |
| C-32 | YARN依存関係（hadoop-yarn-common, hadoop-yarn-client） | E-11 | ○ |
| C-33 | Java 11, 17, 21サポート | E-15 | ○ |
| C-34 | Java 17がデフォルト推奨 | E-15 | ○ |
| C-35 | HistoryServerポートは8082 | E-01 | ○ |
| C-36 | Prometheus/Datadog/InfluxDB/Graphiteメトリクス対応 | E-14 | ○ |
| C-37 | AWS SDK依存バージョン1.12.779 | E-11 | ○ |
| C-38 | Hadoop shaded version 3.3.4 | E-12 | ○ |
| C-39 | 本番環境でのJobManagerスペック推奨値 | **根拠なし** | △ |
| C-40 | 本番環境でのTaskManagerスペック推奨値 | **根拠なし** | △ |
| C-41 | バックアップ保持期間の具体的推奨値 | **根拠なし** | △ |
| C-42 | ZooKeeperクォーラムの具体的構成例 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **本番環境スペック推奨値**
  - 理由：設定ファイルにはデフォルト値のみ記載、本番環境固有の推奨値は存在しない
  - 候補：公式ドキュメント / 運用実績 / ベンチマーク結果
- **バックアップ保持期間**
  - 理由：設定項目は存在するが具体的な推奨値の記載なし
  - 候補：運用ポリシー / コンプライアンス要件
- **ZooKeeperクォーラム構成**
  - 理由：config.yamlではコメントアウトされた例のみ
  - 候補：本番環境設定 / 高可用性構成ガイド

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ポート番号、デフォルト設定値（設定ファイルから直接確認可能）
- **1: 中リスク** - Docker/Kubernetes構成（テスト用構成を基に記載）
- **2: 高リスク** - 本番環境スペック推奨値（根拠なし、運用要件に依存）

## 6) レビュアーチェックリスト（最小）
- [ ] JobManager/TaskManagerのメモリ設定値が実際の設定ファイルと一致するか確認
- [ ] ポート番号がdocker-compose.yml、Kubernetes Service定義と一致するか確認
- [ ] Kubernetes Client、Nettyのバージョンがpom.xmlと一致するか確認
- [ ] ファイルシステムプラグインの一覧がflink-filesystems/pom.xmlのモジュール構成と一致するか確認
- [ ] 本番環境でのリソーススペックは組織のベンチマーク結果に基づき調整が必要
- [ ] ZooKeeper HA構成は実際の本番環境設定を別途確認
- [ ] バックアップ保持期間はコンプライアンス要件に基づき決定が必要
