# インフラ設計書

## 概要

本ドキュメントは、Apache Flink（バージョン2.3-SNAPSHOT）の本番環境におけるインフラストラクチャ設計を記載する。Apache Flinkは分散ストリーム処理およびバッチ処理フレームワークであり、複数のデプロイメント形態（Standalone、YARN、Kubernetes）をサポートする。

## システム構成

### 全体構成

Apache Flinkはマスター/ワーカー型のアーキテクチャを採用し、以下のコンポーネントで構成される：

1. **JobManager（マスター）**: ジョブのスケジューリング、チェックポイント管理、障害復旧を担当
2. **TaskManager（ワーカー）**: 実際のデータ処理タスクを実行
3. **クライアント**: ジョブの投入とモニタリングを行う

デプロイメント形態により、リソース管理とコンテナオーケストレーションが異なる。

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| JobManager | ジョブスケジューリング、RPCサーバー、REST API提供 | メモリ: 1600MB（process.size）、CPU: 1core以上 | 1台（HA構成時は複数） |
| TaskManager | データストリーム処理タスクの実行 | メモリ: 1728MB（process.size）、スロット数: 1（設定可能） | スケーラブル（デフォルト並列度に応じて） |
| Hadoop Master | HDFS NameNode、YARN ResourceManager | Java 8+、Hadoop 3.x | 1台 |
| Hadoop Worker | HDFS DataNode、YARN NodeManager | Java 8+、Hadoop 3.x | 2台以上 |
| KDC (Kerberos) | 認証サーバー（セキュアクラスタ用） | Debian bullseye、krb5-kdc | 1台 |

### ネットワーク構成

#### ポート構成

| サービス | ポート | 用途 |
| --- | --- | --- |
| JobManager RPC | 6123 | タスクマネージャとの通信 |
| JobManager Blob Server | 6124 | JAR/データ転送 |
| REST API / Web UI | 8081 | WebダッシュボードとREST API |
| TaskManager RPC | 動的割当 | ジョブマネージャとの通信 |
| TaskManager Data | 動的割当 | タスク間データ交換 |
| HDFS NameNode | 9000, 8020 | HDFSメタデータ |
| HDFS DataNode | 50010, 50020, 50075 | HDFSデータ転送 |
| YARN ResourceManager | 8030-8033, 8088 | リソース管理 |
| YARN NodeManager | 8040, 8042 | コンテナ管理 |
| Kerberos KDC | 88, 749 | 認証 |
| ZooKeeper | 2181 | 高可用性用 |

#### ネットワークトポロジー

- **Docker環境**: カスタムブリッジネットワーク（docker-hadoop-cluster-network）
- **NAT環境**: ホストIPを経由したポートマッピングによるコンテナ間通信
- **Kubernetes環境**: ClusterIP ServiceによるPod間通信

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Java (Eclipse Temurin) | 8, 11, 17, 21 | ランタイム環境 |
| Apache Hadoop | 3.x (flink.hadoop.version) | HDFS/YARN連携 |
| Apache ZooKeeper | 3.x | 高可用性構成用リーダー選出 |
| Kubernetes Client (fabric8) | 7.3.1 | Kubernetes API連携 |
| OkHttp3 | (fabric8依存) | Kubernetes HTTP通信 |
| Netty | 4.1.108.Final | ネットワーク通信 |
| OpenTelemetry | - | メトリクス・トレース収集 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Amazon S3 | オブジェクトストレージ（チェックポイント、状態保存） | flink-s3-fs-hadoop / flink-s3-fs-presto |
| Azure Blob Storage | オブジェクトストレージ | flink-azure-fs-hadoop |
| Google Cloud Storage | オブジェクトストレージ | flink-gs-fs-hadoop |
| Alibaba OSS | オブジェクトストレージ | flink-oss-fs-hadoop |
| HDFS | 分散ファイルシステム | flink-hadoop-fs |
| Apache Kafka | メッセージング（外部コネクタ） | flink-connector-kafka |
| Apache ZooKeeper | 高可用性（HA）用リーダー選出 | TCP接続（quorum指定） |
| Prometheus | メトリクス収集 | flink-metrics-prometheus |
| Datadog | メトリクス収集 | flink-metrics-datadog |
| InfluxDB | メトリクス収集 | flink-metrics-influxdb |
| Graphite | メトリクス収集 | flink-metrics-graphite |
| OpenTelemetry Collector | メトリクス/トレース収集 | OTLP gRPC (4317) / HTTP (4318) |

## スケーリング設計

### 水平スケーリング

1. **TaskManagerのスケールアウト**
   - Docker Compose: `scale`パラメータによる動的スケーリング（DEFAULT_PARALLELISM変数）
   - Kubernetes: ReplicaSet/Deploymentによるスケーリング
   - YARN: コンテナ数の動的調整

2. **並列度設定**
   - デフォルト並列度: 1（`parallelism.default`）
   - ジョブ単位での並列度指定が可能

3. **スロット管理**
   - TaskManager毎のスロット数: 1（`taskmanager.numberOfTaskSlots`）
   - スロット共有によるリソース効率化

### 垂直スケーリング

- JobManagerメモリ: `jobmanager.memory.process.size`（デフォルト: 1600MB）
- TaskManagerメモリ: `taskmanager.memory.process.size`（デフォルト: 1728MB）
- Kubernetes Pod Template: ephemeral-storage 256Mi設定

## 可用性設計

### 高可用性（HA）構成

1. **ZooKeeper連携**
   - リーダー選出: ZooKeeperによるJobManagerのリーダー選出
   - メタデータ保存: HDFS/S3等の永続ストレージ（`high-availability.storageDir`）
   - クォーラム構成: `high-availability.zookeeper.quorum`

2. **フェイルオーバー戦略**
   - `jobmanager.execution.failover-strategy: region`
   - 影響を受けたタスクのみ再起動

3. **チェックポイント/セーブポイント**
   - 定期チェックポイント: `execution.checkpointing.interval`
   - 外部チェックポイント保持: `externalized-checkpoint-retention`
   - セーブポイントディレクトリ: `execution.checkpointing.savepoint-dir`

### 障害復旧

- 状態バックエンド: hashmap / rocksdb
- インクリメンタルチェックポイント対応（RocksDB）
- Exactly-once処理保証

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| チェックポイント | 分散ファイルシステム（HDFS/S3）への自動保存 | 設定可能（`execution.checkpointing.interval`） | 設定可能（`execution.checkpointing.tolerable-failed-checkpoints`） |
| セーブポイント | 手動または自動トリガー | 運用要件に依存 | 永続 |
| ジョブアーカイブ | HistoryServerへの自動転送 | ジョブ完了時 | 設定可能 |
| HAメタデータ | ZooKeeper + 永続ストレージ | リアルタイム | クラスタライフタイム |

## 監視設計

### メトリクス収集

1. **JMXエクスポート**
   - flink-metrics-jmx

2. **外部監視システム連携**
   - Prometheus: flink-metrics-prometheus
   - Datadog: flink-metrics-datadog
   - InfluxDB: flink-metrics-influxdb
   - Graphite: flink-metrics-graphite
   - StatsD: flink-metrics-statsd
   - SLF4J: flink-metrics-slf4j

3. **OpenTelemetry連携**
   - メトリクス、トレース、ログの統合収集
   - OTLPプロトコル（gRPC: 4317、HTTP: 4318）
   - ヘルスチェック: zpages（55679）

### Web UI監視

- REST API / Web UI: ポート8081
- ジョブステータス、タスク詳細、メトリクス表示
- HistoryServer: ポート8082（完了ジョブの履歴表示）

### ログ管理

- Logback設定: `logback.xml`, `logback-console.xml`
- ログディレクトリ: `$HADOOP_LOG_DIR`（Hadoop環境）
- Kubernetesサイドカーコンテナによるログ収集オプション

## セキュリティ設計

### Kerberos認証

- KDC構成: Debian bullseye + krb5-kdc/krb5-admin-server
- Realm: EXAMPLE.COM（設定可能）
- Keytab管理: `/etc/security/keytabs`
- JAASコンテキスト: Client, KafkaClient

### SSL/TLS

- Hadoop SSL設定: `ssl-server.xml`, `ssl-client.xml`
- キーストア: `$HADOOP_HOME/lib/keystore.jks`

### ZooKeeper ACL

- `zookeeper.client.acl`: open / creator

## デプロイメント形態

### 1. Standalone Cluster

- 独立したJobManager/TaskManagerプロセス
- 設定ファイルベースの構成

### 2. Docker Compose

- **テスト用構成**: `docker-compose.test.yml`
  - job-cluster: JobManager + standalone-job
  - taskmanager: スケーラブルなTaskManager

- **NAT構成**: `docker-compose.nat.yml`
  - 外部ホスト経由のポートマッピング
  - extra_hostsによるホスト名解決

- **Hadoopクラスタ構成**: `docker-compose.yml`
  - kdc: Kerberos認証サーバー
  - master: Hadoop Master (NameNode/ResourceManager)
  - worker1/worker2: Hadoop Worker (DataNode/NodeManager)

### 3. Kubernetes

- **Service定義**: `job-cluster-service.yaml`
  - ClusterIP Service
  - RPC(6123), Blob(6124), UI(8081)ポート公開

- **Pod Template**: `kubernetes-pod-template.yaml`
  - メインコンテナ: flink-main-container
  - InitContainer: アーティファクト取得
  - サイドカー: ログ収集
  - ボリューム: hostPath, emptyDir

### 4. YARN

- YARN ApplicationMaster経由でのコンテナ管理
- Hadoop依存: hadoop-yarn-common, hadoop-yarn-client

## 備考

- 本ドキュメントはApache Flink 2.3-SNAPSHOTのソースコードおよび設定ファイルに基づいて作成
- 実際の本番環境では、セキュリティ要件やスケール要件に応じた追加設定が必要
- 外部コネクタ（Kafka、Elasticsearch等）は別リポジトリに分離されている
- Java 17がデフォルトの推奨バージョンであり、Java 11/21もサポート
