---
generated_at: 2026-02-02 12:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **監査ログ機能の詳細**：専用監査ログの有無についてコードベース全体での確認が必要
  2. **CSRF対策**：RESTエンドポイントのCSRF対策の実装詳細の確認が必要
  3. **保存データ暗号化**：Flink自体が保存データ暗号化を提供しない旨の公式確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-core/src/main/java/org/apache/flink/configuration/SecurityOptions.java`
- E-02: `flink-runtime/src/main/java/org/apache/flink/runtime/security/SecurityUtils.java`
- E-03: `flink-runtime/src/main/java/org/apache/flink/runtime/security/SecurityConfiguration.java`
- E-04: `flink-runtime/src/main/java/org/apache/flink/runtime/security/modules/HadoopModule.java`
- E-05: `flink-runtime/src/main/java/org/apache/flink/runtime/security/modules/JaasModule.java`
- E-06: `flink-runtime/src/main/java/org/apache/flink/runtime/security/modules/ZooKeeperModule.java`
- E-07: `flink-runtime/src/main/java/org/apache/flink/runtime/security/contexts/HadoopSecurityContext.java`
- E-08: `flink-runtime/src/main/java/org/apache/flink/runtime/net/SSLUtils.java`
- E-09: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/CustomSSLEngineProvider.java`
- E-10: `flink-runtime/src/main/java/org/apache/flink/runtime/security/token/DelegationTokenManager.java`
- E-11: `flink-runtime/src/main/java/org/apache/flink/runtime/rest/handler/legacy/files/StaticFileServerHandler.java`
- E-12: `flink-core/src/main/java/org/apache/flink/core/security/FlinkSecurityManager.java`
- E-13: `docs/content/docs/deployment/security/security-kerberos.md`
- E-14: `docs/content/docs/deployment/security/security-ssl.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FlinkはKerberos認証を主要な認証メカニズムとして採用 | E-01, E-03, E-04, E-13 | ○ |
| C-02 | HadoopModule、JaasModule、ZooKeeperModuleの3つのセキュリティモジュールが存在 | E-02, E-04, E-05, E-06 | ○ |
| C-03 | Kerberos認証設定オプション（principal、keytab等） | E-01 (SecurityOptions.java L81-140) | ○ |
| C-04 | 認証優先順位（keytab > credential cache > OS account） | E-04, E-13 | ○ |
| C-05 | TGT更新期間のデフォルトは1分 | E-01 (KERBEROS_RELOGIN_PERIOD) | ○ |
| C-06 | HadoopSecurityContextでUserGroupInformation.doAs()を使用 | E-07 (L40-42) | ○ |
| C-07 | StaticFileServerHandlerでパストラバーサル対策を実装 | E-11 (checkFileValidity method L368-393) | ○ |
| C-08 | 内部通信SSL設定（security.ssl.internal.enabled） | E-01 (L229-236), E-08 | ○ |
| C-09 | REST SSL設定（security.ssl.rest.enabled） | E-01 (L240-245), E-08 | ○ |
| C-10 | デフォルトSSLプロトコルはTLSv1.2 | E-01 (L489-495) | ○ |
| C-11 | デフォルト暗号スイートはTLS_RSA_WITH_AES_128_CBC_SHA | E-01 (L503-515) | ○ |
| C-12 | SSLプロバイダーはJDKまたはOpenSSLを選択可能 | E-01 (L527-566), E-08 (getSSLProvider) | ○ |
| C-13 | 内部通信は相互認証（mTLS）を使用 | E-08 (L361, ClientAuth.REQUIRE), E-14 | ○ |
| C-14 | 証明書フィンガープリントによる検証が可能 | E-01 (L385-392), E-08 (L248-258), E-09 | ○ |
| C-15 | 委任トークン管理機能（DelegationTokenManager） | E-10 | ○ |
| C-16 | 委任トークン設定オプション（enabled、renewal等） | E-01 (L146-184) | ○ |
| C-17 | FlinkSecurityManagerでSystem.exit()を監視可能 | E-12 | ○ |
| C-18 | System.exit監視のモード（DISABLED、LOG、THROW） | E-12 (L156-174) | ○ |
| C-19 | ZooKeeper SASL認証の設定が可能 | E-01 (L212-221), E-06 | ○ |
| C-20 | SSLセッションキャッシュサイズとタイムアウトの設定が可能 | E-01 (L571-597) | ○ |
| C-21 | ホスト名検証オプション（security.ssl.verify-hostname） | E-01 (L518-524), E-08 (L464-470) | ○ |
| C-22 | REST APIは相互認証を設定可能（authentication-enabled） | E-01 (L248-254), E-08 (L139-141) | ○ |
| C-23 | Hadoopプロキシユーザーは委任トークン無効時のみサポート | E-04 (L78-88) | ○ |
| C-24 | セキュリティコンテキストファクトリはSPI経由でロード | E-01 (L50-61), E-02 | ○ |
| C-25 | keytabファイルの存在と読み取り可能性を検証 | E-03 (L157-166) | ○ |
| C-26 | 専用の監査ログ機能は実装されていない | **根拠なし** | △ |
| C-27 | FlinkはCSRF対策としてステートレスAPI設計を採用 | **根拠不足** | △ |
| C-28 | Flinkは保存データの暗号化を提供していない | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- **監査ログ機能（C-26）**: コードベース全体で「AuditLog」「audit」関連のクラス・機能を検索した結果、専用の監査ログ機能は見つからなかったが、「存在しない」ことの証明は困難
  - 候補：運用ドキュメント / 公式FAQ / セキュリティガイドライン

- **CSRF対策（C-27）**: RESTエンドポイントがステートレスであることは設計から推測されるが、明示的なCSRF対策コード（トークン検証等）は確認できていない
  - 候補：REST API実装 / セキュリティテストコード / 公式ドキュメント

- **保存データ暗号化（C-28）**: Flinkが保存データ暗号化を提供しないことは公式ドキュメントで明記されていない可能性
  - 候補：公式ドキュメント / State Backend実装 / データ保護に関するFAQ

## 5) リスクフラグ（レビュー観点）

- **リスク 1（中）**: 監査ログ機能の不在 - コンプライアンス要件によっては問題となる可能性
- **リスク 1（中）**: CSRF対策の明示的な確認不足 - RESTエンドポイントのセキュリティ評価に影響
- **リスク 0（低）**: 保存データ暗号化 - ファイルシステム/ストレージレベルでの対応で代替可能

## 6) レビュアーチェックリスト（最小）

- [ ] Kerberos認証設定オプションの完全性を確認（C-03）
- [ ] SSL/TLS設定のデフォルト値が本番環境に適切か確認（C-10, C-11）
- [ ] パストラバーサル対策の実装が十分か確認（C-07）
- [ ] 監査ログ要件がある場合、外部ソリューションとの連携方法を確認（C-26）
- [ ] REST APIのCSRF対策が組織のセキュリティポリシーに適合するか確認（C-27）
- [ ] 機密データを扱う場合、ストレージレベルの暗号化が設定されているか確認（C-28）
- [ ] 委任トークンの更新間隔が運用要件に適合するか確認（C-16）
- [ ] 証明書管理プロセス（発行、更新、失効）が定義されているか確認（C-14）
