# セキュリティ設計書

## 概要

本ドキュメントは、Apache Flinkプロジェクトにおけるセキュリティ設計を記述します。Flinkは分散ストリーム処理プラットフォームであり、Kerberos認証、SSL/TLS暗号化、委任トークン管理など、エンタープライズ環境で必要とされる包括的なセキュリティ機能を提供します。

## 認証設計

### 認証方式

Flinkは、Hadoop/Kerberos認証を主要な認証メカニズムとして採用しています。認証は以下のセキュリティモジュールにより実装されています。

#### セキュリティモジュールアーキテクチャ

| モジュール | 実装クラス | 説明 |
| --- | --- | --- |
| Hadoopモジュール | `HadoopModuleFactory` | Hadoop UserGroupInformation (UGI)を使用したKerberos認証 |
| JAASモジュール | `JaasModuleFactory` | 動的JAAS構成の管理（ZooKeeper、Kafka連携用） |
| ZooKeeperモジュール | `ZookeeperModuleFactory` | ZooKeeper SASL認証の構成 |

#### Kerberos認証

Kerberos認証の設定オプション:

| 設定項目 | 設定キー | 説明 |
| --- | --- | --- |
| プリンシパル | `security.kerberos.login.principal` | Keytabに関連付けられたKerberosプリンシパル名 |
| Keytab | `security.kerberos.login.keytab` | ユーザー資格情報を含むKeytabファイルへの絶対パス |
| チケットキャッシュ使用 | `security.kerberos.login.use-ticket-cache` | Kerberosチケットキャッシュからの読み取りを有効化（デフォルト: true） |
| ログインコンテキスト | `security.kerberos.login.contexts` | Kerberos資格情報を提供するログインコンテキストのリスト |
| TGT再ログイン期間 | `security.kerberos.relogin.period` | TGT更新の時間間隔（デフォルト: 1分） |

認証優先順位:
1. `hadoop.security.authentication`が`kerberos`に設定されている場合:
   - keytabとprincipalが設定されている場合: keytabログインを実行
   - `use-ticket-cache`が設定されている場合: 資格情報キャッシュログインを実行
2. その他の場合: OSアカウントのユーザーIDを使用

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| TGT更新期間 | 1分（デフォルト） | `security.kerberos.relogin.period`で設定可能 |
| セッション固定化対策 | Kerberosチケット再発行 | keytab使用時は自動更新、クレデンシャルキャッシュ使用時はユーザー責任 |
| SSLセッションキャッシュサイズ | システムデフォルト | `security.ssl.internal.session-cache-size`で設定可能 |
| SSLセッションタイムアウト | システムデフォルト | `security.ssl.internal.session-timeout`で設定可能 |

## 認可設計

### 権限体系

Flinkは、Hadoop UserGroupInformation (UGI)を介したユーザー認証に基づく権限管理を実装しています。

| ロール | 権限 | 説明 |
| --- | --- | --- |
| 認証済みユーザー | ジョブ実行、リソースアクセス | Kerberos認証を通過したユーザー |
| Hadoopプロキシユーザー | 制限付き実行 | 委任トークン取得が無効の場合のみサポート |

### アクセス制御

Flinkのアクセス制御は以下の方式で実装されています:

1. **セキュリティコンテキスト**: `SecurityContext`インターフェースを通じて、認証されたコンテキスト内でのみ操作を実行
2. **HadoopSecurityContext**: `UserGroupInformation.doAs()`を使用し、適切な資格情報でCallableを実行
3. **ファイルアクセス制御**: 静的ファイルサーバーにおいてパストラバーサル攻撃を防止（`StaticFileServerHandler.checkFileValidity()`）

```
ファイルアクセス検証:
1. ルートディレクトリ外へのアクセス試行を検出・拒否
2. 隠しファイルへのアクセスを拒否
3. ディレクトリトラバーサルを防止
```

## 通信セキュリティ

Flinkは内部通信と外部通信で異なるSSL/TLS構成をサポートしています。

| 項目 | 対策 |
| --- | --- |
| 内部SSL | `security.ssl.internal.enabled`で有効化。RPC、データ転送、BLOBサービス間の相互認証（mTLS） |
| REST SSL | `security.ssl.rest.enabled`で有効化。外部RESTエンドポイント向け |
| プロトコル | TLSv1.2（デフォルト）、`security.ssl.protocol`で設定可能 |
| 暗号スイート | `TLS_RSA_WITH_AES_128_CBC_SHA`（デフォルト）、推奨: `TLS_DHE_RSA_WITH_AES_128_GCM_SHA256`等 |
| ホスト名検証 | `security.ssl.verify-hostname`で設定（デフォルト: 無効） |
| SSLプロバイダー | JDK（デフォルト）またはOpenSSL |

### 内部通信（相互認証）

内部通信は以下を含みます:
- 制御メッセージ: JobManager / TaskManager / Dispatcher / ResourceManager間のRPC
- データプレーン: シャッフル、ブロードキャスト、再分配時のTaskManager間接続
- BLOBサービス: ライブラリおよびアーティファクトの配布

設定例:
```yaml
security.ssl.internal.enabled: true
security.ssl.internal.keystore: /path/to/internal.keystore
security.ssl.internal.truststore: /path/to/internal.truststore
security.ssl.internal.keystore-password: <password>
security.ssl.internal.truststore-password: <password>
security.ssl.internal.key-password: <password>
```

### 外部通信（REST API）

REST APIは以下の接続をサポート:
- WebダッシュボードUI
- CLI操作（ジョブ送信、管理）
- Dispatcherとの通信

設定例:
```yaml
security.ssl.rest.enabled: true
security.ssl.rest.keystore: /path/to/rest.keystore
security.ssl.rest.truststore: /path/to/rest.truststore
security.ssl.rest.authentication-enabled: false
```

## データセキュリティ

### 暗号化

| 対象 | 暗号化方式 |
| --- | --- |
| 通信（内部） | TLS 1.2（mTLS）、RSA 4096ビット鍵推奨 |
| 通信（REST） | TLS 1.2、自己署名証明書またはCA署名証明書 |
| 保存データ | Flink自体は保存データの暗号化を提供せず、ファイルシステム/ストレージレベルで対応 |

### 機密情報管理

Flinkにおける機密情報の管理:

| 機密情報 | 保護方式 |
| --- | --- |
| Keytabファイル | ファイルシステム権限で保護、`security.kerberos.login.keytab`で参照 |
| キーストアパスワード | 設定ファイルに格納、環境に応じた保護が必要 |
| 委任トークン | `DelegationTokenManager`で管理、定期的に更新 |
| 証明書フィンガープリント | `security.ssl.internal.cert.fingerprint`で設定、SHA1で検証 |

#### 委任トークン管理

| 設定項目 | 設定キー | デフォルト値 |
| --- | --- | --- |
| トークン有効化 | `security.delegation.tokens.enabled` | true |
| 更新リトライバックオフ | `security.delegation.tokens.renewal.retry.backoff` | 1時間 |
| 更新時間比率 | `security.delegation.tokens.renewal.time-ratio` | 0.75 |

## 入出力対策

| 脅威 | 対策 |
| --- | --- |
| XSS | REST APIはJSONレスポンスを返却、静的ファイルはContent-Typeヘッダーを適切に設定 |
| SQLインジェクション | 該当なし（FlinkはSQLクエリを直接DBに発行しない） |
| CSRF | RESTエンドポイントはステートレスAPI設計、セッションベースではない |
| パストラバーサル | `StaticFileServerHandler.checkFileValidity()`でルートディレクトリ外アクセスを検証・拒否 |
| ディレクトリリスティング | 隠しファイル・ディレクトリへのアクセスを拒否 |

### 入力検証

静的ファイルサーバーでの検証ロジック:
1. 正規化されたパスがルートディレクトリ配下であることを確認
2. ファイルの存在確認
3. 隠しファイルへのアクセス拒否
4. ディレクトリへの直接アクセス拒否

## 監査ログ

Flinkは標準的なSLF4Jロギングフレームワークを使用していますが、専用の監査ログ機能は実装されていません。

| ログ種別 | 記録内容 | 保持期間 |
| --- | --- | --- |
| セキュリティログ | Kerberos認証イベント、TGT更新、セキュリティモジュールのインストール/アンインストール | ログ設定による |
| アクセスログ | REST APIリクエスト（エラー含む） | ログ設定による |
| System Exitモニタリング | ユーザーコードからのSystem.exit()呼び出しの検出と記録 | ログ設定による |

### FlinkSecurityManager

`FlinkSecurityManager`はJavaセキュリティマネージャーを拡張し、以下の機能を提供:

| モード | 設定値 | 動作 |
| --- | --- | --- |
| DISABLED | デフォルト | System.exit()を許可 |
| LOG | 設定時 | System.exit()を許可するが警告ログを出力 |
| THROW | 設定時 | `UserSystemExitException`をスロー |

## 備考

### デプロイメントモード別の考慮事項

| モード | セキュリティ考慮事項 |
| --- | --- |
| Standalone | 全ノードでkeytabファイルの配置が必要 |
| YARN | keytabは自動的にコンテナに配布、YARN proxy経由のHTTPSアクセスにはCA証明書の設定が必要 |
| Native Kubernetes | keytabはコンテナイメージに含めるか、シークレットとしてマウント |

### 推奨セキュリティ設定

1. **内部通信**: 自己署名証明書による相互認証を推奨（専用CA使用の場合は証明書フィンガープリントの設定が必須）
2. **REST API**: プロキシ（Envoy、NGINX）を前段に配置し、認証を委譲することを推奨
3. **暗号スイート**: IETF RFC 7525準拠の強力な暗号スイートへの更新を推奨
4. **Keytab**: 有効期限なしのkeytabを使用し、長時間実行ジョブの中断を防止

### セキュリティモジュールのロード順序

1. セキュリティモジュールのインストール（Hadoop、JAAS、ZooKeeper）
2. セキュリティコンテキストのインストール（HadoopSecurityContext または NoOpSecurityContext）

### サポートされる外部システム認証

| システム | 認証方式 |
| --- | --- |
| Kafka (0.9+) | Kerberos (SASL) |
| HDFS | Kerberos / 委任トークン |
| HBase | Kerberos / 委任トークン |
| ZooKeeper | SASL (Kerberos) |
| S3 | 委任トークン (STS一時認証情報) |
