---
generated_at: 2026-02-02 15:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **コードカバレッジ目標**: 明示的なカバレッジ設定の確認が困難
  2. **パフォーマンステスト詳細**: 実行タイミングの推測に基づく記述

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/pom.xml` (ルートpom.xml - テスト依存関係、プラグイン設定)
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/.github/workflows/ci.yml` (CI設定)
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/.github/workflows/nightly.yml` (Nightlyビルド設定)
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/.github/workflows/template.flink-ci.yml` (CI テンプレート)
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/tools/ci/test_controller.sh` (テストコントローラスクリプト)
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/tools/ci/stage.sh` (テストステージ定義)
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/flink-test-utils-parent/pom.xml` (テストユーティリティモジュール構成)
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/flink-end-to-end-tests/run-nightly-tests.sh` (E2Eテストスクリプト)
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/flink-python/dev/lint-python.sh` (Pythonテストスクリプト)
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/flink-python/pom.xml` (PyFlinkモジュールpom)
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/flink-master/flink-architecture-tests/` (アーキテクチャテストモジュール)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトバージョン2.3-SNAPSHOT | E-01 (line 31) | ○ |
| C-02 | JUnit 5バージョン5.11.4 | E-01 (line 158) | ○ |
| C-03 | JUnit 4バージョン4.13.2 | E-01 (line 157) | ○ |
| C-04 | Mockitoバージョン5.19.0 | E-01 (line 160) | ○ |
| C-05 | AssertJバージョン3.27.3 | E-01 (line 162) | ○ |
| C-06 | Hamcrestバージョン1.3 | E-01 (line 161) | ○ |
| C-07 | Testcontainersバージョン1.20.2 | E-01 (line 167) | ○ |
| C-08 | ArchUnitバージョン1.4.1 | E-01 (line 159) | ○ |
| C-09 | Maven Surefire Pluginバージョン3.2.2 | E-01 (line 1808) | ○ |
| C-10 | 単体テストパターン`**/*Test.*` | E-01 (line 224) | ○ |
| C-11 | 単体テストforkCount=4 | E-01 (line 127) | ○ |
| C-12 | 結合テストforkCount=2 | E-01 (line 126) | ○ |
| C-13 | 単体テストXmx768m | E-01 (line 120) | ○ |
| C-14 | 結合テストXmx1536m | E-01 (line 119) | ○ |
| C-15 | テストモジュール構成(core, table, connect, tests, misc, python) | E-06 (全体) | ○ |
| C-16 | CIジョブタイムアウト240分 | E-04 (line 80-81) | ○ |
| C-17 | E2Eテストタイムアウト310分 | E-04 (line 293-296) | ○ |
| C-18 | GitHub Actionsでubuntu-24.04使用 | E-04 (line 73, 129, 169) | ○ |
| C-19 | Dockerイメージ`chesnay/flink-ci:java_8_11_17_21_maven_386_jammy` | E-04 (line 75, 131, 171) | ○ |
| C-20 | Nightlyビルドで複数JDKバージョン(11, 17, 21)テスト | E-03 (line 31-52) | ○ |
| C-21 | Hadoop 3.2.3互換性テスト | E-03 (line 53-63) | ○ |
| C-22 | AdaptiveScheduler有効化テスト | E-03 (line 64-74) | ○ |
| C-23 | Python Wheelsビルド(Linux/macOS) | E-03 (line 76-123) | ○ |
| C-24 | E2Eテストがグループ1,2に分割 | E-04 (line 314) | ○ |
| C-25 | `@FailsWithAdaptiveScheduler`アノテーションによるテスト除外 | E-01 (line 1010) | ○ |
| C-26 | `@FailsInGHAContainerWithRootUser`アノテーションによるテスト除外 | E-01 (line 1035) | ○ |
| C-27 | `@FailsOnJava11`アノテーションによるテスト除外 | E-01 (line 1063) | ○ |
| C-28 | `@FailsOnJava17`アノテーションによるテスト除外 | E-01 (line 1113) | ○ |
| C-29 | flink-test-utils-parentの7モジュール構成 | E-07 (全体) | ○ |
| C-30 | JUnit 5並列テストdynamic戦略 | E-01 (line 1844) | ○ |
| C-31 | チェックポイントランダム化設定 | E-01 (line 1820) | ○ |
| C-32 | HeapDumpOnOutOfMemoryError設定 | E-05 (line 67) | ○ |
| C-33 | PyFlinkでlint-python.sh実行 | E-05 (line 103-106) | ○ |
| C-34 | コードカバレッジツール（Jacoco/Cobertura）未導入 | **根拠なし** | △ |
| C-35 | パフォーマンステストがNightlyビルドで実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-34（コードカバレッジ未導入）**: pom.xmlを検索した結果、jacoco/coberturaの設定が見つからなかったことを根拠としているが、別途設定ファイルが存在する可能性がある
  - 候補：別リポジトリの設定 / Maven profiles / 外部CIサービス設定
- **C-35（パフォーマンステスト実行タイミング）**: Nightlyビルド設定にパフォーマンステスト専用のジョブが明示されていない。E2Eテストに含まれている可能性がある
  - 候補：flink-benchmarksリポジトリ / 外部パフォーマンス測定システム / 手動実行

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストフレームワーク・ツールのバージョン情報 - pom.xmlから直接取得
- **0（低リスク）**: CI/CD設定 - GitHub Actionsワークフローファイルから直接取得
- **0（低リスク）**: テストモジュール構成 - stage.shから直接取得
- **1（中リスク）**: コードカバレッジ目標 - 明示的な設定が見つからないため推測を含む
- **1（中リスク）**: パフォーマンステスト実行タイミング - 専用設定が見つからないため推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] テストフレームワークバージョンが実際のpom.xmlと一致しているか確認
- [ ] CI/CDワークフローの構成が現行設定と一致しているか確認
- [ ] テストモジュール構成（6ステージ）が実運用と一致しているか確認
- [ ] コードカバレッジに関する社内方針・別途設定の有無を確認
- [ ] パフォーマンステストの実際の実行方法・タイミングを確認
- [ ] flink-benchmarksなど外部リポジトリでのテスト実施有無を確認
