# テスト方針書

## 概要

本ドキュメントは、Apache Flink 2.3-SNAPSHOT プロジェクトにおけるテスト戦略および方針を定義するものである。Flinkは大規模分散ストリーム処理フレームワークであり、Java/Scala/Pythonの多言語サポートと、100以上のモジュールから構成される複雑なシステムである。本プロジェクトでは、Maven Surefireプラグインによる単体テスト・結合テスト、JUnit 5を中心としたテストフレームワーク、GitHub Actions/Azure PipelinesによるCI/CD、およびシェルスクリプトベースのEnd-to-Endテストを採用している。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト (Unit Test) | 個別クラス・メソッドの機能検証。`**/*Test.*`パターンにマッチするテストクラスで実行。 | 開発者 |
| 結合テスト (Integration Test / ITCase) | 複数コンポーネント間の連携検証。`**/*ITCase.*`パターンにマッチするテストクラスで実行。MiniClusterを使用した統合テストを含む。 | 開発者・QA |
| エンドツーエンドテスト (E2E Test) | フルシステムテスト。`flink-end-to-end-tests`モジュールによるシェルスクリプトベースのテスト実行。Docker/Kubernetesを含む実環境に近いテスト。 | QA・インフラ |
| アーキテクチャテスト | ArchUnitによるコード構造・依存関係の検証。アーキテクチャ違反の自動検出。 | 開発者 |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各モジュールの機能要件検証 | プルリクエスト時・マージ後 |
| パフォーマンステスト | チェックポイント、ステート管理、スループット検証 | Nightlyビルド |
| セキュリティテスト | Kerberos認証、SSL/TLS通信の検証 | E2Eテスト時 |
| 互換性テスト | 複数JDKバージョン（11, 17, 21）、Hadoopバージョン対応テスト | Nightlyビルド |
| リグレッションテスト | セーブポイント/チェックポイントの互換性、マイグレーションテスト | リリース前・E2Eテスト |
| アーキテクチャテスト | ArchUnitによる設計制約の検証、API アノテーション規約のチェック | プルリクエスト時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による単体・結合テスト | Maven + JDK 17、ローカルMiniCluster |
| GitHub Actions CI | プルリクエスト時の自動テスト | ubuntu-24.04, Docker container (`chesnay/flink-ci:java_8_11_17_21_maven_386_jammy`) |
| GitHub Actions Nightly | 拡張CIテスト（複数JDKバージョン、Hadoop互換性） | 同上 + 複数JDKプロファイル |
| E2E テスト環境 | End-to-Endテスト | Docker, Kubernetes, YARN環境 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| JUnit 5 (Jupiter) | Java単体テスト・結合テストフレームワーク | 5.11.4 |
| JUnit 4 (Vintage) | レガシーテストのサポート | 4.13.2 |
| Mockito | モックオブジェクト生成 | 5.19.0 |
| AssertJ | アサーションライブラリ | 3.27.3 |
| Hamcrest | マッチャーベースのアサーション | 1.3 |
| Testcontainers | Dockerコンテナを使用したテスト | 1.20.2 |
| ArchUnit | アーキテクチャテスト | 1.4.1 |
| Maven Surefire Plugin | テスト実行 | 3.2.2 |
| pytest/tox | Pythonテストフレームワーク (PyFlink) | - |
| flake8/mypy | Python静的解析 | - |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な目標値は設定されていない（Jacoco/Cobertura未導入） |
| 分岐カバレッジ | 明示的な目標値は設定されていない |

**備考**: Apache Flinkプロジェクトでは、コードカバレッジツール（Jacoco/Cobertura）はpom.xmlに設定されていない。テスト品質は、包括的なテストスイートと多段階のCI/CDパイプラインによって担保されている。

## テストデータ

### テストデータの準備方針

1. **テストファクトリ・ビルダー**: `flink-test-utils`モジュールにテストユーティリティクラスを集約
   - `flink-test-utils-junit`: JUnit拡張機能
   - `flink-test-utils`: テストヘルパー、MiniCluster設定
   - `flink-connector-test-utils`: コネクタテスト用ユーティリティ
   - `flink-migration-test-utils`: マイグレーションテスト用ユーティリティ

2. **テストリソース**: 各モジュールの`src/test/resources`ディレクトリに配置
   - 設定ファイル（`log4j2-test.properties`等）
   - テスト用データファイル

3. **Testcontainers**: 外部システム（Kafka, Elasticsearch, RabbitMQ等）のテスト用にDockerコンテナを使用

4. **Docker Images キャッシュ**: `DockerImageVersions.java`で管理されるイメージをキャッシュ

## 不具合管理

### 不具合の管理方法

1. **課題追跡**: Apache JIRA（FLINK-XXXXXの形式）で管理
2. **テスト失敗時の対応**:
   - CI/CDで失敗時は自動でログ・コアダンプを収集
   - `DEBUG_FILES_OUTPUT_DIR`に詳細なデバッグ情報を出力
   - ヒープダンプ自動生成（`-XX:+HeapDumpOnOutOfMemoryError`）

3. **テスト除外の仕組み**:
   - `@FailsWithAdaptiveScheduler`: Adaptive Scheduler環境で失敗するテストを除外
   - `@FailsInGHAContainerWithRootUser`: GitHub Actions環境で失敗するテストを除外
   - `@FailsOnJava11`, `@FailsOnJava17`: 特定JDKバージョンで失敗するテストを除外

## CI/CD連携

### CI/CDパイプラインでのテスト実行

#### 1. 通常CI（プルリクエスト時）

```
Flink CI (beta)
├── Pre-compile Checks (ライセンスチェック、スタイルチェック等)
└── Default (Java 17)
    ├── Compile: コンパイル・成果物作成
    ├── Test packaging/licensing: パッケージング・ライセンステスト
    ├── Test (module: core): コアモジュールテスト
    ├── Test (module: python): PyFlinkテスト
    ├── Test (module: table): Tableモジュールテスト
    ├── Test (module: connect): コネクタモジュールテスト
    ├── Test (module: tests): 統合テストモジュール
    ├── Test (module: misc): その他モジュール
    ├── E2E (group 1): End-to-Endテスト グループ1
    └── E2E (group 2): End-to-Endテスト グループ2
```

#### 2. Nightlyビルド（拡張CI）

- **Java 11**: JDK 11環境でのテスト
- **Java 21**: JDK 21環境でのテスト
- **Hadoop 3.2.3**: Hadoop 3.x互換性テスト
- **AdaptiveScheduler**: Adaptive Scheduler有効化テスト
- **Python Wheels Build**: Linux/macOS向けPythonホイールのビルド

#### 3. テスト実行の構成

- **並列実行**:
  - 単体テスト: `forkCount=4`
  - 結合テスト: `forkCount=2`
  - JUnit 5並列テスト: `dynamic`戦略による自動調整

- **タイムアウト設定**:
  - 標準テスト: 240分
  - E2Eテスト: 310分

- **リソース管理**:
  - 単体テスト: `-Xmx768m`
  - 結合テスト: `-Xmx1536m`
  - G1GCの使用

#### 4. テストモジュール構成

| ステージ | 対象モジュール |
| --- | --- |
| core | flink-annotations, flink-core, flink-runtime, flink-streaming-java, flink-state-backends等 |
| table | flink-table-*, flink-sql-*モジュール |
| connect | flink-filesystems, flink-formats, flink-connectors, flink-metrics等 |
| tests | flink-tests統合テストモジュール |
| misc | 上記以外のモジュール |
| python | PyFlinkテスト（lint-python.sh実行） |

## 備考

### プロジェクト固有の特徴

1. **マルチ言語サポート**: Java, Scala, Pythonのテストが混在
2. **大規模モジュール構成**: 100以上のMavenモジュール
3. **複数のテスト実行方式**:
   - Maven Surefire（単体・結合テスト）
   - シェルスクリプト（E2Eテスト）
   - pytest/tox（Pythonテスト）

4. **テストの安定性確保**:
   - チェックポイントランダム化（`checkpointing.randomization`）
   - バッファデブロートランダム化（`buffer-debloat.randomization`）
   - テストシードの指定機能（`test.randomization.seed`）

5. **依存コンポーネント**:
   - Apache Zookeeper 3.7.2
   - Apache Curator 5.4.0
   - Apache Hadoop 2.10.2（デフォルト）
   - Apache Beam 2.54.0（PyFlink依存）
