# ER図

## Apache Flink カタログシステム ER図

Apache Flinkのカタログシステムにおけるメタデータエンティティ間の関係を示すER図です。

```mermaid
erDiagram
    Catalog ||--o{ CatalogDatabase : contains
    CatalogDatabase ||--o{ CatalogTable : contains
    CatalogDatabase ||--o{ CatalogView : contains
    CatalogDatabase ||--o{ CatalogMaterializedTable : contains
    CatalogDatabase ||--o{ CatalogFunction : contains
    CatalogDatabase ||--o{ CatalogModel : contains

    CatalogTable ||--|| ResolvedSchema : has
    CatalogTable ||--o{ CatalogPartition : has

    CatalogView ||--|| ResolvedSchema : has

    CatalogMaterializedTable ||--|| ResolvedSchema : has
    CatalogMaterializedTable ||--o{ CatalogPartition : has

    ResolvedSchema ||--o{ Column : contains
    ResolvedSchema ||--o| UniqueConstraint : has
    ResolvedSchema ||--o{ Index : has
    ResolvedSchema ||--o{ WatermarkSpec : has

    Column ||--|| DataType : has

    Catalog {
        String defaultDatabase
    }

    CatalogDatabase {
        Map properties
        String comment
        String description
        String detailedDescription
    }

    CatalogTable {
        Schema schema
        String comment
        List partitionKeys
        Map options
        Long snapshot
        TableDistribution distribution
    }

    CatalogView {
        Schema schema
        String comment
        String originalQuery
        String expandedQuery
        Map options
    }

    CatalogMaterializedTable {
        Schema schema
        String comment
        List partitionKeys
        Map options
        TableDistribution distribution
        Long snapshot
        String originalQuery
        String expandedQuery
        IntervalFreshness definitionFreshness
        LogicalRefreshMode logicalRefreshMode
        RefreshMode refreshMode
        RefreshStatus refreshStatus
        String refreshHandlerDescription
        bytes serializedRefreshHandler
    }

    CatalogPartition {
        Map properties
        String comment
        String description
        String detailedDescription
    }

    CatalogFunction {
        String className
        FunctionLanguage functionLanguage
        boolean isGeneric
    }

    CatalogModel {
        Schema inputSchema
        Schema outputSchema
        Map options
        String comment
    }

    ResolvedSchema {
        List columns
        List watermarkSpecs
        UniqueConstraint primaryKey
        List indexes
    }

    Column {
        String name
        DataType dataType
        String comment
    }

    UniqueConstraint {
        String name
        boolean enforced
        ConstraintType type
        List columns
    }

    Index {
        String name
        List columns
    }

    WatermarkSpec {
        String rowtimeAttribute
        ResolvedExpression watermarkExpression
    }

    DataType {
        LogicalType logicalType
        Class conversionClass
    }
```

## カラム種別のクラス階層

```mermaid
classDiagram
    Column <|-- PhysicalColumn
    Column <|-- ComputedColumn
    Column <|-- MetadataColumn

    class Column {
        <<abstract>>
        #String name
        #DataType dataType
        #String comment
        +getName() String
        +getDataType() DataType
        +getComment() Optional~String~
        +isPhysical() boolean
        +isPersisted() boolean
    }

    class PhysicalColumn {
        +isPhysical() boolean = true
        +isPersisted() boolean = true
    }

    class ComputedColumn {
        -ResolvedExpression expression
        +getExpression() ResolvedExpression
        +isPhysical() boolean = false
        +isPersisted() boolean = false
    }

    class MetadataColumn {
        -String metadataKey
        -boolean isVirtual
        +getMetadataKey() Optional~String~
        +isVirtual() boolean
        +isPhysical() boolean = false
        +isPersisted() boolean = !isVirtual
    }
```

## データ型階層

```mermaid
classDiagram
    LogicalTypeRoot <.. LogicalType
    LogicalType <|-- CharType
    LogicalType <|-- VarCharType
    LogicalType <|-- BooleanType
    LogicalType <|-- BinaryType
    LogicalType <|-- VarBinaryType
    LogicalType <|-- DecimalType
    LogicalType <|-- TinyIntType
    LogicalType <|-- SmallIntType
    LogicalType <|-- IntType
    LogicalType <|-- BigIntType
    LogicalType <|-- FloatType
    LogicalType <|-- DoubleType
    LogicalType <|-- DateType
    LogicalType <|-- TimeType
    LogicalType <|-- TimestampType
    LogicalType <|-- ArrayType
    LogicalType <|-- MapType
    LogicalType <|-- RowType

    class LogicalTypeRoot {
        <<enumeration>>
        CHAR
        VARCHAR
        BOOLEAN
        BINARY
        VARBINARY
        DECIMAL
        TINYINT
        SMALLINT
        INTEGER
        BIGINT
        FLOAT
        DOUBLE
        DATE
        TIME_WITHOUT_TIME_ZONE
        TIMESTAMP_WITHOUT_TIME_ZONE
        TIMESTAMP_WITH_TIME_ZONE
        TIMESTAMP_WITH_LOCAL_TIME_ZONE
        INTERVAL_YEAR_MONTH
        INTERVAL_DAY_TIME
        ARRAY
        MULTISET
        MAP
        ROW
        DISTINCT_TYPE
        STRUCTURED_TYPE
        NULL
        RAW
        SYMBOL
        VARIANT
    }

    class LogicalType {
        <<abstract>>
        #boolean nullable
        +getTypeRoot() LogicalTypeRoot
        +isNullable() boolean
        +getChildren() List~LogicalType~
    }
```

## テーブル種別階層

```mermaid
classDiagram
    CatalogBaseTable <|-- CatalogTable
    CatalogBaseTable <|-- CatalogView
    CatalogBaseTable <|-- CatalogMaterializedTable

    class CatalogBaseTable {
        <<interface>>
        +getTableKind() TableKind
        +getSchema() Schema
        +getComment() String
        +getOptions() Map~String_String~
        +getUnresolvedSchema() Schema
    }

    class CatalogTable {
        <<interface>>
        +isPartitioned() boolean
        +getPartitionKeys() List~String~
        +getSnapshot() Optional~Long~
        +getDistribution() Optional~TableDistribution~
    }

    class CatalogView {
        <<interface>>
        +getOriginalQuery() String
        +getExpandedQuery() String
    }

    class CatalogMaterializedTable {
        <<interface>>
        +isPartitioned() boolean
        +getPartitionKeys() List~String~
        +getOriginalQuery() String
        +getExpandedQuery() String
        +getDefinitionFreshness() IntervalFreshness
        +getLogicalRefreshMode() LogicalRefreshMode
        +getRefreshMode() RefreshMode
        +getRefreshStatus() RefreshStatus
    }

    class TableKind {
        <<enumeration>>
        TABLE
        VIEW
        MATERIALIZED_TABLE
    }
```

## カタログシステム全体構造

```mermaid
flowchart TB
    subgraph Catalog["Catalog"]
        subgraph DB1["Database: default"]
            T1["Table: users"]
            T2["Table: orders"]
            V1["View: active_users"]
            MT1["MaterializedTable: daily_stats"]
            F1["Function: my_udf"]
            M1["Model: prediction_model"]
        end
        subgraph DB2["Database: analytics"]
            T3["Table: events"]
            T4["Table: metrics"]
        end
    end

    T1 --> S1["ResolvedSchema"]
    S1 --> C1["Column: id (BIGINT)"]
    S1 --> C2["Column: name (VARCHAR)"]
    S1 --> C3["Column: created_at (TIMESTAMP)"]
    S1 --> PK1["PrimaryKey: pk_users (id)"]
    S1 --> W1["Watermark: created_at"]

    T1 --> P1["Partition: region=us"]
    T1 --> P2["Partition: region=eu"]
```

## 備考

- このER図はApache Flinkのカタログシステムのメタデータ構造を表現しています
- Flinkはデータ自体を永続化せず、外部システムへの接続メタデータを管理します
- 実際のデータストレージはKafka、HDFS、各種データベースなどの外部システムに依存します
