# データベース設計書

## 概要

本ドキュメントは、Apache Flinkプロジェクトにおけるデータベース（カタログ）設計を記述したものです。

Apache Flinkは分散ストリーム処理フレームワークであり、従来のRDBMSとは異なるアーキテクチャを採用しています。Flinkでは「カタログ（Catalog）」という概念を用いて、テーブル、ビュー、関数、データベースなどのメタデータを管理します。このカタログシステムは、Flink SQL/Table APIと外部ストレージシステムを接続するためのメタデータ管理レイヤーとして機能します。

**注意**: Apache Flinkはストリーム/バッチ処理エンジンであり、データを永続化するデータベースではありません。本設計書では、Flinkのカタログシステムが管理するメタデータ構造を「データベース設計」として記述します。

## テーブル一覧

Flinkのカタログシステムでは、以下の主要なメタデータエンティティが管理されます。

| テーブル名（メタデータエンティティ） | 対応Javaインターフェース | 説明 |
| --- | --- | --- |
| Catalog | `org.apache.flink.table.catalog.Catalog` | カタログのルートエンティティ。データベース、テーブル、関数を管理 |
| CatalogDatabase | `org.apache.flink.table.catalog.CatalogDatabase` | データベースメタデータ。テーブルやビューのコンテナ |
| CatalogTable | `org.apache.flink.table.catalog.CatalogTable` | テーブルメタデータ。スキーマ、パーティション、オプションを保持 |
| CatalogView | `org.apache.flink.table.catalog.CatalogView` | ビューメタデータ。クエリ定義を保持 |
| CatalogMaterializedTable | `org.apache.flink.table.catalog.CatalogMaterializedTable` | マテリアライズドテーブルメタデータ。リフレッシュ設定を含む |
| CatalogPartition | `org.apache.flink.table.catalog.CatalogPartition` | パーティションメタデータ |
| CatalogFunction | `org.apache.flink.table.catalog.CatalogFunction` | ユーザー定義関数メタデータ |
| CatalogModel | `org.apache.flink.table.catalog.CatalogModel` | 機械学習モデルメタデータ |
| ResolvedSchema | `org.apache.flink.table.catalog.ResolvedSchema` | 解決済みテーブルスキーマ。カラム、制約、ウォーターマークを保持 |
| Column | `org.apache.flink.table.catalog.Column` | カラムメタデータ。物理・計算・メタデータカラムを含む |
| UniqueConstraint | `org.apache.flink.table.catalog.UniqueConstraint` | 一意制約（主キー含む） |
| Index | `org.apache.flink.table.catalog.Index` | インデックスメタデータ |
| WatermarkSpec | `org.apache.flink.table.catalog.WatermarkSpec` | ウォーターマーク仕様 |

## 各テーブル定義

### 1. Catalog（カタログ）

Flinkカタログシステムのルートエンティティです。データベース、テーブル、ビュー、関数、モデルなどのメタデータを管理し、Flink Table APIとの接続を提供します。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| defaultDatabase | String | YES | デフォルトデータベース名 |

### 2. CatalogDatabase（データベース）

カタログ内のデータベースを表すメタデータエンティティです。テーブル、ビュー、関数のコンテナとして機能します。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| properties | Map<String, String> | NO | データベースに関連付けられたプロパティ |
| comment | String | YES | データベースのコメント |
| description | String | YES | データベースの簡潔な説明 |
| detailedDescription | String | YES | データベースの詳細説明 |

### 3. CatalogTable（テーブル）

データベース内のテーブルを表すメタデータエンティティです。SQL CREATE TABLE文で表現できる全ての特性を含みます。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| schema | Schema | NO | テーブルスキーマ定義 |
| comment | String | YES | テーブルコメント |
| partitionKeys | List<String> | NO | パーティションキーのカラム名リスト |
| options | Map<String, String> | NO | コネクタオプション設定 |
| snapshot | Long | YES | テーブルスナップショットID |
| distribution | TableDistribution | YES | データ分散設定 |

### 4. CatalogView（ビュー）

データベース内のビューを表すメタデータエンティティです。SQL CREATE VIEW文で表現できる全ての特性を含みます。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| schema | Schema | NO | ビュースキーマ定義 |
| comment | String | YES | ビューコメント |
| originalQuery | String | NO | ユーザーが定義した元のクエリテキスト |
| expandedQuery | String | NO | 識別子が展開されたクエリテキスト |
| options | Map<String, String> | NO | コネクタオプション設定 |

### 5. CatalogMaterializedTable（マテリアライズドテーブル）

ストリーミング/バッチ統合ストレージのためのマテリアライズドテーブルを表します。データの新鮮度（freshness）とリフレッシュパイプラインを管理します。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| schema | Schema | NO | テーブルスキーマ定義 |
| comment | String | YES | テーブルコメント |
| partitionKeys | List<String> | NO | パーティションキーのカラム名リスト |
| options | Map<String, String> | NO | コネクタオプション設定 |
| distribution | TableDistribution | YES | データ分散設定 |
| snapshot | Long | YES | テーブルスナップショットID |
| originalQuery | String | NO | 元のクエリテキスト |
| expandedQuery | String | NO | 展開されたクエリテキスト |
| definitionFreshness | IntervalFreshness | YES | データ新鮮度の定義 |
| logicalRefreshMode | LogicalRefreshMode | NO | 論理リフレッシュモード（CONTINUOUS/FULL/AUTOMATIC） |
| refreshMode | RefreshMode | YES | 物理リフレッシュモード（CONTINUOUS/FULL） |
| refreshStatus | RefreshStatus | NO | リフレッシュ状態（INITIALIZING/ACTIVATED/SUSPENDED） |
| refreshHandlerDescription | String | YES | リフレッシュハンドラの説明 |
| serializedRefreshHandler | byte[] | YES | シリアライズされたリフレッシュハンドラ |

### 6. CatalogPartition（パーティション）

テーブルのパーティションを表すメタデータエンティティです。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| properties | Map<String, String> | NO | パーティションプロパティ |
| comment | String | YES | パーティションコメント |
| description | String | YES | パーティションの簡潔な説明 |
| detailedDescription | String | YES | パーティションの詳細説明 |

### 7. ResolvedSchema（解決済みスキーマ）

テーブルまたはビューの解決済みスキーマを表します。カラム、ウォーターマーク仕様、主キー制約、インデックスを含みます。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| columns | List<Column> | NO | カラムのリスト |
| watermarkSpecs | List<WatermarkSpec> | NO | ウォーターマーク仕様のリスト |
| primaryKey | UniqueConstraint | YES | 主キー制約 |
| indexes | List<Index> | NO | インデックスのリスト |

### 8. Column（カラム）

テーブルスキーマ内のカラムを表す抽象クラスです。以下の3種類のサブタイプがあります。

#### 8.1 PhysicalColumn（物理カラム）

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | カラム名 |
| dataType | DataType | NO | データ型 |
| comment | String | YES | カラムコメント |

#### 8.2 ComputedColumn（計算カラム）

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | カラム名 |
| dataType | DataType | NO | データ型 |
| expression | ResolvedExpression | NO | 計算式 |
| comment | String | YES | カラムコメント |

#### 8.3 MetadataColumn（メタデータカラム）

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | カラム名 |
| dataType | DataType | NO | データ型 |
| metadataKey | String | YES | メタデータキー |
| isVirtual | boolean | NO | 仮想カラムかどうか |
| comment | String | YES | カラムコメント |

### 9. UniqueConstraint（一意制約）

テーブルの一意制約（主キーを含む）を表します。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | 制約名 |
| enforced | boolean | NO | 強制フラグ |
| type | ConstraintType | NO | 制約タイプ（PRIMARY_KEY/UNIQUE_KEY） |
| columns | List<String> | NO | 制約対象カラム名リスト |

### 10. Index（インデックス）

テーブルのインデックスを表します。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | インデックス名 |
| columns | List<String> | NO | インデックス対象カラム名リスト |

### 11. WatermarkSpec（ウォーターマーク仕様）

ストリーム処理におけるウォーターマーク生成の仕様を表します。

| カラム名（属性） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| rowtimeAttribute | String | NO | 行時間属性のカラム名 |
| watermarkExpression | ResolvedExpression | NO | ウォーターマーク生成式 |

## サポートされるデータ型

Flinkは以下のデータ型（LogicalTypeRoot）をサポートしています。

| カテゴリ | データ型 | 説明 |
| --- | --- | --- |
| 文字列 | CHAR | 固定長文字列 |
| 文字列 | VARCHAR | 可変長文字列 |
| 論理型 | BOOLEAN | 真偽値 |
| バイナリ | BINARY | 固定長バイナリ |
| バイナリ | VARBINARY | 可変長バイナリ |
| 数値 | DECIMAL | 精度指定小数 |
| 数値 | TINYINT | 8ビット整数 |
| 数値 | SMALLINT | 16ビット整数 |
| 数値 | INTEGER | 32ビット整数 |
| 数値 | BIGINT | 64ビット整数 |
| 数値 | FLOAT | 単精度浮動小数点 |
| 数値 | DOUBLE | 倍精度浮動小数点 |
| 日時 | DATE | 日付 |
| 日時 | TIME_WITHOUT_TIME_ZONE | タイムゾーンなし時刻 |
| 日時 | TIMESTAMP_WITHOUT_TIME_ZONE | タイムゾーンなしタイムスタンプ |
| 日時 | TIMESTAMP_WITH_TIME_ZONE | タイムゾーン付きタイムスタンプ |
| 日時 | TIMESTAMP_WITH_LOCAL_TIME_ZONE | ローカルタイムゾーン付きタイムスタンプ |
| 時間間隔 | INTERVAL_YEAR_MONTH | 年月間隔 |
| 時間間隔 | INTERVAL_DAY_TIME | 日時間隔 |
| コレクション | ARRAY | 配列 |
| コレクション | MULTISET | マルチセット |
| コレクション | MAP | マップ |
| 複合型 | ROW | 行（構造体） |
| ユーザー定義 | DISTINCT_TYPE | ユーザー定義の別名型 |
| ユーザー定義 | STRUCTURED_TYPE | 構造化型 |
| 拡張 | NULL | NULL型 |
| 拡張 | RAW | 生バイト型 |
| 拡張 | SYMBOL | シンボル型 |
| 拡張 | VARIANT | バリアント型 |

## 備考

### Flinkカタログシステムの特徴

1. **メタデータ管理**: Flinkはデータ自体を永続化せず、外部システム（Kafka、HDFS、データベースなど）への接続メタデータを管理します。

2. **カタログ階層**: Catalog -> Database -> Table/View/Function の3階層構造で管理されます。

3. **動的テーブル**: Flinkのテーブルは「動的テーブル」であり、時間とともに変化するデータストリームを表現します。

4. **ウォーターマーク**: ストリーム処理における時間ベースの処理を制御するためのウォーターマーク仕様をスキーマに含めることができます。

5. **マテリアライズドテーブル**: バッチとストリーミングの統合処理のため、データの新鮮度とリフレッシュパイプラインを管理します。

### 主要なソースファイル

- `flink-table/flink-table-common/src/main/java/org/apache/flink/table/catalog/Catalog.java`
- `flink-table/flink-table-common/src/main/java/org/apache/flink/table/catalog/CatalogTable.java`
- `flink-table/flink-table-common/src/main/java/org/apache/flink/table/catalog/ResolvedSchema.java`
- `flink-table/flink-table-common/src/main/java/org/apache/flink/table/catalog/Column.java`
- `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/logical/LogicalTypeRoot.java`
