# バッチ設計書 10-BatchExecLookupJoin

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecLookupJoinバッチ実行ノードの設計仕様を記載する。このノードは、テンポラルテーブル（時態テーブル）との結合をルックアップ方式で実行する。

### 本バッチの処理概要

BatchExecLookupJoinは、Flinkバッチ実行プランにおいて、入力ストリームの各レコードに対して外部テーブル（ルックアップテーブル）からリアルタイムにデータを取得して結合する実行ノードである。テンポラルテーブル結合（FOR SYSTEM_TIME AS OF）の実装。

**業務上の目的・背景**：マスターデータやディメンションテーブルとの結合を効率的に行う。入力レコードごとに最新のマスターデータを参照する必要があるユースケース（顧客情報、商品情報、為替レートなど）で使用される。

**バッチの実行タイミング**：Flinkジョブのバッチ実行時に、入力ストリームの各レコード処理時にルックアップを実行。同期または非同期でのルックアップをサポート。

**主要な処理内容**：
1. 入力Transformationを取得
2. テンポラルテーブルからLookupTableSourceを取得
3. ルックアップ関数（TableFunction/AsyncTableFunction）を取得
4. ルックアップキーに基づいてルックアップを実行
5. 結合結果を出力

**前後の処理との関連**：上流のスキャン、フィルタ、射影などのノードから入力を受け取る。後続には集約、ソート、別の結合などが接続可能。

**影響範囲**：外部システムへのルックアップ呼び出しが発生するため、外部システムの可用性・レイテンシが処理性能に影響。

## バッチ種別

結合処理（Lookup Join）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ジョブ実行時（随時） |
| 実行時刻 | ジョブスケジュールに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Flinkジョブ実行時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ルックアップテーブル | LookupTableSourceを実装したテーブルソースが定義されていること |
| ルックアップキー | ルックアップキーが定義されていること |

### 実行可否判定

テンポラルテーブルがLookupTableSourceを実装していること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| joinType | FlinkJoinType | Yes | - | 結合タイプ（INNER/LEFT） |
| preFilterCondition | RexNode | No | null | プリフィルタ条件 |
| remainingJoinCondition | RexNode | No | null | 残余結合条件 |
| temporalTableSourceSpec | TemporalTableSourceSpec | Yes | - | テンポラルテーブル仕様 |
| lookupKeys | Map<Integer, FunctionParam> | Yes | - | ルックアップキー定義 |
| projectionOnTemporalTable | List<RexNode> | No | null | テンポラル表への射影 |
| filterOnTemporalTable | RexNode | No | null | テンポラル表へのフィルタ |
| asyncLookupOptions | AsyncOptions | No | null | 非同期ルックアップオプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 入力ストリーム | Transformation<RowData> | ルックアップの左側入力 |
| ルックアップテーブル | LookupTableSource | ルックアップ対象のテンポラルテーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Transformation<RowData> | RowData | ルックアップ結合結果を後続ノードへ出力 |

### 出力ファイル仕様

ファイル出力はなく、Flink内部のTransformationチェーンへ出力。

## 処理フロー

### 処理シーケンス

```
1. translateToPlanInternal呼び出し
   └─ PlannerBaseとExecNodeConfigを受け取る
2. 入力Transformation取得
   └─ getInputEdges().get(0)から取得
3. テンポラルテーブル取得
   └─ temporalTableSourceSpec.getTemporalTable
4. ルックアップ関数取得
   └─ LookupJoinUtil.getLookupFunction
5. 結合Transformation生成
   └─ createJoinTransformation
6. ルックアップキーでテンポラルテーブルを検索
   └─ 同期または非同期実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力Transformation取得]
    B --> C[テンポラルテーブル取得]
    C --> D[ルックアップ関数取得]
    D --> E{非同期?}
    E -->|Yes| F[AsyncTableFunction使用]
    E -->|No| G[TableFunction使用]
    F --> H[ルックアップ実行]
    G --> H
    H --> I[結合結果生成]
    I --> J[Transformation返却]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ルックアップ | テンポラルテーブル | SELECT | 入力レコードごとにルックアップ実行 |

### テーブル別操作詳細

#### テンポラルテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ルックアップキー列 | 入力レコードの値 | プライマリキーまたはユニークインデックス |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TableException | ルックアップキー不足 | ルックアップキーが空 | ルックアップキーを定義 |
| TableException | 結合タイプエラー | INNER/LEFT以外の結合 | INNER JOINまたはLEFT JOINを使用 |
| IllegalStateException | バッチ非対応 | キー順序付き非同期ルックアップ | バッチモードでは非対応 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | バッチモードではリトライヒント非対応 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ジョブ失敗時はFlinkのリスタート機構に従い再実行。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ルックアップは読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力データ量依存 |
| 目標処理時間 | ルックアップレイテンシ依存 |
| メモリ使用量上限 | async-lookup.buffer-capacity設定 |

## 排他制御

並列実行可能。各タスクは独立してルックアップを実行。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | テンポラルテーブル名 |
| 終了ログ | 処理完了時 | 処理件数 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ルックアップレイテンシ | ジョブ定義依存 | Flink Metrics |
| ルックアップ失敗率 | 0 | Flink Metrics |

## 備考

- FlinkVersion v2.0以降で使用可能
- ExecNodeMetadataのname: "batch-exec-lookup-join"
- 消費オプション: table.exec.async-lookup.buffer-capacity, table.exec.async-lookup.timeout等
- バッチモードではリトライヒント非対応（retryOptions=null）
- キー順序付き非同期ルックアップはバッチモード非対応（IllegalStateException）
- createSyncLookupJoinWithStateはバッチでは入力をそのまま返す（状態管理不要）
- ChangelogMode.insertOnly()で挿入のみモード
- INNER JOINとLEFT JOINのみサポート
