# バッチ設計書 11-BatchExecAdaptiveJoin

## 概要

本ドキュメントは、Apache Flink Table Plannerにおける適応型結合（Adaptive Join）バッチ実行ノードの設計を記述したものである。

### 本バッチの処理概要

BatchExecAdaptiveJoinは、実行時にデータサイズに応じて最適な結合戦略を動的に選択する適応型結合処理を実行するバッチ実行ノードである。

**業務上の目的・背景**：従来の結合処理では、クエリ計画時に結合戦略（ハッシュ結合、ソートマージ結合など）が固定されていた。しかし、実際のデータサイズは実行時まで正確に把握できないことが多く、計画時の見積もりと実際のデータサイズに乖離がある場合、パフォーマンス低下を招く。適応型結合は、実行時にデータサイズを計測し、最適な結合戦略を動的に選択することで、この問題を解決する。

**バッチの実行タイミング**：Flink SQLクエリの実行時、JOINを含むクエリのバッチ処理において動的に呼び出される。Flink Plannerが適応型結合が有効と判断した場合にのみ使用される。

**主要な処理内容**：
1. 左右の入力ストリームからデータを受信
2. 各入力の行サイズと行数の見積もりを基に、ビルドサイド（ハッシュテーブル構築側）を決定
3. 結合条件（等価条件・非等価条件）を評価するための条件関数を生成
4. AdaptiveJoinOperatorGeneratorを使用して、実行時に最適な結合演算子を選択
5. 選択された結合戦略に基づいて結合処理を実行
6. 結合結果を出力

**前後の処理との関連**：入力としてExchange（データパーティショニング）やCalc（フィルタ・射影）ノードを受け取り、結合結果を後続のAggregate（集約）やSink（出力）ノードに渡す。元々のJoin（originalJoin）の情報を保持し、適応処理の参照元とする。

**影響範囲**：本バッチノードは、Flink Table APIおよびSQL APIを使用するすべてのバッチジョブに影響し、特に大規模データの結合処理において効果を発揮する。

## バッチ種別

データ変換処理（結合処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（クエリ実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | Flink SQLクエリの実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データストリーム | 左右2つの入力ストリームが存在すること |
| 結合条件 | JoinSpecによる結合条件が定義されていること |
| メモリ設定 | 結合処理に必要な管理メモリが確保されていること |

### 実行可否判定

Flink Plannerが適応型結合の使用を決定した場合のみ実行される。決定要因には、テーブルの統計情報、結合タイプ（INNER、LEFT、RIGHT、FULLなど）、データサイズ見積もりが含まれる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| joinSpec | JoinSpec | Yes | N/A | 結合仕様（結合キー、結合タイプ、非等価条件など） |
| leftIsBuild | boolean | Yes | N/A | 左側がビルドサイドかどうか |
| estimatedLeftAvgRowSize | int | Yes | N/A | 左側の平均行サイズ見積もり |
| estimatedRightAvgRowSize | int | Yes | N/A | 右側の平均行サイズ見積もり |
| estimatedLeftRowCount | long | Yes | N/A | 左側の行数見積もり |
| estimatedRightRowCount | long | Yes | N/A | 右側の行数見積もり |
| tryDistinctBuildRow | boolean | Yes | N/A | ビルドサイドの重複除去を試みるか |
| originalJoin | OperatorType | Yes | N/A | 元の結合タイプ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 左入力ストリーム | RowData | 結合の左側テーブルからのデータストリーム |
| 右入力ストリーム | RowData | 結合の右側テーブルからのデータストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 結合結果ストリーム | RowData | 結合条件を満たすレコードの組み合わせ |

### 出力ファイル仕様

ファイル出力なし（ストリーム出力のみ）

## 処理フロー

### 処理シーケンス

```
1. 入力変換の取得
   └─ 左右の入力ストリームをTransformationとして取得
2. 入力型の取得
   └─ 左右の入力RowTypeを取得
3. メモリ設定の計算
   └─ 結合タイプに応じた管理メモリサイズを計算
4. 結合条件関数の生成
   └─ 非等価条件がある場合、GeneratedJoinConditionを生成
5. AdaptiveJoinOperatorGeneratorの構築
   └─ すべてのパラメータを設定してジェネレーターを構築
6. Transformationの作成
   └─ 左右の入力を結合し、適応型結合演算子を適用
7. 結果の出力
   └─ 結合結果を後続ノードに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[左入力ストリーム取得]
    A --> C[右入力ストリーム取得]
    B --> D[入力型取得]
    C --> D
    D --> E[管理メモリサイズ計算]
    E --> F[結合条件関数生成]
    F --> G[AdaptiveJoinOperatorGenerator構築]
    G --> H[Transformation作成]
    H --> I[結合処理実行]
    I --> J[結果出力]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチノードはインメモリ処理であり、直接的なデータベース操作は行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TableException | シリアライズエラー | 適応型結合演算子のシリアライズ失敗 | 入力データ型を確認し、シリアライズ可能であることを確認 |
| メモリ不足 | OutOfMemoryError | 管理メモリが不足 | table.exec.resource.hash-agg.memory設定を増加 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Flinkジョブ設定に依存 |
| リトライ間隔 | Flinkジョブ設定に依存 |
| リトライ対象エラー | 一時的なリソース不足 |

### 障害時対応

ジョブ失敗時は、Flink Checkpointから再開するか、ジョブを最初から再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体（Flinkジョブ単位） |
| コミットタイミング | ジョブ完了時 |
| ロールバック条件 | ジョブ失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | データサイズに依存 |
| 目標処理時間 | クエリ複雑度とデータサイズに依存 |
| メモリ使用量上限 | JoinUtil.getManagedMemoryで計算される値 |

## 排他制御

同一ジョブ内で複数のタスクが並列実行される。各タスクは独立して処理を行い、明示的な排他制御は不要。並列度は左右入力のうち大きい方に設定される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Transformation作成時 | AdaptiveJoin情報（originalJoin、description） |
| 進捗ログ | 処理中 | 処理件数、メモリ使用状況 |
| 終了ログ | 処理完了時 | 処理完了ステータス |
| エラーログ | エラー発生時 | エラー詳細、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | ジョブ設定に依存 | Flink監視システム |
| メモリ使用量 | 管理メモリ上限 | Flink監視システム |

## 備考

- 本ノードはFlink 2.0以降で導入された適応型クエリ実行の一部である
- originalJoinフィールドにより、元の結合タイプ（HASH_JOIN、SORT_MERGE_JOINなど）を追跡可能
- 実行時に最適な戦略を選択するため、計画時の見積もりが不正確でも良好なパフォーマンスを発揮する
