# バッチ設計書 12-BatchExecHashAggregate

## 概要

本ドキュメントは、Apache Flink Table Plannerにおけるハッシュベース集約処理のバッチ実行ノードの設計を記述したものである。

### 本バッチの処理概要

BatchExecHashAggregateは、ハッシュテーブルを使用してグループ化と集約を実行するバッチ実行ノードである。GROUP BY句やSUM、COUNT、AVGなどの集約関数を効率的に処理する。

**業務上の目的・背景**：大量データに対するグループ集約処理は、データ分析やレポート生成において最も頻繁に使用される処理の一つである。ハッシュベースの集約は、ハッシュテーブルを使用することで、ソート不要で高速な集約を実現する。特に、グループ数が比較的少なく、メモリに収まる場合に最も効率的である。

**バッチの実行タイミング**：Flink SQLクエリの実行時、GROUP BY句を含むクエリやDISTINCT、集約関数を使用するクエリにおいて呼び出される。Plannerがハッシュ集約が適切と判断した場合に使用される。

**主要な処理内容**：
1. 入力ストリームからデータを受信
2. グルーピングキーに基づいてハッシュテーブルを構築
3. 各グループに対して集約関数（SUM、COUNT、AVG等）を適用
4. 補助グルーピング（auxGrouping）がある場合は追加処理
5. グルーピングキーがない場合は全体集約を実行
6. 集約結果を出力

**前後の処理との関連**：入力としてExchange（データパーティショニング）やCalc（フィルタ・射影）ノードを受け取る。2段階集約（ローカル・グローバル）の場合、isMergeフラグで中間結果のマージ処理を行い、isFinalフラグで最終結果を出力する。

**影響範囲**：Flink Table APIおよびSQL APIを使用するすべてのバッチジョブにおいて、GROUP BY句や集約関数を使用するクエリに影響する。

## バッチ種別

集計処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（クエリ実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | Flink SQLクエリの実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データストリーム | 入力ストリームが存在すること |
| グルーピング定義 | groupingまたは集約関数が定義されていること |
| メモリ設定 | ハッシュ集約に必要な管理メモリが確保されていること |

### 実行可否判定

Flink Plannerがハッシュ集約の使用を決定した場合のみ実行される。ソート集約（BatchExecSortAggregate）との選択は、データ特性とコスト見積もりに基づく。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| grouping | int[] | Yes | N/A | グルーピングキーのフィールドインデックス |
| auxGrouping | int[] | Yes | N/A | 補助グルーピングキーのフィールドインデックス |
| aggCalls | AggregateCall[] | Yes | N/A | 集約関数呼び出しの配列 |
| aggInputRowType | RowType | Yes | N/A | 集約入力の行型 |
| isMerge | boolean | Yes | N/A | 中間結果のマージかどうか |
| isFinal | boolean | Yes | N/A | 最終集約かどうか |
| supportAdaptiveLocalHashAgg | boolean | Yes | N/A | 適応型ローカルハッシュ集約をサポートするか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 入力ストリーム | RowData | 集約対象のデータストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 集約結果ストリーム | RowData | グルーピングキーと集約結果を含むレコード |

### 出力ファイル仕様

ファイル出力なし（ストリーム出力のみ）

## 処理フロー

### 処理シーケンス

```
1. 入力変換の取得
   └─ 入力ストリームをTransformationとして取得
2. 入力型・出力型の取得
   └─ 入力RowTypeと出力RowTypeを取得
3. AggregateInfoListの構築
   └─ 集約関数情報をバッチ用に変換
4. コード生成
   └─ グルーピングキーの有無に応じて異なるジェネレーターを使用
   └─ grouping.length == 0: AggWithoutKeysCodeGenerator
   └─ grouping.length > 0: HashAggCodeGenerator
5. Transformationの作成
   └─ 生成されたオペレーターを使用してTransformationを作成
6. 結果の出力
   └─ 集約結果を後続ノードに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力ストリーム取得]
    B --> C[型情報取得]
    C --> D[AggregateInfoList構築]
    D --> E{グルーピングキー有無}
    E -->|なし| F[AggWithoutKeysCodeGenerator]
    E -->|あり| G[HashAggCodeGenerator]
    F --> H[管理メモリ: 0L]
    G --> I[管理メモリ: TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY]
    H --> J[Transformation作成]
    I --> J
    J --> K[集約処理実行]
    K --> L[結果出力]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチノードはインメモリ処理であり、直接的なデータベース操作は行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OutOfMemoryError | メモリ不足 | ハッシュテーブルがメモリを超過 | TABLE_EXEC_RESOURCE_HASH_AGG_MEMORYを増加、またはスピル設定を確認 |
| IOException | スピルエラー | ディスクへのスピル失敗 | ディスク容量を確認、TABLE_EXEC_SORT_MAX_NUM_FILE_HANDLESを調整 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Flinkジョブ設定に依存 |
| リトライ間隔 | Flinkジョブ設定に依存 |
| リトライ対象エラー | 一時的なリソース不足 |

### 障害時対応

ジョブ失敗時は、Flink Checkpointから再開するか、ジョブを最初から再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体（Flinkジョブ単位） |
| コミットタイミング | ジョブ完了時 |
| ロールバック条件 | ジョブ失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | データサイズに依存 |
| 目標処理時間 | クエリ複雑度とデータサイズに依存 |
| メモリ使用量上限 | TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY設定値 |

## 排他制御

同一ジョブ内で複数のタスクが並列実行される。各タスクは独立したハッシュテーブルを保持し、明示的な排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Transformation作成時 | ノード情報、集約関数リスト |
| 進捗ログ | 処理中 | 処理件数、ハッシュテーブルサイズ |
| 終了ログ | 処理完了時 | 処理完了ステータス |
| エラーログ | エラー発生時 | エラー詳細、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | ジョブ設定に依存 | Flink監視システム |
| メモリ使用量 | 管理メモリ上限 | Flink監視システム |
| スピル発生 | スピル回数 | Flink監視システム |

## 備考

- ExecNodeMetadataにより、batch-exec-hash-aggregate（version 1）として登録
- consumedOptionsとしてhash-agg.memory、sort.max-num-file-handles、spill-compression関連設定を使用
- supportFusionCodegen()がtrueを返すため、Operator Fusionに対応
- Flink 2.0以降で使用可能（minPlanVersion、minStateVersion = v2_0）
