# バッチ設計書 13-BatchExecSortAggregate

## 概要

本ドキュメントは、Apache Flink Table Plannerにおけるソートベース集約処理のバッチ実行ノードの設計を記述したものである。

### 本バッチの処理概要

BatchExecSortAggregateは、ソート済みデータに対してグループ化と集約を実行するバッチ実行ノードである。入力データがグルーピングキーでソートされていることを前提とし、順次処理により集約を行う。

**業務上の目的・背景**：ソートベースの集約は、入力データが既にソートされている場合や、グループ数が非常に多い場合に有効である。ハッシュベースの集約と異なり、メモリ内にすべてのグループを保持する必要がないため、メモリ効率が良い。また、出力が順序付けられるため、後続のソート処理を省略できる場合がある。

**バッチの実行タイミング**：Flink SQLクエリの実行時、GROUP BY句を含むクエリにおいて呼び出される。入力が既にソートされている場合や、Plannerがソート集約が適切と判断した場合に使用される。

**主要な処理内容**：
1. ソート済み入力ストリームからデータを受信
2. グルーピングキーの変化を検出
3. 同一グループのレコードに対して集約関数を適用
4. グループが変わったタイミングで集約結果を出力
5. 補助グルーピング（auxGrouping）がある場合は追加処理
6. グルーピングキーがない場合は全体集約を実行

**前後の処理との関連**：入力としてSort（ソート）やExchange（データパーティショニング）ノードを受け取る。InputSortedExecNodeインターフェースを実装し、入力がソートされていることを表明する。2段階集約の場合、isMerge/isFinalフラグで処理を制御する。

**影響範囲**：Flink Table APIおよびSQL APIを使用するすべてのバッチジョブにおいて、ソートベースの集約が選択されるクエリに影響する。

## バッチ種別

集計処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（クエリ実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | Flink SQLクエリの実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データストリーム | グルーピングキーでソート済みの入力ストリームが存在すること |
| グルーピング定義 | groupingまたは集約関数が定義されていること |

### 実行可否判定

Flink Plannerがソート集約の使用を決定した場合のみ実行される。入力が既にソートされている場合や、メモリ効率を重視する場合に選択される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| grouping | int[] | Yes | N/A | グルーピングキーのフィールドインデックス |
| auxGrouping | int[] | Yes | N/A | 補助グルーピングキーのフィールドインデックス |
| aggCalls | AggregateCall[] | Yes | N/A | 集約関数呼び出しの配列 |
| aggInputRowType | RowType | Yes | N/A | 集約入力の行型 |
| isMerge | boolean | Yes | N/A | 中間結果のマージかどうか |
| isFinal | boolean | Yes | N/A | 最終集約かどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソート済み入力ストリーム | RowData | グルーピングキーでソートされた集約対象データ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 集約結果ストリーム | RowData | グルーピングキーと集約結果を含むレコード（グルーピングキー順） |

### 出力ファイル仕様

ファイル出力なし（ストリーム出力のみ）

## 処理フロー

### 処理シーケンス

```
1. 入力変換の取得
   └─ ソート済み入力ストリームをTransformationとして取得
2. 入力型・出力型の取得
   └─ 入力RowTypeと出力RowTypeを取得
3. AggregateInfoListの構築
   └─ 集約関数情報をバッチ用に変換
4. コード生成
   └─ グルーピングキーの有無に応じて異なるジェネレーターを使用
   └─ grouping.length == 0: AggWithoutKeysCodeGenerator
   └─ grouping.length > 0: SortAggCodeGenerator
5. Transformationの作成
   └─ 生成されたオペレーターを使用してTransformationを作成
6. 結果の出力
   └─ 集約結果を後続ノードに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ソート済み入力ストリーム取得]
    B --> C[型情報取得]
    C --> D[AggregateInfoList構築]
    D --> E{グルーピングキー有無}
    E -->|なし| F[AggWithoutKeysCodeGenerator]
    E -->|あり| G[SortAggCodeGenerator]
    F --> H[Transformation作成]
    G --> H
    H --> I[グループ変化検出]
    I --> J[集約処理実行]
    J --> K[結果出力]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチノードはインメモリ処理であり、直接的なデータベース操作は行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalStateException | 入力順序エラー | 入力がソートされていない | 前段のソート処理を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Flinkジョブ設定に依存 |
| リトライ間隔 | Flinkジョブ設定に依存 |
| リトライ対象エラー | 一時的なリソース不足 |

### 障害時対応

ジョブ失敗時は、Flink Checkpointから再開するか、ジョブを最初から再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体（Flinkジョブ単位） |
| コミットタイミング | ジョブ完了時 |
| ロールバック条件 | ジョブ失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | データサイズに依存 |
| 目標処理時間 | クエリ複雑度とデータサイズに依存 |
| メモリ使用量上限 | グループ毎の状態のみ保持（ハッシュ集約より少ない） |

## 排他制御

同一ジョブ内で複数のタスクが並列実行される。各タスクは独立して処理を行い、明示的な排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Transformation作成時 | ノード情報、集約関数リスト |
| 進捗ログ | 処理中 | 処理件数、グループ数 |
| 終了ログ | 処理完了時 | 処理完了ステータス |
| エラーログ | エラー発生時 | エラー詳細、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | ジョブ設定に依存 | Flink監視システム |
| 処理件数 | データサイズに依存 | Flink監視システム |

## 備考

- ExecNodeMetadataにより、batch-exec-sort-aggregate（version 1）として登録
- InputSortedExecNodeインターフェースを実装し、入力がソートされていることを表明
- ハッシュ集約と異なり、管理メモリの確保は不要（Transformationにメモリ設定なし）
- Flink 2.0以降で使用可能（minPlanVersion、minStateVersion = v2_0）
